/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.cm;

import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.rest.service.UserProfileService;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;

public class UserProfile {
    private static final String JSON_CREDENTIALS = "credentials";
    private static final String JSON_ENCRYPTEDVALUE = "encryptedValue";
    private final RequestEnvironment runtime;

    public UserProfile(RequestEnvironment runtime) {
        this.runtime = runtime;
    }

    public String getCredentialsForDatasource(String datasource, String connectionName) {
        JSONArray entity;
        if (datasource == null) {
            return null;
        }
        RESTClientResponse resp = this.runtime.getUserProfileService().get(UserProfileService.UserProfileResource.USERS, null, UserProfileService.UserProfileSubResource.CREDENTIALS_DATASOURCES, null);
        if (resp.getResponseCode() == 200 && (entity = resp.getJSONArrayResponse()) != null) {
            return UserProfile.extractCredentials(datasource, connectionName, entity);
        }
        return null;
    }

    private static String extractCredentials(String datasource, String connectionName, JSONArray entity) {
        for (Object o : entity) {
            Object encrypedValue;
            JSONObject signon = (JSONObject)o;
            JSONObject credentials = (JSONObject)signon.get((Object)JSON_CREDENTIALS);
            if (credentials == null) continue;
            Object dsName = signon.get((Object)"dataSourceName");
            Object connName = signon.get((Object)"dataSourceConnectionName");
            if (dsName == null || !dsName.equals(datasource) || connName == null || !connName.equals(connectionName) || (encrypedValue = credentials.get((Object)JSON_ENCRYPTEDVALUE)) == null) continue;
            return encrypedValue.toString();
        }
        return null;
    }

    public JSONArray getUserCapabilities() {
        RESTClientResponse resp = this.runtime.getUserProfileService().get(UserProfileService.UserProfileResource.USERS, null, UserProfileService.UserProfileSubResource.CAPABILITIES, null);
        if (resp.getResponseCode() != 200) {
            return new JSONArray();
        }
        JSONObject jObj = resp.getJSONObjectResponse();
        if (jObj == null) {
            return new JSONArray();
        }
        return (JSONArray)jObj.get((Object)"userCapabilities");
    }
}

