/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.cm.kerberos;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.cclcfgapi.base64;
import com.cognos.xqe.data.providers.secbridge.CAMImpersonate;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.cm.AdminDatabaseService;
import com.ibm.bi.platform.moser.core.cm.kerberos.ICryptoDancer;
import com.ibm.bi.platform.moser.core.cm.kerberos.JCAMImpersonator;
import com.ibm.bi.platform.moser.core.rest.service.ModuleStorageCM;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.soap.services.CamException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.security.auth.login.LoginException;

public class CAMCryptoDancer
implements ICryptoDancer {
    private RequestEnvironment runtime;
    private JCAMImpersonator jCamHelper = null;
    private JCAMImpersonator.DelegatedCredential kerberosCredential;
    private String base64EncodedSecurityBlob;
    private static final String CAM_AUTH_NEGOTIATE = "camAuthNegotiate";

    public CAMCryptoDancer(RequestEnvironment runtime) {
        this.runtime = runtime;
    }

    @Override
    public JCAMImpersonator.DelegatedCredential getDelegatedCredentials(String dsName) {
        block5: {
            ModuleStorageCM cm = this.runtime.getModuleStorageCM();
            Locale productLocale = this.runtime.getProductLocale();
            try {
                cm.getCMObjectViaSoapBridge(AdminDatabaseService.buildSearchPath(dsName), AdminDatabaseService.DATASOURCE_FIELDS_LIST, null);
            }
            catch (CamException e) {
                LoggerAdapter.debug(this, "Got CamException from getDelegatedCredentials call: " + e.getLocalizedMessage());
                if (!CAM_AUTH_NEGOTIATE.equals(e.getErrorCode())) break block5;
                this.base64EncodedSecurityBlob = CAMCryptoDancer.extractSecurityBlob(e);
                LoggerAdapter.debug(this, "Got security blob: " + this.base64EncodedSecurityBlob);
                if (System.getProperty("os.name").toUpperCase().contains("WINDOW")) {
                    LoggerAdapter.debug(this, "WINDOWS OS recognized");
                    this.doNativeCryptoDance(dsName, productLocale);
                    try {
                        this.base64EncodedSecurityBlob = null;
                        cm.getCMObjectViaSoapBridge(AdminDatabaseService.buildSearchPath(dsName), AdminDatabaseService.DATASOURCE_FIELDS_LIST, this.base64EncodedSecurityBlob);
                    }
                    catch (CamException e1) {
                        this.base64EncodedSecurityBlob = CAMCryptoDancer.extractSecurityBlob(e1);
                        LoggerAdapter.debug(this, "CamException caught with security blob: " + this.base64EncodedSecurityBlob);
                    }
                }
                this.doCryptoDance(cm, dsName);
            }
        }
        return this.kerberosCredential;
    }

    @Override
    public String getCryptoHandleForIntegratedSecurity(String dsName, Locale productLocale) {
        block2: {
            ModuleStorageCM cm = this.runtime.getModuleStorageCM();
            try {
                cm.getCMObjectViaSoapBridge(AdminDatabaseService.buildSearchPath(dsName), AdminDatabaseService.DATASOURCE_FIELDS_LIST, null);
            }
            catch (CamException e) {
                LoggerAdapter.debug(this, "Got CamException from getCryptoHandleForIntegratedSecurity call: " + e.getLocalizedMessage());
                if (!CAM_AUTH_NEGOTIATE.equals(e.getErrorCode())) break block2;
                this.base64EncodedSecurityBlob = CAMCryptoDancer.extractSecurityBlob(e);
                return this.doNativeCryptoDance(dsName, productLocale);
            }
        }
        return null;
    }

    private static String extractSecurityBlob(CamException e) {
        JsonObject jObj = (JsonObject)e.getErrorDetails();
        if (jObj == null) {
            return null;
        }
        JsonObject promptInfo = (JsonObject)jObj.get("promptInfo");
        if (promptInfo == null) {
            return null;
        }
        return (String)promptInfo.get("securityBlob");
    }

    private void doCryptoDance(ModuleStorageCM cm, String dsName) {
        LoggerAdapter.debug(this, "Starting the crypto dance...");
        boolean done = false;
        while (!done) {
            try {
                this.base64EncodedSecurityBlob = this.getSecurityBlob(this.base64EncodedSecurityBlob);
                LoggerAdapter.debug(this, "Got security blob: " + this.base64EncodedSecurityBlob);
                this.base64EncodedSecurityBlob = CAMCryptoDancer.encodeSecurityBlob(this.base64EncodedSecurityBlob);
                LoggerAdapter.debug(this, "Encoded security blob: " + this.base64EncodedSecurityBlob);
                cm.getCMObjectViaSoapBridge(AdminDatabaseService.buildSearchPath(dsName), AdminDatabaseService.DATASOURCE_FIELDS_LIST, this.base64EncodedSecurityBlob);
                this.kerberosCredential = this.getDelegatedCredential();
                done = true;
            }
            catch (CamException e) {
                if (!CAM_AUTH_NEGOTIATE.equals(e.getErrorCode())) continue;
                this.base64EncodedSecurityBlob = CAMCryptoDancer.extractSecurityBlob(e);
            }
            catch (CAMCryptoException e1) {
                throw new MoserException((Throwable)e1);
            }
            catch (Exception e) {
                throw new MoserException((Throwable)e);
            }
        }
        LoggerAdapter.debug(this, "Finished the crypto dance...");
    }

    private String doNativeCryptoDance(String dsName, Locale productLocale) {
        LoggerAdapter.debug(this, "Starting native crypto dance...");
        ModuleStorageCM moduleStorageCM = this.runtime.getModuleStorageCM();
        String tmpCryptoHandleId = null;
        while (true) {
            try {
                LoggerAdapter.debug(this, "Generate Credential (native) calling CAMImpersonate.camImpUsrNegotiate");
                String camSecBlobCryptoHandle = this.getCryptoHandle(productLocale, tmpCryptoHandleId);
                int index = camSecBlobCryptoHandle.indexOf("<>");
                if (index == -1 || camSecBlobCryptoHandle.length() <= index + 2) {
                    LoggerAdapter.debug(this, "Generate Credential (native) Unexpected exception occurred while parsing camSecBlobCryptoHandle");
                    throw new MoserException(MoserError.MSR_WSB_CAM_NEGOTIATION_FAILURE);
                }
                this.base64EncodedSecurityBlob = CAMCryptoDancer.encodeSecurityBlob(camSecBlobCryptoHandle.substring(0, index));
                LoggerAdapter.debug(this, "Security blob from native dance: " + this.base64EncodedSecurityBlob);
                tmpCryptoHandleId = camSecBlobCryptoHandle.substring(index + 2);
                moduleStorageCM.getCMObjectViaSoapBridge(AdminDatabaseService.buildSearchPath(dsName), AdminDatabaseService.DATASOURCE_FIELDS_LIST, this.base64EncodedSecurityBlob);
                LoggerAdapter.debug(this, "Finished native crypto dance...");
                return tmpCryptoHandleId;
            }
            catch (CamException e) {
                if (!CAM_AUTH_NEGOTIATE.equals(e.getErrorCode())) continue;
                this.base64EncodedSecurityBlob = CAMCryptoDancer.extractSecurityBlob(e);
                continue;
            }
            catch (MoserException ex) {
                LoggerAdapter.error(this, "Unexpected exception: " + ex.toString());
                if (ex.getMessageKey() != MoserError.MSR_WSB_BRIDGE_INIT_ERROR) {
                    throw new MoserException(MoserError.MSR_WSB_CAM_NEGOTIATION_FAILURE, (Throwable)ex);
                }
                throw ex;
            }
            catch (Exception ex) {
                LoggerAdapter.error(this, "Unexpected exception: " + ex.toString());
                throw new MoserException(MoserError.MSR_WSB_CAM_NEGOTIATION_FAILURE, (Throwable)ex);
            }
            break;
        }
    }

    private static String encodeSecurityBlob(String securityBlob) {
        return base64.encode((int)0, (byte[])securityBlob.getBytes(StandardCharsets.UTF_8));
    }

    public String getCryptoHandle(Locale productLocale, String currentCryptoHandle) throws Exception {
        return CAMImpersonate.camImpUsrNegotiate(productLocale, this.base64EncodedSecurityBlob, currentCryptoHandle);
    }

    public String getSecurityBlob(String inSecurityBlob) {
        this.createJCAMHelper();
        return this.jCamHelper.camImpUsrNegotiate(inSecurityBlob);
    }

    private void createJCAMHelper() {
        if (this.jCamHelper == null) {
            try {
                this.jCamHelper = new JCAMImpersonator();
            }
            catch (CAMCryptoException | LoginException e1) {
                throw new MoserException(e1);
            }
        }
    }

    public JCAMImpersonator.DelegatedCredential getDelegatedCredential() throws Exception {
        this.createJCAMHelper();
        return this.jCamHelper.getDelegatedCredential();
    }
}

