/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.cm.kerberos;

import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ObjectPool<T> {
    private final int size;
    private final Queue<T> availableRecords;
    private final Queue<T> borrowedRecords;

    public ObjectPool() {
        this(0);
    }

    public ObjectPool(int maxSize) {
        this.size = maxSize;
        this.availableRecords = new ConcurrentLinkedQueue<T>();
        this.borrowedRecords = new ConcurrentLinkedQueue<T>();
    }

    public T borrow() {
        if (this.availableRecords.isEmpty()) {
            return null;
        }
        try {
            T record = this.availableRecords.remove();
            this.borrowedRecords.add(record);
            return record;
        }
        catch (NoSuchElementException e) {
            LoggerAdapter.error(ObjectPool.class, e.getLocalizedMessage(), e);
            return null;
        }
    }

    public void add(T record) {
        this.returnTo(record);
    }

    public void returnTo(T record) {
        if (record != null) {
            this.borrowedRecords.remove(record);
            if (this.size == 0 || this.availableRecords.size() < this.size) {
                this.availableRecords.add(record);
            }
        }
    }

    public List<T> release() {
        ArrayList<T> ans = new ArrayList<T>();
        ans.addAll(this.availableRecords);
        ans.addAll(this.borrowedRecords);
        this.availableRecords.clear();
        this.borrowedRecords.clear();
        return ans;
    }

    public int size() {
        return this.availableRecords.size();
    }

    public int borrowedSize() {
        return this.borrowedRecords.size();
    }
}

