/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.config;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.org.apache.hadoop.io.CryptoProvider;
import com.ibm.bi.org.apache.hadoop.io.ICryptoProvider;
import com.ibm.bi.platform.datasetutils.parquet.ParquetVersionEnum;
import com.ibm.bi.platform.moser.core.importer.CAMCryptoProvider;
import com.ibm.bi.platform.moser.core.metadata.config.MetadataEngineConfig;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.cognos.jmd.importer.JDBCImporter;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;

public class MoserConfig {
    private static final String INCORRECT_VALUE = "Incorrectly set value for config key: ";
    private static final String DEFAULT_ERROR_RESPONSE_CODES = "[300,301,302,303,305,306,307,400,401,402,403,405,406,407,408,410,411,412,413,414,415,416,417,441]";
    private static final int DEFAULT_PARQUET_BLOCK_SIZE = 0xA00000;
    private static final long DEFAULT_UPLOAD_TIMEOUT;
    private static final int DEFAULT_UPLOAD_FAILURES = 5;
    private static final String MOSER = "moser";
    public static final String OUTPUTDIR;
    public static final String BASE_CONTAINER = "modules.baseModules";
    public static final String DATASET_MAX_UPLOAD_SIZE = "DatasetService.maxUploadSizeMBytes";
    public static final String DATASET_MAX_STORAGE = "DatasetService.maxStorageMBytes";
    public static final String TOTAL_SIZE_OF_FILE = "totalSizeOfFile";
    public static final String TOTAL_SIZE_ON_DISK = "totalSizeOnDisk";
    public static final String MAX_UPLOAD_SIZE_B = "maxUploadSizeBytes";
    public static final String MAX_STORAGE_B = "maxStorageBytes";
    public static final String STATISTICS_MAX_TIME = "MOSER.IMPORT.ANALYSIS.STATISTICS.MAXTIME";
    public static final String COMMA = ",";
    private static final String ADVANCED_PROPERTIES = "advancedProperties";
    private static final String BASE_URL = "ModelingService.baseURL";
    private static final String TEMP = "temp";
    private static final String CONFIG_TEMP_DIR = "temp";
    private static final String DATASETSERVICE_CLEAN_COLUMN_LABELS = "DatasetService.cleanColumnLabels";
    private static final String DATASETSERVICE_CLEAN_TABLE_LABELS = "DatasetService.cleanTableLabels";
    private static final String DATASETSERVICE_ENABLEENCRYPTION = "DatasetService.enableEncryption";
    private static final String DATASETSERVICE_IMPORT_MULTISHEET = "DatasetService.importMultisheet";
    private static final String DATASETSERVICE_MAX_COLUMNS = "DatasetService.maxNumberOfColumns";
    private static final String DATASETSERVICE_TYPE_IN_SQL_MAX_COLUMNS = "DatasetService.typeInSQLMaxNumberOfColumns";
    private static final String DATASETSERVICE_PARQUET_VERSION = "DatasetService.parquetVersion";
    private static final String UPLOAD_TIMEOUT = "DatasetService.uploadTimeout";
    private static final String UPLOAD_FAILURES = "DatasetService.uploadFailures";
    private static final String ADVANCEDPROPERTY_DB_SAMPLING_SIZE = "//crn:parameter[@name='MOSER.IMPORT.ANALYSIS.DB.NUMROWS']/crn:value";
    private static final String ADVANCEDPROPERTY_FILE_SAMPLING_SIZE = "//crn:parameter[@name='MOSER.IMPORT.ANALYSIS.FILE.NUMROWS']/crn:value";
    private static final String ADVANCEDPROPERTY_DS_SAMPLING_SIZE = "//crn:parameter[@name='MOSER.IMPORT.ANALYSIS.DS.NUMROWS']/crn:value";
    private static final String ADVANCEDPROPERTY_STATISTICS_MAX_TIME;
    private static final String MODELINGSERVICE_DATAIMPORT_STRING_LENGTH_LIMIT = "ModelingService.dataimport.string-length-limit";
    private static final String STORE_MODULES_ZIPPED = "ModelingService.StoreModulesZipped";
    private static final String DEGREE_OF_PARALLELISM = "ModelingService.DegreeOfParallelism";
    private static final String DUMP_CSV2_PARQUET_INPUT = "ModelingService.DumpCsv2ParquetInput";
    private static final String PARQUET_BLOCK_SIZE = "ModelingService.parquetBlockSize";
    private static final String PARQUET_COMPRESSIONCODECNAME = "ModelingService.parquetCompressionCodecName";
    private static final String DB_CLEAN_LABELS = "ModelingService.dbDefaultCleanLabels";
    private static final String TABLE_FILTERS = "ModelingService.dbDefaultTableFilters";
    private static final String EXCLUDED_TABLES = "ModelingService.dbDefaultExcludeTables";
    private static final String IMPORT_PRIMARY_FOREIGN_KEYS = "ModelingService.dbDefaultImportPrimaryForeignKeys";
    private static final String DATA_STATISTICS = "ModelingService.dbDefaultDataStatistics";
    private static final String VERSION = "ModelingService.dbDefaultVersion";
    private static final String SUPPORTED_DATATYPES = "ModelingService.supportedDataTypes";
    private static final String DEFAULT_SUPPORTED_DATATYPES = "BIGINT,CHAR,CLOB,DATE,DECIMAL,DOUBLE,FLOAT,INTEGER,INTERVAL,LONG,LONGNVARCHAR,LONGVARCHAR,NCHAR,NCLOB,NUMERIC,NVARCHAR,REAL,SMALLINT,TIME,TIMESTAMP,TINYINT,VARCHAR,VARIANT";
    private static final String COLUMN_SPLIT_CONFIG = "ModelingService.ColumnSplitConfig";
    private static final String DATASET2_MODIFICATION_THRESHOLD = "ModelingService.dataset2ModificationThreshold";
    private static final String DATASET2_MAX_REFRESH_WAITTIME = "ModelingService.dataset2MaxRefreshWaitTime";
    private static final String ERROR_RESPONSE_CODES = "ModelingService.errorResponseCodes";
    private static final String RETRY_WITHOUT_ETAG = "ModelingService.retryWithoutETag";
    private static final String IMPORT_HANDLER_MAPPING = "ModelingService.importHandlerMapping";
    private static final String DEFAULT_IMPORT_HANDLER_MAPPING = "{\"com.ibm.bi.platform.moser.core.importer.jupyter.JupyterImportHandler\":{\"application/octet-stream\":[\"ipynb\"]},\"com.ibm.bi.platform.moser.core.importer.jupyter.GZipJupyterImportHandler\":{\"application/octet-stream\":[\"gz\",\"gzip\"],\"application/x-gzip\":[\"gz\",\"gzip\"]},\"com.ibm.bi.platform.moser.core.importer.jupyter.ZipJupyterImportHandler\":{\"application/octet-stream\":[\"zip\"],\"application/zip\":[\"*\"],\"application/x-zip-compressed\":[\"*\"]}}";
    private static final String LOG_OVERRIDE_NAME = "ModelingService.loggingOverride";
    private static final String LOG_OVERRIDE_LIST = "org.apache.parquet.hadoop.ColumnChunkPageWriteStore=SEVERE,org.apache.parquet.hadoop.InternalParquetRecordWriter=SEVERE,org.apache.parquet.hadoop.ParquetFileReader=SEVERE,org.apache.parquet.hadoop.InternalParquetRecordReader=SEVERE";
    private static final String LOGOUTDELAY = "ModelingService.logoutDelay";
    private static final long DEFAULT_LOGOUT_DELAY = 30000L;
    private static final String DB_BULK_LOAD_THRESHOLD = "ModelingService.dbBulkLoadThreshold";
    private static final double DEFAULT_DB_BULK_LOAD_THRESHOLD = 0.25;
    private static final String DB_IMPORT_MODE = "ModelingService.dbImportMode";
    private static final String DEFAULT_DB_IMPORT_MODE = "AUTOMATIC";
    private static final String USE_LEGACY_METADATA_ENGINE = "ModelingService.useLegacyMetadataEngine";
    private static final String DEFAULT_METADATA_ENGINE_CONFIG = "ModelingService.defaultMetadataEngineConfig";
    private static final String DEPENDENCY_SERVICE_CACHE_SIZE = "ModelingService.dependencyServiceCacheSize";
    private static final String DEPENDENCY_SERVICE_CACHE_EXPIRY = "ModelingService.dependencyServiceCacheExpiry";
    private static final String CONTENT_SERVICE_MAX_CONCURRENT_REQUESTS = "ModelingService.contentServiceMaxConcurrentRequests";
    private static final String OBJECT_TYPE_CACHE_SIZE = "ModelingService.objectTypeCacheSize";
    private static final String OBJECT_TYPE_CACHE_EXPIRY = "ModelingService.objectTypeCacheExpiry";
    private static final String VERSION_SERVICE_CACHE_SIZE = "ModelingService.versionServiceCacheSize";
    private static final String VERSION_SERVICE_CACHE_EXPIRY = "ModelingService.versionServiceCacheExpiry";
    private static final String PARQUET_CANCEL_INTERVAL = "ModelingService.parquetCancelInterval";
    private static final String WKC_USERESTCLIENT = "ModelingService.useRESTClientToWKC";
    private static final String WKC_TOKEN_EXPIRE = "ModelingService.WKCTokenExpire";
    private static final String WKC_CATALOG_LIMIT = "ModelingService.CatalogLimit";
    private static final String WKC_CREDENTIALS_LIMIT = "ModelingService.CredentialsLimit";
    private static final String SUPPORTED_MIME_TYPES = "ModelingService.supportedMimeTypes";
    private static final String DEFAULT_SUPPORTED_MIME_TYPES = "[\"application/vnd.ms-excel\",\"application/vnd.ms-excel+gzip\",\"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet+gzip\",\"application/vnd.ms-excel.sheet.macroenabled.12\",\"application/vnd.ms-excel.sheet.macroenabled.12+gzip\",\"application/csv\",\"application/csv+gzip\",\"text/csv\",\"text/csv+gzip\",\"text/tab-separated-values\",\"text/tab-separated-values+gzip\",\"text/plain\",\"text/plain+gzip\",\"application/gzip\",\"application/zip\",\"application/zip+gzip\"]";
    private static final String PROBE_UPLOADED_FILE = "ModelingService.probeUploadedFile";
    private final String mInstallRoot = MoserConfig.constructDir(System.getProperty("wlp.install.dir"), ".." + File.separator);
    private String mMoserSchemaDir = MoserConfig.constructDir(this.mInstallRoot, "schemas" + File.separator + "moser" + File.separator + "1.0" + File.separator);
    private String mMoserConfigDir;
    private String mMoserOutputDir;
    private String mBaseModulesDir = MoserConfig.constructDir(this.mInstallRoot, "data" + File.separator + "moser" + File.separator + "modules" + File.separator + "baseModules" + File.separator);
    private String mTempDir;
    private String moduleStorage;
    public static final String UPLOAD_RESOURCE = "upload";
    private static ArrayList<Logger> loggers;
    private static MoserConfig instance;
    private static String baseURL;

    private MoserConfig() {
        this.mMoserOutputDir = MoserConfig.constructDir(System.getProperty("wlp.install.dir"), OUTPUTDIR);
        this.mMoserConfigDir = MoserConfig.constructDir(this.mInstallRoot, "configuration" + File.separator + MOSER);
        this.moduleStorage = this.initStorage();
        this.mTempDir = MoserConfig.constructDir(this.mInstallRoot, "temp" + File.separator);
        try {
            if (MoserConfig.isEncryptionEnabled()) {
                CryptoProvider.initialize((ICryptoProvider)new CAMCryptoProvider());
            }
        }
        catch (Exception e) {
            LoggerAdapter.error((Object)this, "Failed to initialize crypto.", e);
        }
    }

    private static boolean getBooleanSetting(String id, boolean defaultValue) {
        try {
            return ConfigurationPropertyFactory.getInstance().getBooleanProperty(id, defaultValue).get();
        }
        catch (Exception e) {
            LoggerAdapter.error(MoserConfig.class, "Failed to get boolean value for config key: " + id, e);
            return defaultValue;
        }
    }

    private static double getDoubleSetting(String id, double defaultValue) {
        try {
            return ConfigurationPropertyFactory.getInstance().getDoubleProperty(id, defaultValue).get();
        }
        catch (Exception e) {
            LoggerAdapter.error(MoserConfig.class, "Failed to get double value for config key: " + id, e);
            return defaultValue;
        }
    }

    private static int getIntSetting(String id, int defaultValue) {
        try {
            return ConfigurationPropertyFactory.getInstance().getIntProperty(id, defaultValue).get();
        }
        catch (Exception e) {
            LoggerAdapter.error(MoserConfig.class, "Failed to get integer value for config key: " + id, e);
            return defaultValue;
        }
    }

    private static long getLongSetting(String id, long defaultValue) {
        try {
            return ConfigurationPropertyFactory.getInstance().getLongProperty(id, defaultValue).get();
        }
        catch (Exception e) {
            LoggerAdapter.error(MoserConfig.class, "Failed to get long value for config key: " + id, e);
            return defaultValue;
        }
    }

    private static String getStringSetting(String id, String defaultValue) {
        try {
            return ConfigurationPropertyFactory.getInstance().getStringProperty(id, defaultValue).get();
        }
        catch (Exception e) {
            LoggerAdapter.error(MoserConfig.class, "Failed to get String value for config key: " + id, e);
            return defaultValue;
        }
    }

    private static JSONObject getJSONObjectSetting(String id, String defaultValue) {
        String value = MoserConfig.getStringSetting(id, defaultValue);
        try {
            return JSONObject.parse((String)value);
        }
        catch (IOException e) {
            LoggerAdapter.error(MoserConfig.class, "Failed to parse JSONObject value for config key: " + id, e);
            return new JSONObject();
        }
    }

    private static JSONArray getJSONArraySetting(String id, String defaultValue) {
        String value = MoserConfig.getStringSetting(id, defaultValue);
        try {
            return JSONArray.parse((String)value);
        }
        catch (IOException e) {
            LoggerAdapter.error(MoserConfig.class, "Failed to parse JSONArray value for config key: " + id, e);
            return new JSONArray();
        }
    }

    private static JSONArray parseJSONArray(String id, String value, String defaultValue) {
        try {
            return JSONArray.parse((String)value);
        }
        catch (IOException e) {
            LoggerAdapter.error(MoserConfig.class, "Failed to parse JSONArray value for config key: " + id, e);
            if (!defaultValue.equals(value)) {
                try {
                    return JSONArray.parse((String)defaultValue);
                }
                catch (IOException e2) {
                    LoggerAdapter.error(MoserConfig.class, "Failed to parse default JSONArray value for config key: " + id, e2);
                }
            }
            return new JSONArray();
        }
    }

    private static int getIntAdvancedProperty(String id, int defaultValue) {
        String advancedProperties = MoserConfig.getStringSetting(ADVANCED_PROPERTIES, "");
        if (advancedProperties == null || advancedProperties.isEmpty()) {
            return defaultValue;
        }
        try {
            Document document = DocumentHelper.parseText((String)advancedProperties);
            Node node = document.selectSingleNode(id);
            if (node != null && !node.getText().isEmpty()) {
                return Integer.parseInt(node.getText());
            }
        }
        catch (Exception e) {
            LoggerAdapter.error(MoserConfig.class, "Failed to parse advancedProperties.", e);
        }
        return defaultValue;
    }

    public static int getMaxUploadSizeMBytes() {
        return MoserConfig.getIntSetting(DATASET_MAX_UPLOAD_SIZE, 100);
    }

    public static int getMaxStorageMBytes() {
        return MoserConfig.getIntSetting(DATASET_MAX_STORAGE, 10000);
    }

    public static int getMaxNumberOfColumns() {
        return MoserConfig.getIntSetting(DATASETSERVICE_MAX_COLUMNS, 2000);
    }

    public static int getTypeInSQLMaxNumberOfColumns() {
        return MoserConfig.getIntSetting(DATASETSERVICE_TYPE_IN_SQL_MAX_COLUMNS, 500);
    }

    public static boolean isEncryptionEnabled() {
        return MoserConfig.getBooleanSetting(DATASETSERVICE_ENABLEENCRYPTION, false);
    }

    public static String constructDir(String configDir, String subdir) {
        if (configDir != null) {
            return configDir + subdir;
        }
        return subdir;
    }

    public String getMoserOutputDirectory() {
        return this.mMoserOutputDir;
    }

    public String getMoserConfigDirectory() {
        return this.mMoserConfigDir;
    }

    public static MoserConfig getInstance() {
        return instance;
    }

    public String getBaseModulesDirectory() {
        return this.mBaseModulesDir;
    }

    public String getTempDirectory() {
        String tempDir = MoserConfig.getStringSetting("temp", null);
        if (tempDir == null) {
            return this.mTempDir;
        }
        if (tempDir.startsWith("..")) {
            tempDir = MoserConfig.constructDir(this.mInstallRoot, "bin64" + File.separator + tempDir);
        }
        if (!tempDir.endsWith("/") && !tempDir.endsWith("\\")) {
            tempDir = tempDir + File.separator;
        }
        return tempDir;
    }

    public String getTempUploadDirectory() {
        return MoserConfig.getInstance().getTempDirectory() + UPLOAD_RESOURCE + File.separator;
    }

    public String getSchemaDirectory() {
        return this.mMoserSchemaDir;
    }

    public void setMoserConfigDirectory(String directory) {
        this.mMoserConfigDir = MoserConfig.getPlatformPath(directory);
    }

    public void setBaseModulesDirectory(String directory) {
        this.mBaseModulesDir = MoserConfig.getPlatformPath(directory);
    }

    public void setTempDirectory(String directory) {
        this.mTempDir = MoserConfig.getPlatformPath(directory);
    }

    public void setMoserOutputDirectory(String directory) {
        this.mMoserOutputDir = MoserConfig.getPlatformPath(directory);
    }

    public void setMoserSchemaDirectory(String directory) {
        this.mMoserSchemaDir = MoserConfig.getPlatformPath(directory);
    }

    private String initStorage() {
        File f = new File(this.mMoserConfigDir + File.separator + "useFS");
        return f.exists() ? "toFile" : "toCM";
    }

    public static String getPlatformPath(String path) {
        String separator = "/";
        if (path.contains("\\")) {
            separator = "\\";
        }
        return path.replace(separator, File.separator);
    }

    public String getModuleStorage() {
        return this.moduleStorage;
    }

    public void setModuleStorage(String storageType) {
        this.moduleStorage = "toFile".equals(storageType) ? "toFile" : "toCM";
    }

    public static int getDBSamplingSize() {
        return MoserConfig.getIntAdvancedProperty(ADVANCEDPROPERTY_DB_SAMPLING_SIZE, 1000);
    }

    public static int getFileSamplingSize() {
        return MoserConfig.getIntAdvancedProperty(ADVANCEDPROPERTY_FILE_SAMPLING_SIZE, 1000);
    }

    public static int getDatasetSamplingSize() {
        return MoserConfig.getIntAdvancedProperty(ADVANCEDPROPERTY_DS_SAMPLING_SIZE, 1000);
    }

    public static int getMaxTimeStatistics() {
        return MoserConfig.getIntAdvancedProperty(ADVANCEDPROPERTY_STATISTICS_MAX_TIME, 900);
    }

    public static int getDegreeOfParallelism() {
        return MoserConfig.getIntSetting(DEGREE_OF_PARALLELISM, 5);
    }

    public String getSupportedDataTypes() {
        StringBuilder result = new StringBuilder(COMMA);
        result.append(MoserConfig.getStringSetting(SUPPORTED_DATATYPES, DEFAULT_SUPPORTED_DATATYPES));
        result.append(COMMA);
        return result.toString();
    }

    public static int getStringLengthLimit() {
        return MoserConfig.getIntSetting(MODELINGSERVICE_DATAIMPORT_STRING_LENGTH_LIMIT, 5000);
    }

    public static boolean getStoreModuleZipped() {
        return MoserConfig.getBooleanSetting(STORE_MODULES_ZIPPED, true);
    }

    public static String getCSV2ParquetDumpFile() {
        return MoserConfig.getStringSetting(DUMP_CSV2_PARQUET_INPUT, null);
    }

    public static JSONArray getDBTableFilters() {
        return MoserConfig.getJSONArraySetting(TABLE_FILTERS, "[]");
    }

    public static JSONArray getDBExcludedTables() {
        return MoserConfig.getJSONArraySetting(EXCLUDED_TABLES, "[]");
    }

    public static boolean getDBImportPrimaryForeignKeys() {
        return MoserConfig.getBooleanSetting(IMPORT_PRIMARY_FOREIGN_KEYS, true);
    }

    public static String getDBDataStatistics() {
        return MoserConfig.getStringSetting(DATA_STATISTICS, "all");
    }

    public static String getDBVersion() {
        return MoserConfig.getStringSetting(VERSION, "1.0");
    }

    public static JSONObject getDBSpecification() {
        JSONObject specification = new JSONObject();
        specification.put((Object)"prettifyLabels", (Object)MoserConfig.getDBCleanLabels());
        specification.put((Object)"dataStatistics", (Object)MoserConfig.getDBDataStatistics());
        specification.put((Object)"dataSamplingSize", (Object)MoserConfig.getDBSamplingSize());
        specification.put((Object)"importPrimaryForeignKeys", (Object)MoserConfig.getDBImportPrimaryForeignKeys());
        JSONArray tableFilters = MoserConfig.getDBTableFilters();
        if (!tableFilters.isEmpty()) {
            specification.put((Object)"tableFilters", (Object)tableFilters);
        }
        specification.put((Object)"excludedTables", (Object)MoserConfig.getDBExcludedTables());
        specification.put((Object)"version", (Object)MoserConfig.getDBVersion());
        return specification;
    }

    public static void completeDBSpecification(JSONObject spec) {
        JSONArray tableFilters;
        if (spec.get((Object)"prettifyLabels") == null) {
            spec.put((Object)"prettifyLabels", (Object)MoserConfig.getDBCleanLabels());
        }
        if (spec.get((Object)"dataStatistics") == null) {
            spec.put((Object)"dataStatistics", (Object)MoserConfig.getDBDataStatistics());
        }
        if (spec.get((Object)"dataSamplingSize") == null) {
            spec.put((Object)"dataSamplingSize", (Object)MoserConfig.getDBSamplingSize());
        }
        if (spec.get((Object)"importPrimaryForeignKeys") == null) {
            spec.put((Object)"importPrimaryForeignKeys", (Object)MoserConfig.getDBImportPrimaryForeignKeys());
        }
        if (spec.get((Object)"tableFilters") == null && !(tableFilters = MoserConfig.getDBTableFilters()).isEmpty()) {
            spec.put((Object)"tableFilters", (Object)tableFilters);
        }
        if (spec.get((Object)"includedTables") == null && spec.get((Object)"excludedTables") == null) {
            spec.put((Object)"excludedTables", (Object)MoserConfig.getDBExcludedTables());
        }
        if (spec.get((Object)"version") == null) {
            spec.put((Object)"version", (Object)MoserConfig.getDBVersion());
        }
    }

    public static String getColumnSplitConfig() {
        return MoserConfig.getStringSetting(COLUMN_SPLIT_CONFIG, "{}");
    }

    public static String getBaseURL() {
        if (baseURL == null) {
            String url;
            baseURL = url = MoserConfig.getStringSetting(BASE_URL, "/bi/v1");
        }
        return baseURL;
    }

    public static int getParquetBlockSize() {
        return MoserConfig.getIntSetting(PARQUET_BLOCK_SIZE, 0xA00000);
    }

    public static CompressionCodecName getParquetCompressionCodecName() {
        return CompressionCodecName.valueOf((String)MoserConfig.getStringSetting(PARQUET_COMPRESSIONCODECNAME, "GZIP"));
    }

    public static int getDataset2LastModifiedThreshold() {
        return MoserConfig.getIntSetting(DATASET2_MODIFICATION_THRESHOLD, 300000);
    }

    public static int getMaxWaitTimeDataset2Refresh() {
        return MoserConfig.getIntSetting(DATASET2_MAX_REFRESH_WAITTIME, 60000);
    }

    public static long getUploadTimeout() {
        return MoserConfig.getLongSetting(UPLOAD_TIMEOUT, DEFAULT_UPLOAD_TIMEOUT);
    }

    public static int getUploadFailures() {
        return MoserConfig.getIntSetting(UPLOAD_FAILURES, 5);
    }

    public static boolean getImportMultisheet() {
        return MoserConfig.getBooleanSetting(DATASETSERVICE_IMPORT_MULTISHEET, true);
    }

    public static ParquetVersionEnum getParquetVersion() {
        try {
            return ParquetVersionEnum.valueOf((String)MoserConfig.getStringSetting(DATASETSERVICE_PARQUET_VERSION, ParquetVersionEnum.VERSION_1.getValue()));
        }
        catch (Exception e) {
            LoggerAdapter.errorExceptionStack(MoserConfig.class, e);
            return ParquetVersionEnum.VERSION_1;
        }
    }

    public static Map<String, Object> createParquetConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("block_size", MoserConfig.getParquetBlockSize());
        config.put("compression_codec", MoserConfig.getParquetCompressionCodecName());
        config.put("encryptionEnabled", MoserConfig.isEncryptionEnabled());
        return config;
    }

    public static boolean getFileCleanTableLabels() {
        return MoserConfig.getBooleanSetting(DATASETSERVICE_CLEAN_TABLE_LABELS, true);
    }

    public static boolean getFileCleanColumnLabels() {
        return MoserConfig.getBooleanSetting(DATASETSERVICE_CLEAN_COLUMN_LABELS, true);
    }

    public static boolean getDBCleanLabels() {
        return MoserConfig.getBooleanSetting(DB_CLEAN_LABELS, true);
    }

    public static Set<Integer> getErrorResponseCodes() {
        HashSet<Integer> result = new HashSet<Integer>();
        JSONArray values = MoserConfig.getJSONArraySetting(ERROR_RESPONSE_CODES, DEFAULT_ERROR_RESPONSE_CODES);
        for (Object o : values) {
            Long value = (Long)o;
            result.add(value.intValue());
        }
        return result;
    }

    public static boolean getRetryWithoutEtag() {
        return MoserConfig.getBooleanSetting(RETRY_WITHOUT_ETAG, false);
    }

    public static JSONObject getImportHandlerMapping() {
        return MoserConfig.getJSONObjectSetting(IMPORT_HANDLER_MAPPING, DEFAULT_IMPORT_HANDLER_MAPPING);
    }

    public static long getDefaultLogoutDelay() {
        return MoserConfig.getLongSetting(LOGOUTDELAY, 30000L);
    }

    public static double getDBBulkLoadThreshold() {
        double value = MoserConfig.getDoubleSetting(DB_BULK_LOAD_THRESHOLD, 0.25);
        if (value < 0.0) {
            LoggerAdapter.error(MoserConfig.class, "Incorrectly set value for config key: ModelingService.dbBulkLoadThreshold Minimum value is 0.");
            return 0.0;
        }
        if (value > 1.0) {
            LoggerAdapter.error(MoserConfig.class, "Incorrectly set value for config key: ModelingService.dbBulkLoadThreshold Maximum value is 1.");
            return 1.0;
        }
        return value;
    }

    public static JDBCImporter.ImportMode getDBImportMode() {
        String mode = MoserConfig.getStringSetting(DB_IMPORT_MODE, DEFAULT_DB_IMPORT_MODE);
        try {
            return JDBCImporter.ImportMode.valueOf((String)mode);
        }
        catch (IllegalArgumentException e) {
            LoggerAdapter.error(MoserConfig.class, "Incorrectly set value for config key: ModelingService.dbImportMode", e);
            return JDBCImporter.ImportMode.valueOf((String)DEFAULT_DB_IMPORT_MODE);
        }
    }

    public static boolean getUseLegacyMetadataEngine() {
        return MoserConfig.getBooleanSetting(USE_LEGACY_METADATA_ENGINE, true);
    }

    public static String getDefaultMetadataEngineConfigString() {
        return MoserConfig.getStringSetting(DEFAULT_METADATA_ENGINE_CONFIG, MetadataEngineConfig.DEFAULT);
    }

    public static MetadataEngineConfig getDefaultMetadataEngineConfig() {
        return new MetadataEngineConfig(MoserConfig.getDefaultMetadataEngineConfigString());
    }

    public static boolean useRESTClientToWKC() {
        return MoserConfig.getBooleanSetting(WKC_USERESTCLIENT, true);
    }

    public static long getWKCTokenExpireInterval() {
        return MoserConfig.getLongSetting(WKC_TOKEN_EXPIRE, 3300000L);
    }

    public static long getWKCCatalogLimit() {
        return MoserConfig.getLongSetting(WKC_CATALOG_LIMIT, 50L);
    }

    public static long getWKCCredentialsLimit() {
        return MoserConfig.getLongSetting(WKC_CREDENTIALS_LIMIT, 50L);
    }

    public static long getDependencyServiceCacheSize() {
        return MoserConfig.getLongSetting(DEPENDENCY_SERVICE_CACHE_SIZE, 500L);
    }

    public static long getDependencyServiceCacheExpiry() {
        return MoserConfig.getLongSetting(DEPENDENCY_SERVICE_CACHE_EXPIRY, 600L);
    }

    public static int getContentServiceMaxConcurrentRequests() {
        return MoserConfig.getIntSetting(CONTENT_SERVICE_MAX_CONCURRENT_REQUESTS, 20);
    }

    public static long getObjectTypeCacheSize() {
        return MoserConfig.getLongSetting(OBJECT_TYPE_CACHE_SIZE, 500L);
    }

    public static long getObjectTypeCacheExpiry() {
        return MoserConfig.getLongSetting(OBJECT_TYPE_CACHE_EXPIRY, 600L);
    }

    public static long getParquetCancelInterval() {
        return MoserConfig.getLongSetting(PARQUET_CANCEL_INTERVAL, 10000L);
    }

    public static long getVersionServiceCacheSize() {
        return MoserConfig.getLongSetting(VERSION_SERVICE_CACHE_SIZE, 500L);
    }

    public static long getVersionServiceCacheExpiry() {
        return MoserConfig.getLongSetting(VERSION_SERVICE_CACHE_EXPIRY, 5L);
    }

    public static long getXQEModuleLifetime() {
        return MoserConfig.getLongSetting("ModelingService._XQE_module_life_time", -1L);
    }

    public static boolean getXQEEmbeddedModuleOnly() {
        return MoserConfig.getBooleanSetting("ModelingService._XQE_embedded_module_only", false);
    }

    public static Set<String> getSupportedMimeTypes() {
        String value = MoserConfig.getStringSetting(SUPPORTED_MIME_TYPES, DEFAULT_SUPPORTED_MIME_TYPES).toLowerCase(Locale.ENGLISH);
        JSONArray values = MoserConfig.parseJSONArray(SUPPORTED_MIME_TYPES, value, DEFAULT_SUPPORTED_MIME_TYPES);
        return new HashSet<String>((Collection<String>)values);
    }

    public static boolean getProbeUploadedFile() {
        return MoserConfig.getBooleanSetting(PROBE_UPLOADED_FILE, true);
    }

    static {
        String[] classes;
        DEFAULT_UPLOAD_TIMEOUT = Duration.ofMinutes(10L).toMillis();
        OUTPUTDIR = ".." + File.separator + "data" + File.separator + MOSER + File.separator;
        ADVANCEDPROPERTY_STATISTICS_MAX_TIME = String.format("//crn:parameter[@name='%s']/crn:value", STATISTICS_MAX_TIME);
        loggers = new ArrayList();
        String value = MoserConfig.getStringSetting(LOG_OVERRIDE_NAME, LOG_OVERRIDE_LIST);
        for (String s : classes = value.split(COMMA)) {
            String[] pairKeyValue = s.split("=");
            if (pairKeyValue.length != 2) {
                LoggerAdapter.error(MoserConfig.class, "Failed to override logging: " + s);
                continue;
            }
            Logger logger = Logger.getLogger(pairKeyValue[0].trim());
            try {
                logger.setLevel(Level.parse(pairKeyValue[1].trim()));
                loggers.add(logger);
            }
            catch (IllegalArgumentException e) {
                LoggerAdapter.error(MoserConfig.class, "Unknown logging level value '" + pairKeyValue[1] + "' for class '" + pairKeyValue[0] + "'", e);
            }
        }
        instance = new MoserConfig();
        baseURL = null;
    }
}

