/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.importer;

import com.ibm.bi.platform.moser.core.importer.IImportHandler;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.tasks.upload.UploadTask;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;

public abstract class AbstractImportHandler
implements IImportHandler {
    public static final String WILDCARD = "*";
    protected final RequestEnvironment requestEnv;
    protected final JSONObject mimeTypeAndExtensions;

    public AbstractImportHandler(RequestEnvironment requestEnv) {
        this.requestEnv = requestEnv;
        this.mimeTypeAndExtensions = AbstractImportHandler.getSupportedMimeTypes(this.getClass());
    }

    protected static JSONObject getSupportedMimeTypes(Class<?> clazz) {
        JSONObject allMappings = UploadTask.HANDLER_MAPPINGS;
        JSONObject mappings = (JSONObject)allMappings.get((Object)clazz.getCanonicalName());
        return mappings == null ? new JSONObject() : mappings;
    }

    @Override
    public boolean isSupported(String mimeType, String fileName) {
        return AbstractImportHandler.isSupported(this.mimeTypeAndExtensions, mimeType, fileName);
    }

    @Override
    public boolean isReallySupported(String mimeType, String fileName, InputStream data) {
        return AbstractImportHandler.isSupported(this.mimeTypeAndExtensions, mimeType, fileName);
    }

    protected static boolean isSupported(JSONObject mimeTypeAndExtensions, String mimeType, String fileName) {
        JSONArray extensions = (JSONArray)mimeTypeAndExtensions.get((Object)mimeType);
        if (extensions == null) {
            return false;
        }
        String ext = FilenameUtils.getExtension((String)fileName).toLowerCase();
        return extensions.contains((Object)ext) || extensions.contains((Object)WILDCARD);
    }
}

