/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.importer.dataset;

import com.ibm.bi.org.apache.hadoop.io.ConfigFactory;
import com.ibm.bi.platform.commons.shared.DeleteOnCloseFileInputStream;
import com.ibm.bi.platform.datasetutils.converters.RSVPCsvToParquetConverter;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.importer.dataset.DatasetDescriptor;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Providers;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.wink.common.model.multipart.BufferedOutMultiPart;
import org.apache.wink.common.model.multipart.InMultiPart;
import org.apache.wink.common.model.multipart.InPart;
import org.apache.wink.common.model.multipart.OutPart;
import org.dom4j.DocumentException;

public class DatasetHandler
implements Closeable {
    public static final String SEP = "\r\n";
    private RequestEnvironment requestEnv;
    private InMultiPart inMP;
    private RSVPCsvToParquetConverter pc;
    private File parquetFile;
    private String dumpInput;

    public DatasetHandler(RequestEnvironment requestEnv, InMultiPart inMP) {
        this.requestEnv = requestEnv;
        this.inMP = inMP;
        this.dumpInput = MoserConfig.getCSV2ParquetDumpFile();
    }

    public Object build() {
        try {
            this.parquetFile = MoserUtil.createTempFile("csv2_", ".parquet");
            DatasetDescriptor descriptor = new DatasetDescriptor();
            descriptor.setDataFile(this.parquetFile.getAbsolutePath());
            descriptor.setVersion(MoserConfig.getParquetVersion());
            this.pc = new RSVPCsvToParquetConverter.Builder(descriptor.getDataFile()).setOutputFilePQVersion(descriptor.getVersion()).build();
            while (this.inMP.hasNext()) {
                InPart part = this.inMP.next();
                this.processPart(descriptor, part);
            }
            return DatasetHandler.createBOMP(descriptor);
        }
        catch (Exception e) {
            FileUtils.deleteQuietly((File)this.parquetFile);
            LoggerAdapter.errorExceptionStack(this, e);
            return MoserUtil.getResponse(Response.Status.INTERNAL_SERVER_ERROR, MoserError.FAILED_CREATE_DATASET, this.requestEnv.getProductLocale(), e.getLocalizedMessage(), e);
        }
    }

    private void processPart(DatasetDescriptor descriptor, InPart part) throws DocumentException, IOException {
        String contentType = part.getContentType();
        try (InputStream is = this.getInputStream(part, contentType);){
            if ("text/xml".equals(contentType)) {
                int numColumns = this.pc.initialize(is, MoserConfig.createParquetConfig());
                descriptor.setNumberOfColumns(numColumns);
            } else if ("text/csv".equals(contentType)) {
                int numRows = this.pc.convert(is, StandardCharsets.UTF_8);
                descriptor.setNumberOfRows(numRows);
            }
        }
    }

    private InputStream getInputStream(InPart part, String contentType) throws IOException {
        InputStream is = part.getInputStream();
        InputStream inputStream = is = DatasetHandler.isPartCompressed(part) ? new GZIPInputStream(is) : is;
        if (this.dumpInput != null && !this.dumpInput.isEmpty()) {
            String extension = "text/xml".equals(contentType) ? ".xml" : ".csv";
            File tempFile = MoserUtil.createTempFile(this.dumpInput, extension);
            try (FileOutputStream fos = new FileOutputStream(tempFile);){
                IOUtils.copy((InputStream)is, (OutputStream)fos);
            }
            is.close();
            is = new FileInputStream(tempFile);
        }
        return is;
    }

    private static Object createBOMP(DatasetDescriptor descriptor) throws FileNotFoundException {
        BufferedOutMultiPart bomp = new BufferedOutMultiPart(){

            public void write(OutputStream os, Providers providers) throws IOException {
                Iterator it = this.getIterator();
                while (it.hasNext()) {
                    OutPart p = (OutPart)it.next();
                    os.write(("--" + this.getBoundary() + DatasetHandler.SEP).getBytes(StandardCharsets.UTF_8));
                    p.writePart(os, providers);
                    os.write(DatasetHandler.SEP.getBytes(StandardCharsets.UTF_8));
                }
                os.write(("--" + this.getBoundary() + "--" + DatasetHandler.SEP).getBytes(StandardCharsets.UTF_8));
            }
        };
        MyPart opJSON = new MyPart();
        opJSON.setBody(descriptor.getJson());
        opJSON.setContentType("application/json");
        bomp.addPart((OutPart)opJSON);
        MyPart opParquet = new MyPart();
        opParquet.setBody(new DeleteOnCloseFileInputStream(descriptor.getDataFile()));
        opParquet.setContentType("application/vnd.ibm.bi.pq");
        bomp.addPart((OutPart)opParquet);
        return bomp;
    }

    private static boolean isPartCompressed(InPart part) {
        if (part.getHeadersName().contains("Content-Encoding")) {
            return "gzip".equalsIgnoreCase((String)part.getHeaders().getFirst((Object)"Content-Encoding"));
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.pc != null) {
            this.pc.release();
            this.pc = null;
        }
    }

    static {
        ConfigFactory.initFactory((ConfigFactory)new ConfigFactory(){

            public boolean isEncryptionEnabled() {
                return MoserConfig.isEncryptionEnabled();
            }
        });
    }

    private static class MyPart
    extends OutPart {
        public void writePart(OutputStream os, Providers providers) throws IOException {
            for (String name : this.getHeaders().keySet()) {
                List values = (List)this.getHeaders().get((Object)name);
                for (String value : values) {
                    String header = name + ": " + value + DatasetHandler.SEP;
                    os.write(header.getBytes(StandardCharsets.UTF_8));
                }
            }
            os.write(DatasetHandler.SEP.getBytes(StandardCharsets.UTF_8));
            this.writeBody(os, providers);
        }
    }
}

