/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.importer.file;

import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.importer.file.FileDataCollector;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CollectorsCache
implements FileDataCollector.TimeoutListener {
    private static volatile CollectorsCache instance = null;
    private Map<String, FileDataCollector> cache = new ConcurrentHashMap<String, FileDataCollector>();
    int nConsecutiveFailures;
    int nConsecutiveFailuresLimit = MoserConfig.getUploadFailures();

    private CollectorsCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CollectorsCache getInstance() {
        if (instance != null) return instance;
        Class<CollectorsCache> clazz = CollectorsCache.class;
        synchronized (CollectorsCache.class) {
            if (instance != null) return instance;
            instance = new CollectorsCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void put(String key, FileDataCollector collector) {
        this.cache.put(key, collector);
        collector.addTimeoutListener(this);
    }

    @Override
    public void timeoutCallback(String dataCollectorId) {
        boolean uploadCompleted;
        FileDataCollector c = this.cache.remove(dataCollectorId);
        if (c == null) {
            return;
        }
        boolean bl = uploadCompleted = !c.internalError;
        this.nConsecutiveFailures = !uploadCompleted ? ++this.nConsecutiveFailures : 0;
    }

    public FileDataCollector get(String dataCollectorTaskID) {
        return this.cache.get(dataCollectorTaskID);
    }

    public boolean isHealthy() {
        return this.nConsecutiveFailures < this.nConsecutiveFailuresLimit;
    }
}

