/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.importer.file;

import com.ibm.bi.platform.datasetutils.metadata.ColumnMetadata;
import com.ibm.bi.platform.datasetutils.metadata.RowSchema;
import com.ibm.bi.platform.datasetutils.metadata.TabularRowSchema;
import com.ibm.bi.platform.datasetutils.metadata.types.EIntrinsicType;
import com.ibm.bi.platform.datasetutils.parquet.DatasetParquetReadHelper;
import com.ibm.bi.platform.datasetutils.parquet.DatasetParquetReaderBuilder;
import com.ibm.bi.platform.datasetutils.parquet.DatasetParquetWriterFactory;
import com.ibm.bi.platform.datasetutils.parquet.ParquetVersionEnum;
import com.ibm.bi.platform.datasetutils.utils.ReadableRecord;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.importer.file.FileDatasetBuilder;
import com.ibm.bi.platform.moser.core.importer.file.FileImportHandler;
import com.ibm.bi.platform.moser.core.importer.file.FileReadableRecord;
import com.ibm.bi.platform.moser.core.tasks.BaseMoserTask;
import com.ibm.bi.platform.moser.core.tasks.TaskStatus;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.neo.dataimport.ImportService;
import com.ibm.neo.dataimport.api.WAStorageException;
import com.ibm.neo.dataimport.deploy.DatasetDeployer;
import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.storage.IRowWriter;
import com.ibm.neo.dataimport.storage.IStreamingRowWriter;
import java.io.IOException;
import java.util.Map;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.Path;

public class FileAppendDatasetBuilder
extends FileDatasetBuilder {
    private boolean appendingToLegacyFile = false;

    public FileAppendDatasetBuilder(String storageLocation, TaskStatus taskStatus, ParquetVersionEnum version, boolean appendingToLegacyFile) {
        super(storageLocation, taskStatus, version);
        this.appendingToLegacyFile = appendingToLegacyFile;
    }

    public long createDataset(Path oldParquet, Dataset dataset) throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.file.impl", "shaded.org.apache.hadoop.fs.RawLocalFileSystem");
        DatasetParquetReadHelper readHelper = new DatasetParquetReadHelper();
        readHelper.readFooter(oldParquet, conf);
        Map keyValue = readHelper.getKeyValueMetadata();
        String value = (String)keyValue.get("parquet.ca.version");
        RowSchema oldSchema = readHelper.getRecordSchema();
        if (this.appendingToLegacyFile && oldSchema != null) {
            JSONObject row_id_column = JSONObject.parse((String)"{\"name\":\"_row_id\",\"nullable\":true,\"type\":{\"intrinsicType\":\"LONG\",\"cclTypeCode\":8,\"xqeType\":\"BIGINT\"}}");
            JSONObject schema = oldSchema.toJson();
            if (schema != null) {
                JSONArray columns = (JSONArray)schema.get((Object)"columns");
                columns.add(0, (Object)row_id_column);
                oldSchema = TabularRowSchema.fromJson((JSONObject)schema);
            }
        }
        long[] rowCount = new long[]{0L};
        try (ParquetReader reader = new DatasetParquetReaderBuilder(oldParquet).withParquetVersion(ParquetVersionEnum.VERSION_1.toString().equals(value) ? ParquetVersionEnum.VERSION_1 : ParquetVersionEnum.LEGACY).withConf(conf).build();
             ParquetWriter writer = DatasetParquetWriterFactory.create((Path)new Path(this.storageLocation + FileImportHandler.generateFileName(dataset.getName())), (RowSchema)oldSchema, (ParquetVersionEnum)this.version, (Map)this.config);){
            long appendCancelInterval = MoserConfig.getParquetCancelInterval();
            ReadableRecord record = (ReadableRecord)reader.read();
            while (record != null) {
                if (rowCount[0] % appendCancelInterval == 0L) {
                    BaseMoserTask.throwIfCancelled(this.taskStatus, "file upload");
                }
                record = this.adjustRecord(record, oldSchema, rowCount[0]);
                writer.write((Object)record);
                rowCount[0] = rowCount[0] + 1L;
                record = (ReadableRecord)reader.read();
            }
            ImportService is = ImportService.getInstance();
            DatasetDeployer datasetDeployer = new DatasetDeployer(is, is.getStorageService());
            datasetDeployer.setDataset(dataset);
            IRowWriter rowWriter = this.getRowWriter((ParquetWriter<ReadableRecord>)writer, rowCount, null);
            IStreamingRowWriter streamingRowWriter = datasetDeployer.getStreamingRowWriter();
            streamingRowWriter.write(rowWriter);
        }
        return rowCount[0];
    }

    @Override
    protected IRowWriter getRowWriter(final ParquetWriter<ReadableRecord> writer, final long[] rowCount, boolean[] nullables) {
        return new IRowWriter(){
            private FileReadableRecord record = new FileReadableRecord(1L);
            private final long appendCancelInterval = MoserConfig.getParquetCancelInterval();

            public void write(IValue[] tupleValues) throws WAStorageException {
                if (rowCount[0] % this.appendCancelInterval == 0L) {
                    BaseMoserTask.throwIfCancelled(FileAppendDatasetBuilder.this.taskStatus, "file upload");
                }
                tupleValues[0] = ValueFactory.createLong((long)rowCount[0]);
                this.record.setRecord(tupleValues);
                try {
                    writer.write((Object)this.record);
                    rowCount[0] = rowCount[0] + 1L;
                }
                catch (IOException e) {
                    throw new WAStorageException((Throwable)e);
                }
            }

            public void close() throws WAStorageException {
            }
        };
    }

    private ReadableRecord adjustRecord(ReadableRecord record, RowSchema oldSchema, long rowNumber) {
        if (!this.appendingToLegacyFile) {
            return record;
        }
        FileReadableRecord aRecord = new FileReadableRecord(1L);
        IValue[] tuple = new IValue[oldSchema.getNumOfColumns()];
        tuple[0] = ValueFactory.createLong((long)rowNumber);
        for (int i = 1; i < tuple.length; ++i) {
            ColumnMetadata md = oldSchema.getColumnMetadata(i);
            EIntrinsicType type = md.getType().getIntrinsicType();
            tuple[i] = FileAppendDatasetBuilder.getIValue(record, md, type, i - 1);
        }
        aRecord.setRecord(tuple);
        return aRecord;
    }
}

