/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.importer.file;

import com.ibm.bi.platform.datasetutils.parquet.ParquetVersionEnum;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.Column;
import com.ibm.bi.platform.moser.common.generated.metadata.DataSource;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.Table;
import com.ibm.bi.platform.moser.common.generated.metadata.TableItemType;
import com.ibm.bi.platform.moser.common.utils.FileUploadException;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.importer.file.FileAppendDatasetBuilder;
import com.ibm.bi.platform.moser.core.importer.file.FileAppendValidator;
import com.ibm.bi.platform.moser.core.importer.file.FileRefreshHandler;
import com.ibm.bi.platform.moser.core.module.IModuleObjectManager;
import com.ibm.bi.platform.moser.core.rest.service.ModuleStorageCM;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.tasks.BaseMoserTask;
import com.ibm.bi.platform.moser.core.tasks.FileImportUtils;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.nodel.ds.UploadDataSource;
import com.ibm.neo.dataimport.nodel.ops.AnalyzeResult;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.core.Response;
import shaded.org.apache.hadoop.fs.Path;

public class FileAppendHandler
extends FileRefreshHandler {
    public static final String ROW_ID = "_row_id";
    protected boolean appendingToLegacyFile = false;

    public FileAppendHandler(RequestEnvironment requestEnv) {
        super(requestEnv);
    }

    @Override
    protected Module getExisitingPhysicalModule(IModuleObjectManager mm) {
        JSONObject existingBM = mm.getUploadedFileJSON(this.uploadedFileId);
        if (existingBM == null) {
            throw new FileUploadException(MoserError.MSR_UPL_FILEUPLOADID_NOT_EXIST, this.uploadedFileId, "");
        }
        String physicalDefinition = (String)existingBM.get((Object)"physicalDefinition");
        if (physicalDefinition == null) {
            throw new FileUploadException(MoserError.MSR_UPL_FILEUPLOADID_NOT_EXIST, this.uploadedFileId, "");
        }
        return (Module)MoserUtil.decode(Module.class, physicalDefinition);
    }

    @Override
    protected void generatePhysicalModuleAndParquet(Module existingPhysicalModule, String existingFileName, File tmpDir, UploadDataSource dataSource, AnalyzeResult analyzeResult, ParquetVersionEnum version) throws Exception {
        this.detectRowIdLegacyFile(existingPhysicalModule);
        this.physicalModule = this.buildPhysicalModule(existingFileName, analyzeResult, null, null);
        FileAppendValidator validator = new FileAppendValidator(this.requestEnv, existingPhysicalModule, this.physicalModule, this.appendingToLegacyFile);
        validator.checkFullyCovered();
        this.simpleDisambiguate(existingPhysicalModule, analyzeResult);
        ModuleStorageCM cm = this.requestEnv.getModuleStorageCM();
        Map<String, JSONObject> outputObjects = this.getOutputObjects(cm);
        FileAppendDatasetBuilder datasetBuilder = new FileAppendDatasetBuilder(tmpDir.getAbsolutePath() + "/", this.requestEnv.getTaskStatus(), version, this.appendingToLegacyFile);
        Map<String, Table> tables = FileAppendHandler.indexTables(existingPhysicalModule);
        for (Dataset dataset : analyzeResult.getDatasets()) {
            JSONObject output;
            String tableId = dataset.getName();
            File oldParquet = this.getParquetFile(cm, tmpDir, tableId, output = this.getParquet(outputObjects, tableId));
            if (oldParquet == null) {
                throw new FileUploadException(MoserError.MSR_UPL_COPY_TEMP_FILE, Response.Status.INTERNAL_SERVER_ERROR);
            }
            Table table = tables.get(tableId);
            if (table == null) {
                throw new FileUploadException(MoserError.MSR_UPL_MISSING_SHEET, dataset.getLabel(), "");
            }
            long rowCount = datasetBuilder.createDataset(new Path(oldParquet.getAbsolutePath()), dataset);
            table.setNumberOfRows(Long.valueOf(rowCount));
            if (MoserConfig.getImportMultisheet()) continue;
            break;
        }
        this.physicalModule = existingPhysicalModule;
    }

    private JSONObject getParquet(Map<String, JSONObject> outputObjects, String tableId) {
        Iterator<JSONObject> iterator;
        JSONObject output = outputObjects.get(tableId);
        if (output == null && outputObjects.size() == 1 && this.physicalModule.getDataSource().size() == 1 && (iterator = outputObjects.values().iterator()).hasNext()) {
            JSONObject value = iterator.next();
            return value;
        }
        return output;
    }

    private void detectRowIdLegacyFile(Module existingPhysicalModule) {
        for (DataSource dataSource : existingPhysicalModule.getDataSource()) {
            Table table = (Table)dataSource.getTable().get(0);
            if (table == null || table.getTableItem().isEmpty()) continue;
            Column column = ((TableItemType)table.getTableItem().get(0)).getColumn();
            this.appendingToLegacyFile = !ROW_ID.equals(column.getName());
            return;
        }
    }

    private void simpleDisambiguate(Module existingPhysicalModule, AnalyzeResult analyzeResult) {
        if (this.physicalModule.getDataSource().size() == 1 && existingPhysicalModule.getDataSource().size() == 1) {
            DataSource oldData = (DataSource)existingPhysicalModule.getDataSource().get(0);
            DataSource newData = (DataSource)this.physicalModule.getDataSource().get(0);
            Table table = (Table)oldData.getTable().get(0);
            String name = table.getName();
            if (!name.equals(newData.getName())) {
                Dataset dataset = (Dataset)analyzeResult.getDatasets().get(0);
                dataset.setName(name);
                newData.setName(name);
                if (oldData.getOriginalName() != null) {
                    newData.setOriginalName(oldData.getOriginalName());
                }
                Table newTable = (Table)newData.getTable().get(0);
                newTable.setName(name);
                if (table.getOriginalName() != null) {
                    newTable.setOriginalName(table.getOriginalName());
                }
            }
        }
    }

    private Map<String, JSONObject> getOutputObjects(ModuleStorageCM cm) {
        JSONArray outputObjects = cm.getUploadedFileOutputObject(this.uploadedFileId);
        if (outputObjects == null) {
            throw new FileUploadException(MoserError.MSR_UPL_FILEUPLOADID_NOT_EXIST, this.uploadedFileId, "");
        }
        HashMap<String, JSONObject> outputObjectsMap = new HashMap<String, JSONObject>();
        outputObjects.stream().forEach(a -> outputObjectsMap.put(a.get((Object)"defaultName").toString(), (JSONObject)a));
        return outputObjectsMap;
    }

    private static Map<String, Table> indexTables(Module existingPhysicalModule) {
        HashMap<String, Table> tables = new HashMap<String, Table>();
        for (DataSource dataSource : existingPhysicalModule.getDataSource()) {
            Table table = (Table)dataSource.getTable().get(0);
            tables.put(table.getName(), table);
        }
        return tables;
    }

    private File getParquetFile(ModuleStorageCM cm, File tmpDir, String tableId, JSONObject outputObject) throws IOException {
        File tmpFile = File.createTempFile(FileAppendHandler.generateFileName(tableId), ".tmp", tmpDir);
        BaseMoserTask.throwIfCancelled(this.requestEnv.getTaskStatus(), "file upload");
        if (FileAppendHandler.loadDataFileFromCMOnDisk(cm, tmpFile, outputObject) != 200) {
            return null;
        }
        return tmpFile;
    }

    @Override
    protected long getFileSize(long fileSize, String fileName) {
        long length = FileImportUtils.getCMFileSize(this.requestEnv, this.uploadedFileId);
        return length + super.getFileSize(fileSize, fileName);
    }

    /*
     * Exception decompiling
     */
    private static int loadDataFileFromCMOnDisk(ModuleStorageCM cm, File dataFile, JSONObject outputObject) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

