/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.importer.file;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.Column;
import com.ibm.bi.platform.moser.common.generated.metadata.DataSource;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.PhysicalObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.Table;
import com.ibm.bi.platform.moser.common.generated.metadata.TableItemType;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.core.importer.file.FileRefreshValidator;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class FileAppendValidator
extends FileRefreshValidator {
    protected Map<Table, List<Column>> extraColumnsPerSheet = new LinkedHashMap<Table, List<Column>>();
    protected Collection<DataSource> extraSheets;
    protected boolean appendingToLegacyFile = false;

    public FileAppendValidator(RequestEnvironment requestEnv, Module physicalModule, Module newPhysicalModule) {
        super(requestEnv, physicalModule, newPhysicalModule);
    }

    public FileAppendValidator(RequestEnvironment requestEnv, Module physicalModule, Module newPhysicalModule, boolean appendingToLegacyFile) {
        this(requestEnv, physicalModule, newPhysicalModule);
        this.appendingToLegacyFile = appendingToLegacyFile;
    }

    @Override
    public Map<DataSource, DataSource> checkFullyCovered() {
        HashMap<DataSource, DataSource> remap = new HashMap<DataSource, DataSource>();
        Map<String, DataSource> newDataSourceMap = this.buildDataSourceMap(this.newPhysicalModule);
        if (this.newPhysicalModule.getDataSource().size() == 1 && this.physicalModule.getDataSource().size() == 1) {
            DataSource dataSource = (DataSource)this.physicalModule.getDataSource().get(0);
            DataSource newDataSource = (DataSource)this.newPhysicalModule.getDataSource().get(0);
            this.validateSheets(dataSource, newDataSource, remap, newDataSourceMap);
        } else {
            for (DataSource dataSource : this.physicalModule.getDataSource()) {
                DataSource newDataSource = this.findMatchingDataSource(dataSource, newDataSourceMap);
                this.validateSheets(dataSource, newDataSource, remap, newDataSourceMap);
            }
        }
        this.extraSheets = newDataSourceMap.values();
        this.throwIfNeeded();
        return remap;
    }

    private void validateSheets(DataSource dataSource, DataSource newDataSource, Map<DataSource, DataSource> remap, Map<String, DataSource> newDataSourceMap) {
        if (newDataSource == null) {
            this.missingSheets.add(dataSource);
            return;
        }
        remap.put(newDataSource, dataSource);
        this.checkDataSourceFullyCovered(dataSource, newDataSource);
        newDataSourceMap.remove(this.getOriginalName((PhysicalObjectType)newDataSource));
    }

    @Override
    protected DataSource findMatchingDataSource(DataSource dataSource, Map<String, DataSource> newDataSourceMap) {
        return newDataSourceMap.get(this.getOriginalName((PhysicalObjectType)dataSource));
    }

    @Override
    protected void checkTableFullyCovered(Table table, Table newTable) {
        Column column;
        int i;
        int size = Math.min(table.getTableItem().size(), newTable.getTableItem().size());
        ArrayList<Column> missingColumns = new ArrayList<Column>();
        ArrayList<Column> extraColumns = new ArrayList<Column>();
        ArrayList<Pair<Column, Column>> mismatchedColumns = new ArrayList<Pair<Column, Column>>();
        if (this.appendingToLegacyFile) {
            try {
                TableItemType item = (TableItemType)((TableItemType)newTable.getTableItem().get(0)).clone();
                table.getTableItem().add(0, item);
            }
            catch (CloneNotSupportedException e) {
                LoggerAdapter.trace((Object)this, e.getLocalizedMessage(), e);
            }
        }
        for (i = 0; i < size; ++i) {
            column = ((TableItemType)table.getTableItem().get(i)).getColumn();
            String columnName = this.getOriginalName((PhysicalObjectType)column);
            Column newColumn = ((TableItemType)newTable.getTableItem().get(i)).getColumn();
            if (!this.matchingDatatypes(column.getDatatype(), newColumn.getDatatype()) || !columnName.equalsIgnoreCase(this.getOriginalName((PhysicalObjectType)newColumn))) {
                mismatchedColumns.add(new Pair<Column, Column>(column, newColumn));
                continue;
            }
            Boolean bNewNullable = newColumn.isNullable();
            if (bNewNullable == null || !bNewNullable.booleanValue()) continue;
            column.setNullable(Boolean.TRUE);
        }
        if (table.getTableItem().size() > newTable.getTableItem().size()) {
            for (i = size; i < table.getTableItem().size(); ++i) {
                column = ((TableItemType)table.getTableItem().get(i)).getColumn();
                missingColumns.add(column);
            }
        } else if (table.getTableItem().size() < newTable.getTableItem().size()) {
            for (i = size; i < newTable.getTableItem().size(); ++i) {
                column = ((TableItemType)newTable.getTableItem().get(i)).getColumn();
                extraColumns.add(column);
            }
        }
        if (!missingColumns.isEmpty()) {
            this.missingColumnsPerSheet.put(newTable, missingColumns);
        }
        if (!mismatchedColumns.isEmpty()) {
            this.mismatchedColumnsPerSheet.put(newTable, mismatchedColumns);
        }
        if (!extraColumns.isEmpty()) {
            this.extraColumnsPerSheet.put(newTable, extraColumns);
        }
    }

    @Override
    protected boolean checkIfNeedToThrow() {
        return super.checkIfNeedToThrow() && this.extraColumnsPerSheet.isEmpty() && this.extraSheets.isEmpty();
    }

    @Override
    protected StringBuilder buildThrowReason() {
        StringBuilder reason = super.buildThrowReason();
        String extra = this.buildExtraSheets();
        if (extra.length() > 0) {
            reason.append("\n");
            reason.append(extra);
        }
        if ((extra = this.buildExtraMismatchedSheets()).length() > 0) {
            reason.append("\n");
            reason.append(extra);
        }
        return reason;
    }

    private String buildExtraColumns(boolean isMultiSheet, Table sheet, List<Column> extraColumns) {
        StringBuilder columns = new StringBuilder();
        for (Column column : extraColumns) {
            if (columns.length() != 0) {
                columns.append("\", \"");
            }
            columns.append(this.getOriginalName((PhysicalObjectType)column));
        }
        if (isMultiSheet) {
            String sheetName = this.getOriginalName((PhysicalObjectType)sheet);
            IMessageKey.Param2 key = extraColumns.size() == 1 ? MoserError.MSR_UPL_SHEET_HAS_EXTRA_COLUMN : MoserError.MSR_UPL_SHEET_HAS_EXTRA_COLUMNS;
            return MoserMessages.getMessage((IMessageKey.Param2)key, (Locale)this.requestEnv.getProductLocale(), (String)sheetName, (String)columns.toString());
        }
        IMessageKey.Param1 key = extraColumns.size() == 1 ? MoserError.MSR_UPL_EXTRA_COLUMN : MoserError.MSR_UPL_HAS_EXTRA_COLUMNS;
        return MoserMessages.getMessage((IMessageKey.Param1)key, (Locale)this.requestEnv.getProductLocale(), (String)columns.toString());
    }

    private String buildExtraMismatchedSheets() {
        LinkedHashSet<Table> sheets = new LinkedHashSet<Table>();
        sheets.addAll(this.extraColumnsPerSheet.keySet());
        boolean isMultiSheet = this.physicalModule.getDataSource().size() > 1;
        StringBuilder result = new StringBuilder();
        for (Table sheet : sheets) {
            if (result.length() > 0) {
                result.append("\n");
            }
            String extra = this.buildExtraColumns(isMultiSheet, sheet, this.extraColumnsPerSheet.get(sheet));
            result.append(extra);
        }
        return result.toString();
    }

    private String buildExtraSheets() {
        StringBuilder result = new StringBuilder();
        for (DataSource extraSheet : this.extraSheets) {
            if (result.length() > 0) {
                result.append("\n");
            }
            String sheetName = this.getOriginalName((PhysicalObjectType)extraSheet);
            result.append(MoserMessages.getMessage((IMessageKey.Param1)MoserError.MSR_UPL_EXTRA_SHEET, (Locale)this.requestEnv.getProductLocale(), (String)sheetName));
        }
        return result.toString();
    }

    @Override
    protected String buildMismatchedColumn(boolean isMultiSheet, Table sheet, Pair<Column, Column> mismatchedColumn) {
        Column column = mismatchedColumn.getFirst();
        Column newColumn = mismatchedColumn.getSecond();
        String columnName = this.getOriginalName((PhysicalObjectType)column);
        String newColumnName = this.getOriginalName((PhysicalObjectType)newColumn);
        String dataType = column.getDatatype();
        String newDataType = newColumn.getDatatype();
        if (isMultiSheet) {
            String sheetName = this.getOriginalName((PhysicalObjectType)sheet);
            return MoserMessages.getMessage((IMessageKey.Param5)MoserError.MSR_UPL_COLUMNS_MISMATCH, (Locale)this.requestEnv.getProductLocale(), (String)sheetName, (String)columnName, (String)dataType, (String)newColumnName, (String)newDataType);
        }
        return MoserMessages.getMessage((IMessageKey.Param4)MoserError.MSR_UPL_COLUMN_MISMATCH, (Locale)this.requestEnv.getProductLocale(), (String)columnName, (String)dataType, (String)newColumnName, (String)newDataType);
    }

    @Override
    protected boolean resolveAmbiguity(String datatype1, String datatype2) {
        return "DOUBLE".equalsIgnoreCase(datatype1) && "BIGINT".equalsIgnoreCase(datatype2);
    }
}

