/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.importer.file;

import com.ibm.bi.platform.moser.common.exceptions.file.UnsupportedFileTypeException;
import com.ibm.bi.platform.moser.common.utils.FileDataCollectorException;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.io.MultiFileInputStream;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.tika.Tika;
import org.apache.tika.metadata.Metadata;

public class FileDataCollector {
    private static final String CONTENT_FILENAME = "segment";
    final String fileUploadId;
    final boolean async;
    final String fileName;
    final boolean extended;
    final long timeout;
    final String userId;
    final String uniqueId = String.valueOf(System.currentTimeMillis() + (long)this.hashCode());
    final String resourcesLocation;
    String destinationId;
    boolean internalError;
    Map<Integer, Integer> data = new ConcurrentHashMap<Integer, Integer>();
    long contentLenght = 0L;
    private boolean appender = false;
    private Map<String, String> mapping = null;
    private String mimeType = "application/octet-stream";
    TimeoutListener listener;
    Timer timer;

    public FileDataCollector(String userId, String fileUploadId, boolean async, String fileName, boolean extended, long timeout, boolean append, Map<String, String> mapping, String destinationId) {
        this(userId, fileUploadId, async, fileName, extended, Math.max(10L, timeout), destinationId);
        this.appender = append;
        this.mapping = mapping;
    }

    public FileDataCollector(String userId, String fileUploadId, boolean async, String fileName, boolean extended, long timeout, String destinationId) {
        this.userId = userId;
        this.fileName = fileName;
        this.fileUploadId = fileUploadId;
        this.async = async;
        this.extended = extended;
        this.resourcesLocation = MoserConfig.getInstance().getTempUploadDirectory() + this.uniqueId;
        this.timeout = timeout;
        this.destinationId = destinationId;
        File folder = new File(this.resourcesLocation);
        folder.mkdirs();
        this.startTimer();
    }

    private synchronized void startTimer() {
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                FileDataCollector.this.cleanUp();
            }
        }, this.timeout);
    }

    public synchronized void stop() {
        this.timer.cancel();
        this.removeTimeoutListener();
    }

    public synchronized void restartTimer() {
        this.timer.cancel();
        this.startTimer();
    }

    public void cleanUp() {
        this.timer.cancel();
        this.deleteData();
        this.removeTimeoutListener();
    }

    private void deleteData() {
        File file = new File(this.resourcesLocation);
        try {
            this.data.clear();
            this.contentLenght = 0L;
            FileUtils.deleteDirectory((File)file);
        }
        catch (IOException e) {
            LoggerAdapter.errorExceptionStack(FileDataCollector.class, e);
        }
    }

    public void removeTimeoutListener() {
        if (this.listener != null) {
            this.listener.timeoutCallback(this.uniqueId);
        }
    }

    public void addTimeoutListener(TimeoutListener l) {
        this.listener = l;
    }

    public void append(Integer index, InputStream segment, String contentType) {
        if (index < 1 || segment == null) {
            this.setInternalError();
            throw new FileDataCollectorException(index);
        }
        try {
            this.restartTimer();
            this.mimeType = contentType == null || contentType.isEmpty() ? this.mimeType : contentType;
            File folder = new File(this.resourcesLocation + File.separator + String.valueOf(index));
            folder.mkdirs();
            String path = folder.getAbsolutePath() + File.separator + CONTENT_FILENAME;
            long length = Files.copy(segment, new File(path).toPath(), StandardCopyOption.REPLACE_EXISTING);
            if (this.data.get(index) != null) {
                this.contentLenght -= (long)this.data.get(index).intValue();
            }
            this.contentLenght += length;
            this.data.put(index, (int)length);
            LoggerAdapter.info(this, "Task  for " + this.getFileName() + " collected segment number " + index);
        }
        catch (IOException e) {
            this.setInternalError();
            throw new FileDataCollectorException(index, (Exception)e);
        }
    }

    private void setInternalError() {
        this.internalError = true;
    }

    public long getContentLength() {
        return this.contentLenght;
    }

    public String getFileUploadId() {
        return this.fileUploadId;
    }

    public boolean isAsync() {
        return this.async;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean collectExtendedMetadata() {
        return this.extended;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public InputStream openContentStream() throws IOException {
        Serializable serializable;
        int segments = this.data.keySet().size();
        ArrayList<File> files = new ArrayList<File>(segments);
        Integer i = 1;
        while (i <= segments) {
            if (!this.data.containsKey(i)) {
                this.setInternalError();
                throw new FileDataCollectorException(i);
            }
            String path = this.resourcesLocation + File.separator + String.valueOf(i) + File.separator + CONTENT_FILENAME;
            File file = new File(path);
            if (!file.exists()) {
                this.setInternalError();
                throw new FileDataCollectorException(i);
            }
            files.add(file);
            serializable = i;
            Integer n = i = Integer.valueOf(i + 1);
        }
        if (MoserConfig.getProbeUploadedFile() && !files.isEmpty()) {
            serializable = null;
            try (MultiFileInputStream is = new MultiFileInputStream(Collections.enumeration(files));){
                this.probeIsSupported(is);
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
        }
        return files.isEmpty() ? null : new MultiFileInputStream(Collections.enumeration(files));
    }

    private void probeIsSupported(InputStream is) {
        Metadata metadata = new Metadata();
        metadata.set("resourceName", this.fileName);
        metadata.set("Content-Length", Long.toString(this.contentLenght));
        metadata.set("Content-Type", this.mimeType);
        String type = null;
        try {
            type = new Tika().detect(is, metadata).toLowerCase(Locale.ENGLISH);
        }
        catch (Throwable t) {
            LoggerAdapter.errorExceptionStack(FileDataCollector.class, t);
            throw new UnsupportedFileTypeException(this.fileName, t);
        }
        if (!MoserUtil.isSupportedMimeTypeAndFileExt(this.fileName, type)) {
            throw new UnsupportedFileTypeException(this.fileName, type);
        }
    }

    public boolean isAppender() {
        return this.appender;
    }

    public Map<String, String> getMapping() {
        return this.mapping;
    }

    public String getDestinationId() {
        return this.destinationId;
    }

    @FunctionalInterface
    public static interface TimeoutListener {
        public void timeoutCallback(String var1);
    }
}

