/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.importer.file;

import com.ibm.bi.org.apache.hadoop.io.ConfigFactory;
import com.ibm.bi.platform.datasetutils.metadata.ColumnMetadata;
import com.ibm.bi.platform.datasetutils.metadata.RowSchema;
import com.ibm.bi.platform.datasetutils.metadata.types.EIntrinsicType;
import com.ibm.bi.platform.datasetutils.parquet.DatasetParquetWriterFactory;
import com.ibm.bi.platform.datasetutils.parquet.ParquetVersionEnum;
import com.ibm.bi.platform.datasetutils.utils.ReadableRecord;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.importer.file.FileReadableRecord;
import com.ibm.bi.platform.moser.core.importer.file.FileRowSchema;
import com.ibm.bi.platform.moser.core.tasks.BaseMoserTask;
import com.ibm.bi.platform.moser.core.tasks.TaskStatus;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.neo.dataimport.ImportService;
import com.ibm.neo.dataimport.api.WAStorageException;
import com.ibm.neo.dataimport.deploy.DatasetDeployer;
import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.storage.IRowWriter;
import com.ibm.neo.dataimport.storage.IStreamingRowWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.Date;
import java.util.Map;
import org.apache.parquet.hadoop.ParquetWriter;
import shaded.org.apache.hadoop.fs.Path;

public class FileDatasetBuilder {
    public static final String BLOCK_SIZE = "block_size";
    public static final String COMPRESSION_CODEC = "compression_codec";
    public static final String ENCRYPTION_ENABLED = "encryptionEnabled";
    protected final String storageLocation;
    protected final TaskStatus taskStatus;
    protected final ParquetVersionEnum version;
    protected final Map<String, Object> config;

    public FileDatasetBuilder(String storageLocation, TaskStatus taskStatus, ParquetVersionEnum version) {
        this.storageLocation = storageLocation;
        this.taskStatus = taskStatus;
        this.version = version;
        this.config = MoserConfig.createParquetConfig();
    }

    public long createDataset(Dataset dataset, String name, boolean[] nullables) throws Exception {
        try (ParquetWriter writer = DatasetParquetWriterFactory.create((Path)new Path(this.storageLocation + name), (RowSchema)new FileRowSchema(dataset), (ParquetVersionEnum)this.version, this.config);){
            ImportService is = ImportService.getInstance();
            DatasetDeployer datasetDeployer = new DatasetDeployer(is, is.getStorageService());
            datasetDeployer.setDataset(dataset);
            IStreamingRowWriter streamingRowWriter = datasetDeployer.getStreamingRowWriter();
            long[] rowCount = new long[]{0L};
            IRowWriter rowWriter = this.getRowWriter((ParquetWriter<ReadableRecord>)writer, rowCount, nullables);
            streamingRowWriter.write(rowWriter);
            long l = rowCount[0];
            return l;
        }
    }

    protected static IValue getIValue(ReadableRecord record, ColumnMetadata md, EIntrinsicType type, int i) {
        boolean isNull = record.isNull(i) && md.isNullable();
        switch (type) {
            case BOOLEAN: {
                return isNull ? ValueFactory.createBoolean() : ValueFactory.createBoolean((boolean)record.getBoolean(i));
            }
            case DOUBLE: {
                return isNull ? ValueFactory.createDouble() : ValueFactory.createDouble((double)record.getDouble(i));
            }
            case STRING: {
                return isNull ? ValueFactory.createString(null) : ValueFactory.createString((String)record.getString(i));
            }
            case DATE: {
                return isNull ? ValueFactory.createDate() : ValueFactory.createDate((Date)Date.from(record.getDate(i).atStartOfDay(ZoneId.systemDefault()).toInstant()));
            }
            case DECIMAL: {
                return isNull ? ValueFactory.createDecimal() : ValueFactory.createDecimal((BigDecimal)record.getDecimal(i));
            }
            case FLOAT: {
                return isNull ? ValueFactory.createFloat() : ValueFactory.createFloat((float)record.getFloat(i));
            }
            case INT: {
                return isNull ? ValueFactory.createInteger() : ValueFactory.createInteger((int)record.getInt(i));
            }
            case LONG: {
                return isNull ? ValueFactory.createLong() : ValueFactory.createLong((long)record.getLong(i));
            }
            case TIMESTAMP: {
                return isNull ? ValueFactory.createDate() : ValueFactory.createDate((Date)Date.from(record.getDateTime(i).atZone(ZoneId.systemDefault()).toInstant()));
            }
        }
        return null;
    }

    protected IRowWriter getRowWriter(final ParquetWriter<ReadableRecord> writer, final long[] rowCount, final boolean[] nullables) {
        return new IRowWriter(){
            private FileReadableRecord record = new FileReadableRecord(0L);
            private final long appendCancelInterval = MoserConfig.getParquetCancelInterval();

            public void write(IValue[] tupleValues) throws WAStorageException {
                if (rowCount[0] % this.appendCancelInterval == 0L) {
                    BaseMoserTask.throwIfCancelled(FileDatasetBuilder.this.taskStatus, "file upload");
                }
                this.record.setRecord(tupleValues);
                try {
                    writer.write((Object)this.record);
                    if (nullables != null) {
                        for (int i = 0; i < tupleValues.length; ++i) {
                            if (!tupleValues[i].isNull()) continue;
                            nullables[i] = true;
                        }
                    }
                    rowCount[0] = rowCount[0] + 1L;
                }
                catch (IOException e) {
                    throw new WAStorageException((Throwable)e);
                }
            }

            public void close() throws WAStorageException {
            }
        };
    }

    static {
        ConfigFactory.initFactory((ConfigFactory)new ConfigFactory(){

            public boolean isEncryptionEnabled() {
                return MoserConfig.isEncryptionEnabled();
            }
        });
    }
}

