/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.importer.file;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.datasetutils.parquet.ParquetVersionEnum;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.exceptions.file.NameConflictException;
import com.ibm.bi.platform.moser.common.exceptions.file.OverwriteOrAppendPrompt;
import com.ibm.bi.platform.moser.common.exceptions.file.UnsupportedCompressedFileTypeException;
import com.ibm.bi.platform.moser.common.exceptions.file.UnsupportedFileTypeException;
import com.ibm.bi.platform.moser.common.generated.info.MoserInfo;
import com.ibm.bi.platform.moser.common.generated.metadata.Column;
import com.ibm.bi.platform.moser.common.generated.metadata.DataSource;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.Relationship;
import com.ibm.bi.platform.moser.common.generated.metadata.Table;
import com.ibm.bi.platform.moser.common.generated.metadata.TableItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.common.utils.ContentServiceException;
import com.ibm.bi.platform.moser.common.utils.FileUploadException;
import com.ibm.bi.platform.moser.common.utils.IdentifierUtil;
import com.ibm.bi.platform.moser.common.utils.MoserCancelException;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.common.utils.MoserMessageKeys;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.common.utils.SmartsServiceException;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.importer.file.FileDatasetBuilder;
import com.ibm.bi.platform.moser.core.importer.file.FileRowSchema;
import com.ibm.bi.platform.moser.core.importer.file.NeoImportLocaleProvider;
import com.ibm.bi.platform.moser.core.importer.file.VendorFormatToV5FormatConverter;
import com.ibm.bi.platform.moser.core.module.IModuleObjectManager;
import com.ibm.bi.platform.moser.core.module.ModuleObjectManager;
import com.ibm.bi.platform.moser.core.module.container.BaseModuleContainer;
import com.ibm.bi.platform.moser.core.module.container.OutputContainer;
import com.ibm.bi.platform.moser.core.module.container.ReportVersionContainer;
import com.ibm.bi.platform.moser.core.module.container.UploadedFileContainer;
import com.ibm.bi.platform.moser.core.module.transformation.IModuleTransformation;
import com.ibm.bi.platform.moser.core.module.transformation.MakeRowId;
import com.ibm.bi.platform.moser.core.module.transformation.PhysicalToBaseModule;
import com.ibm.bi.platform.moser.core.module.util.ModuleUtil;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.ContentService;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.rest.service.SmartsService;
import com.ibm.bi.platform.moser.core.smarts.SmartsServiceUtil;
import com.ibm.bi.platform.moser.core.tasks.BaseMoserTask;
import com.ibm.bi.platform.moser.core.tasks.FileImportUtils;
import com.ibm.bi.platform.moser.core.tasks.TaskStatus;
import com.ibm.bi.platform.moser.core.tasks.TaskStep;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserInfoUtil;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.neo.blobstore.BlobStoreException;
import com.ibm.neo.dataimport.ImportService;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.blob.EmptyBlobStoreFactory;
import com.ibm.neo.dataimport.nodel.DataItem;
import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.nodel.DocumentModel;
import com.ibm.neo.dataimport.nodel.DocumentSection;
import com.ibm.neo.dataimport.nodel.EDataType;
import com.ibm.neo.dataimport.nodel.ds.UploadDataSource;
import com.ibm.neo.dataimport.nodel.ds.UserDataSource;
import com.ibm.neo.dataimport.nodel.ops.AnalyzeResult;
import com.ibm.neo.g11n.LocaleProvider;
import com.ibm.neo.messages.exceptions.NeoImportError;
import com.ibm.neo.persist.PersistenceService;
import com.ibm.neo.persist.local.mem.MemPersistenceGatewayFactory;
import com.ibm.neo.security.AccessControlService;
import com.ibm.neo.security.AnonymoustHelper;
import com.ibm.neo.util.ops.IOperation;
import com.ibm.neo.util.ops.IOperationWithResult;
import com.ibm.neo.wrangler.api.WranglerService;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.core.Response;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.shiro.config.IniSecurityManagerFactory;
import org.apache.shiro.mgt.SecurityManager;

public class FileImportHandler {
    public static final String DS_TYPE_FILE = "PARQUET";
    public static final String PHYSICAL_MODULE = "physicalmodule";
    protected static final String DATASETS = "datasets";
    public static final String DATASETSCOLON = "datasets:";
    public static final String TMP_STORAGE = "uplFile_";
    protected String fileId = null;
    protected RequestEnvironment requestEnv;
    private String destinationId;
    private static final String CLASSPATH_MOSER_SHIRO_INI = "classpath:shiro/moser_shiro.ini";
    protected static final SecurityManager securityManager = (SecurityManager)new IniSecurityManagerFactory("classpath:shiro/moser_shiro.ini").getInstance();
    private static HashMap<String, String> mimeTypes;
    private static HashMap<String, String> compressedMimeTypeSuffixes;
    private static final String BLOB_PATH;
    private static boolean bInitialized;

    public FileImportHandler(RequestEnvironment requestEnv) {
        this.requestEnv = requestEnv;
    }

    public static boolean initialized() {
        return bInitialized;
    }

    public static void setInitialized(boolean bValue) {
        bInitialized = bValue;
    }

    public static void startServices() throws Exception {
        Properties config = FileImportHandler.createConfig();
        PersistenceService.initialize((Properties)config);
        AccessControlService.initialize((Properties)config);
        WranglerService.initialize((Properties)config);
        ImportService.initialize((Properties)config);
        ImportService.setLocaleProvider((LocaleProvider)NeoImportLocaleProvider.getProvider());
    }

    public static void stopServices() throws BlobStoreException {
        ImportService.terminate();
        AccessControlService.terminate();
        WranglerService.terminate();
        PersistenceService.terminate();
    }

    private static Properties createConfig() {
        Properties config = new Properties();
        config.put("com.ibm.neo.dataimport.sheet.data-dir", MoserConfig.getInstance().getTempUploadDirectory() + "CDFSheetCache");
        config.put("com.ibm.neo.dataimport.temp-dir", MoserConfig.getInstance().getTempUploadDirectory() + "NeoImportTemp");
        config.put("com.ibm.neo.persist.gateway.factory", MemPersistenceGatewayFactory.class.getCanonicalName());
        config.put("com.ibm.neo.blobstore.factory", EmptyBlobStoreFactory.class.getCanonicalName());
        config.put("com.ibm.neo.blobstore.file.root-dir", BLOB_PATH);
        config.put("com.ibm.neo.dataimport.string-length-limit", Integer.toString(MoserConfig.getStringLengthLimit()));
        config.put("com.ibm.neo.dataimport.quotas.enforce-quotas", Boolean.toString(false));
        config.put("com.ibm.neo.dataimport.cdf.scrape.archive.zip-as-workbook", Boolean.toString(true));
        config.put("com.ibm.neo.dataimport.analyze.return-one-dataset", Boolean.toString(false));
        config.put("com.ibm.neo.dataimport.analyze.throw-on-section-failure", Boolean.toString(false));
        config.setProperty("com.ibm.neo.dataimport.boolean-skip-empty-rows", Boolean.toString(true));
        config.put("com.ibm.neo.security.anonymous-allowed", Boolean.toString(true));
        config.put("com.ibm.neo.security.shiro.managed", Boolean.toString(true));
        config.put("com.ibm.neo.security.shiro.ini-resource-path", CLASSPATH_MOSER_SHIRO_INI);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object importFile(InputStream input, String fileName, String mimeType, long fileSize) {
        MoserInfo moserInfo;
        XMLGregorianCalendar startTime = MoserUtil.getCurrentTimeGregorianUTC();
        AnonymoustHelper anonHelper = null;
        File tmpDir = null;
        UploadedFileContainer uploadedFile = null;
        UploadDataSource dataSource = null;
        try {
            anonHelper = new AnonymoustHelper(securityManager);
            anonHelper.bind();
            String cleanFileName = MoserUtil.checkNameForCM(fileName);
            String strippedFileName = MoserUtil.stripInvalidFilenameCharactersIncludingDot(cleanFileName);
            this.incrementStatusStep(MoserMessageKeys.MSR_STS_READING_FILE, Long.toString(fileSize), cleanFileName);
            dataSource = FileImportHandler.createUploadDataSource(this.requestEnv, strippedFileName, FileImportHandler.getMimeType(cleanFileName, mimeType), input, fileSize);
            String msg = MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_STS_FILE_ANALYZE, (Locale)this.requestEnv.getProductLocale(), (String)cleanFileName);
            LoggerAdapter.debug(this, msg);
            AnalyzeResult analyzeResult = FileImportHandler.analyzeDataSource(dataSource);
            this.incrementStatusStep(MoserMessageKeys.MSR_STS_FILE_BUILD, cleanFileName);
            tmpDir = MoserUtil.createTempUploadDirectory(TMP_STORAGE);
            ParquetVersionEnum version = MoserConfig.getParquetVersion();
            Module physicalModule = this.buildPhysicalModule(cleanFileName, analyzeResult, tmpDir, version);
            FileImportUtils.checkQuota(tmpDir, null, this.requestEnv);
            IOperation removeOp = ImportService.getInstance().removeDataSource(dataSource.getId(), true, false);
            removeOp.join();
            anonHelper.unbind();
            anonHelper = null;
            IModuleTransformation transformation = new PhysicalToBaseModule();
            Module baseModule = transformation.apply(physicalModule);
            transformation = new MakeRowId(this.requestEnv);
            baseModule = transformation.apply(baseModule);
            String baseModuleIdentifier = "base";
            baseModuleIdentifier = ModuleUtil.buildUniqueModuleIdentifier(DATASETS, strippedFileName + "." + "base");
            baseModule.setIdentifier(baseModuleIdentifier);
            baseModule.setLabel(cleanFileName);
            if (baseModule.getQuerySubject().size() == 1) {
                ((QuerySubject)baseModule.getQuerySubject().get(0)).setLabel(cleanFileName);
            }
            uploadedFile = FileImportHandler.createUploadedFileContainer(cleanFileName, tmpDir, physicalModule, baseModule, fileSize, startTime, version);
            this.incrementStatusStep(MoserMessageKeys.MSR_STS_FILE_SAVE, cleanFileName);
            IModuleObjectManager mm = this.requestEnv.getModuleObjectManager();
            RESTClientResponse response = mm.postUploadedFile(this.destinationId, uploadedFile, this.requestEnv.getTaskStatus());
            int respCode = response.getResponseCode();
            if (respCode != 201 && respCode != 204) {
                throw new ContentServiceException(response.getJSONObjectResponse(), response.getResponseCode());
            }
            this.fileId = uploadedFile.getStoreId();
            LoggerAdapter.info(this, "[PERF]: Begin - Smarts analysis for file");
            SmartsServiceUtil.initSmartsSubtask(this.requestEnv.getTaskStatus(), this.requestEnv.getProductLocale(), cleanFileName);
            SmartsServiceUtil.createSmartsModule(this.fileId, baseModule, UseSpecType.FILE, Optional.empty(), t -> {}, SmartsService.AnalysisMode.DEEP, this.requestEnv, null, this.requestEnv.getTaskStatus(), null);
            LoggerAdapter.info(this, "[PERF]: End - Smarts analysis for file");
            msg = MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_STS_FILE_AUTOJOIN, (Locale)this.requestEnv.getProductLocale(), (String)cleanFileName);
            LoggerAdapter.debug(this, msg);
            if (this.autoJoin(baseModule) && (respCode = mm.putBaseModule(this.fileId, baseModule)) != 201 && respCode != 204) {
                throw new ContentServiceException(response.getJSONObjectResponse(), response.getResponseCode());
            }
            msg = MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_STS_FILE_FINALIZING, (Locale)this.requestEnv.getProductLocale(), (String)cleanFileName);
            LoggerAdapter.debug(this, msg);
            uploadedFile.setDisabled(Boolean.FALSE);
            this.requestEnv.getContentService().put(ContentService.ContentResource.OBJECTS, this.fileId, null, uploadedFile.toJSON());
            String fileHRef = ModuleObjectManager.getBaseModuleHRef(this.fileId);
            moserInfo = MoserInfoUtil.createMoserInfo(fileHRef, this.fileId, null, cleanFileName, uploadedFile.getEndTime());
            FileUtils.deleteQuietly((File)tmpDir);
        }
        catch (MoserCancelException e) {
            throw e;
            catch (SmartsServiceException e2) {
                if (this.fileId != null && uploadedFile != null) {
                    uploadedFile.setDisabled(Boolean.FALSE);
                    this.requestEnv.getContentService().put(ContentService.ContentResource.OBJECTS, this.fileId, null, uploadedFile.toJSON());
                }
                LoggerAdapter.errorExceptionStack(this, e2);
                Response response = e2.getResponse(this.requestEnv.getProductLocale());
                return response;
            }
            catch (MoserException ex) {
                LoggerAdapter.errorExceptionStack(this, ex);
                Response response = ex.getResponse(this.requestEnv.getProductLocale());
                return response;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                catch (Exception e3) {
                    LoggerAdapter.errorExceptionStack(this, e3);
                    Object object = FileImportHandler.getDetailedFileUploadException(fileName, this.requestEnv.getProductLocale(), e3);
                    return object;
                }
            }
        }
        finally {
            FileUtils.deleteQuietly(tmpDir);
            if (anonHelper != null) {
                if (dataSource != null) {
                    try {
                        IOperation removeOp = ImportService.getInstance().removeDataSource(dataSource.getId(), true, false);
                        removeOp.join();
                    }
                    catch (WAImportException | CancellationException | ExecutionException ex) {
                        LoggerAdapter.errorExceptionStack(this, ex);
                    }
                }
                anonHelper.unbind();
            }
        }
        if (anonHelper == null) return moserInfo;
        if (dataSource != null) {
            try {
                IOperation removeOp = ImportService.getInstance().removeDataSource(dataSource.getId(), true, false);
                removeOp.join();
            }
            catch (WAImportException | CancellationException | ExecutionException ex) {
                LoggerAdapter.errorExceptionStack(this, ex);
            }
        }
        anonHelper.unbind();
        return moserInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static UploadDataSource createUploadDataSource(RequestEnvironment requestEnv, String fileName, String mimeType, InputStream in, long fileSize) throws WAImportException, ExecutionException {
        try {
            UploadDataSource neoSections;
            NeoImportLocaleProvider.getProvider().setProductLocale(requestEnv.getProductLocale());
            IOperationWithResult uploadOp = ImportService.getInstance().uploadDocument(fileName, mimeType, in, Long.valueOf(fileSize), null);
            UploadDataSource dataSource = (UploadDataSource)uploadOp.joinWithResult();
            DocumentModel neoModel = dataSource.getDocument();
            for (UploadDataSource section : neoSections = neoModel.getSections()) {
                FileImportHandler.checkColumnExtent(requestEnv, (DocumentSection)section);
            }
            UploadDataSource uploadDataSource = dataSource;
            return uploadDataSource;
        }
        finally {
            NeoImportLocaleProvider.getProvider().clear();
        }
    }

    protected static AnalyzeResult analyzeDataSource(UploadDataSource dataSource) throws WAImportException, ExecutionException {
        IOperationWithResult analyzeOp = ImportService.getInstance().analyzeDataSource((UserDataSource)dataSource, null);
        return (AnalyzeResult)analyzeOp.joinWithResult();
    }

    protected void incrementStatusStep(IMessageKey.Param1 key, String arg1) {
        TaskStatus status = this.requestEnv.getTaskStatus();
        BaseMoserTask.throwIfCancelled(status, "file upload");
        String msg = MoserMessages.getMessage((IMessageKey.Param1)key, (Locale)this.requestEnv.getProductLocale(), (String)arg1);
        LoggerAdapter.debug(this, msg);
        TaskStep step = status.getTaskStep();
        if (step != null) {
            step.incrementStepNumber();
            step.setCurrentStepDescription(msg);
        }
    }

    protected void incrementStatusStep(IMessageKey.Param2 key, String arg1, String arg2) {
        TaskStatus status = this.requestEnv.getTaskStatus();
        BaseMoserTask.throwIfCancelled(status, "file upload");
        String msg = MoserMessages.getMessage((IMessageKey.Param2)key, (Locale)this.requestEnv.getProductLocale(), (String)arg1, (String)arg2);
        LoggerAdapter.debug(this, msg);
        TaskStep step = status.getTaskStep();
        if (step != null) {
            step.incrementStepNumber();
            step.setCurrentStepDescription(msg);
        }
    }

    private static void checkColumnExtent(RequestEnvironment requestEnv, DocumentSection section) {
        if (section.getSheetInfo() == null) {
            for (DocumentSection aSection : section.getChildren()) {
                FileImportHandler.checkColumnExtent(requestEnv, aSection);
            }
        } else if (section.getSheetInfo().getColumnExtent() > MoserConfig.getMaxNumberOfColumns()) {
            throw new FileUploadException(MoserError.MSR_UPL_MAX_COLUMNS_EXCEEDED, String.valueOf(MoserConfig.getMaxNumberOfColumns()), MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_UPL_MAX_COLUMNS_THRESHOLD, (Locale)requestEnv.getProductLocale()));
        }
    }

    protected static UploadedFileContainer createUploadedFileContainer(String fileName, File tmpDir, Module physicalModule, Module baseModule, long fileSize, XMLGregorianCalendar startTime, ParquetVersionEnum version) {
        UploadedFileContainer uploadedFile = new UploadedFileContainer();
        uploadedFile.setDefaultName(fileName);
        uploadedFile.setStartTime(startTime);
        uploadedFile.setEndTime(MoserUtil.getCurrentTimeGregorianUTC());
        uploadedFile.setSizeOfFile(fileSize);
        uploadedFile.setDisabled(Boolean.TRUE);
        ReportVersionContainer reportVersion = new ReportVersionContainer();
        uploadedFile.setReportVersion(reportVersion);
        BaseModuleContainer baseModuleContainer = new BaseModuleContainer();
        String id = "datasets." + MoserUtil.stripInvalidFilenameCharactersIncludingDot(fileName);
        baseModuleContainer.setDatabaseId(id);
        baseModuleContainer.setPhysicalModule(physicalModule);
        baseModuleContainer.setBaseBusinessModule(baseModule);
        reportVersion.setBaseModule(baseModuleContainer);
        long sizeOnDisk = 0L;
        Map<String, File> outputMap = FileImportHandler.buildOutputMap(tmpDir);
        for (DataSource ds : physicalModule.getDataSource()) {
            Table table = (Table)ds.getTable().get(0);
            File f = outputMap.get(FileImportHandler.generateFileName(table.getName()));
            sizeOnDisk += f.length();
            OutputContainer outputContainer = new OutputContainer();
            outputContainer.setDefaultName(table.getName());
            outputContainer.setData(f);
            outputContainer.setContainer("parquet");
            outputContainer.setFormat("dataSet");
            outputContainer.setStartTime(startTime);
            outputContainer.setEndTime(uploadedFile.getEndTime());
            outputContainer.setVersion(version);
            outputContainer.setNumRows(table.getNumberOfRows());
            outputContainer.setNumColumns(Long.valueOf(table.getTableItem().size()));
            outputContainer.setStatus("succeeded");
            reportVersion.getOutputs().add(outputContainer);
        }
        uploadedFile.setSizeOnDisk(sizeOnDisk);
        return uploadedFile;
    }

    public static String generateFileName(String name) {
        StringBuilder value = new StringBuilder(Long.toString((long)name.hashCode() - Integer.MIN_VALUE));
        while (value.length() < 3) {
            value.append(Long.toString((long)value.hashCode() - Integer.MIN_VALUE));
        }
        return value.toString();
    }

    private static Map<String, File> buildOutputMap(File tmpDir) {
        HashMap<String, File> result = new HashMap<String, File>();
        for (File f : MoserUtil.listAllFiles(tmpDir)) {
            result.put(FilenameUtils.removeExtension((String)f.getName()), f);
        }
        return result;
    }

    protected boolean autoJoin(Module baseModule) {
        List<String> candidates = FileImportHandler.buildCandidates(baseModule);
        if (candidates.size() < 2) {
            return false;
        }
        List<Relationship> joins = SmartsServiceUtil.proposeJoins(this.fileId, this.requestEnv, this.getClass(), candidates.toArray(new String[candidates.size()]));
        if (!joins.isEmpty()) {
            baseModule.getRelationship().addAll(joins);
            return true;
        }
        return false;
    }

    private static List<String> buildCandidates(Module baseModule) {
        ArrayList<String> result = new ArrayList<String>();
        for (QuerySubject qs : baseModule.getQuerySubject()) {
            result.add(qs.getIdentifier());
        }
        return result;
    }

    protected static Object getDetailedFileUploadException(String fileName, Locale productLocale, Exception e) {
        if (e.getCause() instanceof WAImportException) {
            WAImportException waImport = (WAImportException)e.getCause();
            if (NeoImportError.ILLEGAL_CSV_FORMAT.getErrorCode().equals(waImport.getErrorCode())) {
                String number = "UNKNOWN";
                try {
                    List details = waImport.getDetails();
                    if (!details.isEmpty()) {
                        Integer n = Integer.valueOf(details.get(0).toString());
                        number = n.toString();
                    }
                }
                catch (NumberFormatException ex) {
                    LoggerAdapter.debug(FileImportHandler.class, "Error parsing CSV line number.", ex);
                }
                return MoserUtil.getResponse(Response.Status.INTERNAL_SERVER_ERROR, MoserError.MSR_ILLEGAL_CSV_FORMAT, productLocale, number, fileName, waImport);
            }
            return MoserUtil.getResponse(Response.Status.INTERNAL_SERVER_ERROR, MoserError.FILE_UPLOAD_ERROR, productLocale, fileName, waImport);
        }
        return MoserUtil.getResponse(Response.Status.INTERNAL_SERVER_ERROR, MoserError.FILE_UPLOAD_ERROR, productLocale, fileName, e);
    }

    public static void checkUploadedFileExists(RequestEnvironment requestEnv, String name, String destination) {
        ContentService cs = requestEnv.getContentService();
        RESTClientResponse resp = cs.get(ContentService.ContentResource.OBJECTS, destination, ContentService.ContentSubResource.ITEMS, null, "id", "type", "defaultName");
        if (Response.Status.OK.getStatusCode() != resp.getResponseCode()) {
            return;
        }
        JSONArray results = (JSONArray)resp.getJSONObjectResponse().get((Object)"data");
        for (Object o : results) {
            JSONObject object = (JSONObject)o;
            if (!name.equals(object.get((Object)"defaultName"))) continue;
            FileImportHandler.throwPromptOrConflictException(name, object);
        }
    }

    private static void throwPromptOrConflictException(String name, JSONObject result) {
        if ("uploadedFile".equals(result.get((Object)"type"))) {
            throw new OverwriteOrAppendPrompt(name, (String)result.get((Object)"id"));
        }
        throw new NameConflictException(name);
    }

    protected static String getMimeType(String fileName, String mediaType) {
        String mimeType;
        if (FileImportHandler.supportedMimeType(mediaType)) {
            return mediaType;
        }
        String fileNamePart = fileName.toLowerCase();
        String extension1 = FilenameUtils.getExtension((String)fileNamePart);
        String extension2 = FilenameUtils.getExtension((String)fileNamePart.substring(0, fileNamePart.length() - extension1.length() - 1));
        String mimeSuffix = compressedMimeTypeSuffixes.getOrDefault(extension1, "");
        String string = mimeType = mimeSuffix.isEmpty() ? mimeTypes.get(extension1) : mimeTypes.get(extension2);
        if (mimeType != null) {
            return mimeType + mimeSuffix;
        }
        throw mimeSuffix.isEmpty() ? new UnsupportedFileTypeException(fileName) : new UnsupportedCompressedFileTypeException(fileName, extension1);
    }

    private static boolean supportedMimeType(String mimeType) {
        if (mimeType == null || mimeType.isEmpty()) {
            return false;
        }
        String mimeTypePart = mimeType;
        for (String suffix : compressedMimeTypeSuffixes.values()) {
            if (!mimeTypePart.endsWith(suffix)) continue;
            mimeTypePart = mimeTypePart.substring(0, mimeTypePart.length() - suffix.length());
            break;
        }
        return mimeTypes.containsValue(mimeTypePart);
    }

    protected Module buildPhysicalModule(String fileName, AnalyzeResult analyzeResult, File tmpDir, ParquetVersionEnum version) throws Exception {
        Module module = new Module();
        module.setIdentifier(PHYSICAL_MODULE);
        module.setLabel(fileName);
        module.setVersion("11.1");
        CaseInsensitiveMap seenMap = new CaseInsensitiveMap();
        FileDatasetBuilder datasetBuilder = version == null ? null : new FileDatasetBuilder(tmpDir.getAbsolutePath() + "/", this.requestEnv.getTaskStatus(), version);
        boolean importMultisheet = MoserConfig.getImportMultisheet();
        List datasets = analyzeResult.getDatasets();
        TaskStep step = this.requestEnv.getTaskStatus().getTaskStep();
        TaskStep subStep = new TaskStep("Processing sheets in the file", importMultisheet ? datasets.size() + 1 : 2);
        step.setCurrentSubtask(subStep);
        for (Dataset dataset : datasets) {
            subStep.incrementStepNumber();
            String sheetName = dataset.getLabel();
            TaskStep subSubStep = new TaskStep("Processing sheet: " + sheetName, 2);
            subSubStep.incrementStepNumber();
            subStep.setCurrentSubtask(subSubStep);
            String[] originalNames = FileImportHandler.adjustDataItemNames(dataset);
            String tableId = IdentifierUtil.makeUniqueAndValidIdentifier((String)sheetName, (CaseInsensitiveMap)seenMap);
            dataset.setName(tableId);
            seenMap.put((Object)tableId, (Object)Boolean.TRUE);
            long rowCount = -1L;
            boolean[] nullables = new boolean[dataset.getDataItems().size()];
            Arrays.fill(nullables, false);
            if (datasetBuilder != null) {
                rowCount = datasetBuilder.createDataset(dataset, FileImportHandler.generateFileName(tableId), nullables);
            }
            subSubStep.incrementStepNumber();
            DataSource ds = new DataSource();
            ds.setName(tableId);
            ds.setOriginalName(sheetName);
            ds.setDatabaseType(DS_TYPE_FILE);
            module.getDataSource().add(ds);
            Table table = new Table();
            table.setName(tableId);
            table.setOriginalName(sheetName);
            if (rowCount > -1L) {
                table.setNumberOfRows(Long.valueOf(rowCount));
            }
            ds.getTable().add(table);
            int i = 0;
            for (DataItem dataItem : dataset.getDataItems()) {
                String columnName = dataItem.getName().trim();
                Column column = new Column();
                column.setName(columnName);
                column.setOriginalName(originalNames[i]);
                column.setVendorType(FileImportHandler.getVendorDataTypeString(dataItem));
                column.setDatatype(FileRowSchema.getXQETypeString(dataItem));
                String s = VendorFormatToV5FormatConverter.getVendorFormat(dataItem.toString());
                if (s != null && !s.isEmpty()) {
                    column.setVendorFormat(s);
                }
                if (i == 0) {
                    column.setHidden(Boolean.TRUE);
                    column.setDescription(MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_ROWID_DESC, (Locale)this.requestEnv.getProductLocale()));
                }
                column.setNullable(Boolean.valueOf(nullables[i]));
                TableItemType tableItemType = new TableItemType();
                tableItemType.setColumn(column);
                table.getTableItem().add(tableItemType);
                ++i;
            }
            if (importMultisheet) continue;
            break;
        }
        subStep.incrementStepNumber();
        return module;
    }

    private static String[] adjustDataItemNames(Dataset dataset) {
        List dataItems = dataset.getDataItems();
        String[] originalNames = new String[dataItems.size()];
        for (int i = 0; i < originalNames.length; ++i) {
            originalNames[i] = ((DataItem)dataItems.get(i)).getName().trim();
        }
        String[] identifiers = IdentifierUtil.convertToValidUniqueIdentifiers((String[])originalNames);
        for (int i = 0; i < identifiers.length; ++i) {
            DataItem item = (DataItem)dataItems.get(i);
            item.setName(identifiers[i]);
        }
        return originalNames;
    }

    private static String getVendorDataTypeString(DataItem dataItem) {
        EDataType eDT = dataItem.getDataType();
        if (eDT == EDataType.STRING) {
            return eDT.toString() + "(" + dataItem.getMaxStringLength() + ")";
        }
        return eDT.toString();
    }

    public String getFileID() {
        return this.fileId;
    }

    public static boolean isSupportedExtension(String extension) {
        return mimeTypes.containsKey(extension);
    }

    public void setDestinationId(String destinationId) {
        this.destinationId = destinationId;
    }

    static {
        try {
            FileUtils.forceMkdir((File)new File(MoserConfig.getInstance().getTempDirectory()));
            FileImportHandler.setInitialized(true);
        }
        catch (Exception e) {
            FileImportHandler.setInitialized(false);
            LoggerAdapter.errorExceptionStack(FileImportHandler.class, e);
        }
        HashMap<String, String> m = mimeTypes = new HashMap();
        m.put("xls", "application/vnd.ms-excel");
        m.put("xlm", "application/vnd.ms-excel");
        m.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        m.put("xlsm", "application/vnd.ms-excel.sheet.macroEnabled.12");
        m.put("xlsb", "application/vnd.ms-excel.sheet.binary.macroEnabled.12");
        m.put("csv", "application/csv");
        m.put("tsv", "text/csv");
        m.put("tab", "text/tab-separated-values");
        m.put("txt", "text/plain");
        m.put("zip", "application/zip");
        compressedMimeTypeSuffixes = new HashMap();
        m = compressedMimeTypeSuffixes;
        m.put("gz", "+gzip");
        BLOB_PATH = new File(MoserConfig.getInstance().getTempUploadDirectory() + "blobstore").getAbsolutePath();
        bInitialized = false;
    }
}

