/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.importer.file;

import com.ibm.bi.platform.datasetutils.utils.ReadableRecord;
import com.ibm.cognos.aurora.api.model.value.IValue;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;

public class FileReadableRecord
implements ReadableRecord {
    private final long rowIdOffset;
    private IValue[] tupleValues;

    public FileReadableRecord(long rowIdOffset) {
        this.rowIdOffset = rowIdOffset;
    }

    public void setRecord(IValue[] tupleValues) {
        this.tupleValues = tupleValues == null ? null : (IValue[])tupleValues.clone();
    }

    public int size() {
        return this.tupleValues.length;
    }

    public boolean isNull(int index) {
        return this.tupleValues[index].isNull();
    }

    public boolean getBoolean(int index) {
        return this.tupleValues[index].booleanValue();
    }

    public ByteBuffer getBinary(int index) {
        throw new UnsupportedOperationException("File Readable Record does not support binary data.");
    }

    public byte getByte(int index) {
        throw new UnsupportedOperationException("File Readable Record does not support byte data.");
    }

    public LocalDate getDate(int index) {
        return this.tupleValues[index].dateValue().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public LocalTime getTime(int index) {
        return LocalDateTime.ofInstant(this.tupleValues[index].dateValue().toInstant(), ZoneId.systemDefault()).toLocalTime();
    }

    public OffsetTime getOffsetTime(int index) {
        throw new UnsupportedOperationException("File Readable Record does not support offset time data.");
    }

    public LocalDateTime getDateTime(int index) {
        return LocalDateTime.ofInstant(this.tupleValues[index].dateValue().toInstant(), ZoneId.systemDefault());
    }

    public OffsetDateTime getOffsetDateTime(int index) {
        throw new UnsupportedOperationException("File Readable Record does not support offset date time data.");
    }

    public BigDecimal getDecimal(int index) {
        throw new UnsupportedOperationException("File Readable Record does not support decimal data.");
    }

    public double getDouble(int index) {
        return this.tupleValues[index].doubleValue();
    }

    public float getFloat(int index) {
        return this.tupleValues[index].floatValue();
    }

    public int getInt(int index) {
        return this.tupleValues[index].intValue();
    }

    public long getLong(int index) {
        return index == 0 ? this.tupleValues[index].longValue() + this.rowIdOffset : this.tupleValues[index].longValue();
    }

    public short getShort(int index) {
        return (short)this.tupleValues[index].intValue();
    }

    public String getString(int index) {
        return this.tupleValues[index].stringValue();
    }
}

