/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.importer.file;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.datasetutils.parquet.ParquetVersionEnum;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.info.MoserInfo;
import com.ibm.bi.platform.moser.common.generated.metadata.DataSource;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.Table;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.common.utils.ContentServiceException;
import com.ibm.bi.platform.moser.common.utils.IdentifierUtil;
import com.ibm.bi.platform.moser.common.utils.MoserCancelException;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.common.utils.MoserMessageKeys;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.common.utils.SmartsServiceException;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.importer.file.FileImportHandler;
import com.ibm.bi.platform.moser.core.importer.file.FileRefreshValidator;
import com.ibm.bi.platform.moser.core.module.IModuleObjectManager;
import com.ibm.bi.platform.moser.core.module.ModuleObjectManager;
import com.ibm.bi.platform.moser.core.module.container.UploadedFileContainer;
import com.ibm.bi.platform.moser.core.module.transformation.IModuleTransformation;
import com.ibm.bi.platform.moser.core.module.transformation.MakeRowId;
import com.ibm.bi.platform.moser.core.module.transformation.PhysicalToBaseModule;
import com.ibm.bi.platform.moser.core.module.util.ModuleUtil;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.ContentService;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.rest.service.SmartsService;
import com.ibm.bi.platform.moser.core.smarts.SmartsServiceUtil;
import com.ibm.bi.platform.moser.core.tasks.FileImportUtils;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserInfoUtil;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.json.java.JSONObject;
import com.ibm.neo.dataimport.ImportService;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.nodel.ds.UploadDataSource;
import com.ibm.neo.dataimport.nodel.ops.AnalyzeResult;
import com.ibm.neo.security.AnonymoustHelper;
import com.ibm.neo.util.ops.IOperation;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.core.Response;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class FileRefreshHandler
extends FileImportHandler {
    protected Module physicalModule;
    protected String uploadedFileId;

    public FileRefreshHandler(RequestEnvironment requestEnv) {
        super(requestEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object importFile(String uploadedFileID, InputStream input, String fileName, String mediaType, long contentLenth) {
        MoserInfo moserInfo;
        XMLGregorianCalendar startTime = MoserUtil.getCurrentTimeGregorianUTC();
        this.uploadedFileId = uploadedFileID;
        IModuleObjectManager mm = this.requestEnv.getModuleObjectManager();
        String uploadedFileName = mm.getDefaultName(this.uploadedFileId);
        AnonymoustHelper anonHelper = null;
        File tmpDir = null;
        UploadedFileContainer uploadedFile = null;
        UploadDataSource dataSource = null;
        try {
            Module existingPhysicalModule = this.getExisitingPhysicalModule(mm);
            anonHelper = new AnonymoustHelper(securityManager);
            anonHelper.bind();
            long fileSize = this.getFileSize(contentLenth, fileName);
            String strippedFileName = MoserUtil.stripInvalidFilenameCharactersIncludingDot(uploadedFileName);
            String existingFileName = existingPhysicalModule != null ? existingPhysicalModule.getLabel() : strippedFileName;
            this.incrementStatusStep(MoserMessageKeys.MSR_STS_READING_FILE, Long.toString(fileSize), fileName);
            dataSource = FileRefreshHandler.createUploadDataSource(this.requestEnv, strippedFileName, FileRefreshHandler.getMimeType(fileName, mediaType), input, fileSize);
            String msg = MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_STS_FILE_ANALYZE, (Locale)this.requestEnv.getProductLocale(), (String)fileName);
            LoggerAdapter.debug(this, msg);
            AnalyzeResult analyzeResult = FileRefreshHandler.analyzeDataSource(dataSource);
            this.incrementStatusStep(MoserMessageKeys.MSR_STS_FILE_BUILD, fileName);
            tmpDir = MoserUtil.createTempUploadDirectory("uplFile_");
            ParquetVersionEnum version = MoserConfig.getParquetVersion();
            this.generatePhysicalModuleAndParquet(existingPhysicalModule, existingFileName, tmpDir, dataSource, analyzeResult, version);
            FileImportUtils.checkQuota(tmpDir, uploadedFileID, this.requestEnv);
            IOperation removeOp = ImportService.getInstance().removeDataSource(dataSource.getId(), true, false);
            removeOp.join();
            anonHelper.unbind();
            anonHelper = null;
            IModuleTransformation transformation = new PhysicalToBaseModule();
            Module baseModule = transformation.apply(this.physicalModule);
            transformation = new MakeRowId(this.requestEnv);
            baseModule = transformation.apply(baseModule);
            String baseModuleIdentifier = "base";
            baseModuleIdentifier = ModuleUtil.buildUniqueModuleIdentifier("datasets", strippedFileName + "." + "base");
            baseModule.setIdentifier(baseModuleIdentifier);
            baseModule.setLabel(existingFileName);
            if (baseModule.getQuerySubject().size() == 1) {
                ((QuerySubject)baseModule.getQuerySubject().get(0)).setLabel(existingFileName);
            }
            uploadedFile = FileRefreshHandler.createUploadedFileContainer(uploadedFileName, tmpDir, this.physicalModule, baseModule, fileSize, startTime, version);
            this.incrementStatusStep(MoserMessageKeys.MSR_STS_FILE_SAVE, fileName);
            this.requestEnv.getTaskStatus().setState("NOT_CANCELLABLE");
            RESTClientResponse r = mm.putUploadedFile(this.uploadedFileId, uploadedFile);
            int respCode = r.getResponseCode();
            if (respCode != 201 && respCode != 204) {
                throw new ContentServiceException(r.getJSONObjectResponse(), r.getResponseCode());
            }
            this.fileId = uploadedFile.getStoreId();
            LoggerAdapter.info(this, "[PERF]: Begin - Smarts analysis for file");
            SmartsServiceUtil.initSmartsSubtask(this.requestEnv.getTaskStatus(), this.requestEnv.getProductLocale(), fileName);
            SmartsServiceUtil.createSmartsModule(this.fileId, baseModule, UseSpecType.FILE, Optional.empty(), t -> {}, SmartsService.AnalysisMode.DEEP, this.requestEnv, null, this.requestEnv.getTaskStatus(), null);
            LoggerAdapter.info(this, "[PERF]: End - Smarts analysis for file");
            msg = MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_STS_FILE_AUTOJOIN, (Locale)this.requestEnv.getProductLocale(), (String)fileName);
            LoggerAdapter.debug(this, msg);
            if (this.autoJoin(baseModule) && (respCode = mm.putBaseModule(this.fileId, baseModule)) != 201 && respCode != 204) {
                throw new ContentServiceException(r.getJSONObjectResponse(), r.getResponseCode());
            }
            msg = MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_STS_FILE_FINALIZING, (Locale)this.requestEnv.getProductLocale(), (String)fileName);
            LoggerAdapter.debug(this, msg);
            uploadedFile.setDisabled(Boolean.FALSE);
            this.requestEnv.getContentService().put(ContentService.ContentResource.OBJECTS, this.fileId, null, uploadedFile.toJSON());
            String baseModuleHRef = ModuleObjectManager.getBaseModuleHRef(this.fileId);
            moserInfo = MoserInfoUtil.createMoserInfo(baseModuleHRef, this.fileId, null, uploadedFileName, uploadedFile.getEndTime());
            FileUtils.deleteQuietly((File)tmpDir);
        }
        catch (MoserCancelException e) {
            throw e;
            catch (SmartsServiceException e2) {
                if (this.fileId != null && uploadedFile != null) {
                    uploadedFile.setDisabled(Boolean.FALSE);
                    this.requestEnv.getContentService().put(ContentService.ContentResource.OBJECTS, this.fileId, null, uploadedFile.toJSON());
                }
                LoggerAdapter.errorExceptionStack(this, e2);
                Response response = e2.getResponse(this.requestEnv.getProductLocale());
                return response;
            }
            catch (MoserException ex) {
                LoggerAdapter.errorExceptionStack(this, ex);
                Response response = ex.getResponse(this.requestEnv.getProductLocale());
                return response;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                catch (Exception e3) {
                    LoggerAdapter.errorExceptionStack(this, e3);
                    Object object = FileRefreshHandler.getDetailedFileUploadException(fileName, this.requestEnv.getProductLocale(), e3);
                    return object;
                }
            }
        }
        finally {
            FileUtils.deleteQuietly(tmpDir);
            if (anonHelper != null) {
                if (dataSource != null) {
                    try {
                        IOperation removeOp = ImportService.getInstance().removeDataSource(dataSource.getId(), true, false);
                        removeOp.join();
                    }
                    catch (WAImportException | CancellationException | ExecutionException ex) {
                        LoggerAdapter.errorExceptionStack(this, ex);
                    }
                }
                anonHelper.unbind();
            }
        }
        if (anonHelper == null) return moserInfo;
        if (dataSource != null) {
            try {
                IOperation removeOp = ImportService.getInstance().removeDataSource(dataSource.getId(), true, false);
                removeOp.join();
            }
            catch (WAImportException | CancellationException | ExecutionException ex) {
                LoggerAdapter.errorExceptionStack(this, ex);
            }
        }
        anonHelper.unbind();
        return moserInfo;
    }

    protected Module getExisitingPhysicalModule(IModuleObjectManager mm) {
        String physicalDefinition;
        Module existingPhysicalModule = null;
        JSONObject existingBM = mm.getUploadedFileJSON(this.uploadedFileId);
        if (existingBM != null && (physicalDefinition = (String)existingBM.get((Object)"physicalDefinition")) != null) {
            existingPhysicalModule = (Module)MoserUtil.decode(Module.class, physicalDefinition);
        }
        return existingPhysicalModule;
    }

    protected void generatePhysicalModuleAndParquet(Module existingPhysicalModule, String existingFileName, File tmpDir, UploadDataSource dataSource, AnalyzeResult analyzeResult, ParquetVersionEnum version) throws Exception {
        this.physicalModule = this.buildPhysicalModule(existingFileName, analyzeResult, tmpDir, version);
        if (existingPhysicalModule != null) {
            FileRefreshValidator validator = new FileRefreshValidator(this.requestEnv, existingPhysicalModule, this.physicalModule);
            Map<DataSource, DataSource> remaps = validator.checkFullyCovered();
            FileRefreshHandler.adjustTableNames(remaps, this.physicalModule, tmpDir);
        }
    }

    protected long getFileSize(long fileSize, String fileName) {
        return fileSize;
    }

    protected static void adjustTableNames(Map<DataSource, DataSource> remaps, Module physicalModule, File tmpDir) {
        boolean wasRenamed = false;
        ArrayList<DataSource> addedDataSources = new ArrayList<DataSource>();
        CaseInsensitiveMap seenMap = new CaseInsensitiveMap();
        for (DataSource dataSource : physicalModule.getDataSource()) {
            String oldName;
            DataSource oldDataSource = remaps.get(dataSource);
            if (oldDataSource == null) {
                addedDataSources.add(dataSource);
                continue;
            }
            String name = ((Table)dataSource.getTable().get(0)).getName();
            if (!name.equals(oldName = ((Table)oldDataSource.getTable().get(0)).getName())) {
                FileRefreshHandler.renameDataSource(oldName, dataSource, tmpDir);
                wasRenamed = true;
            }
            seenMap.put((Object)oldName, (Object)Boolean.TRUE);
        }
        if (wasRenamed && !addedDataSources.isEmpty()) {
            for (DataSource dataSource : addedDataSources) {
                String newName;
                String name = dataSource.getName();
                if (!name.equals(newName = IdentifierUtil.makeUniqueAndValidIdentifier((String)name, (CaseInsensitiveMap)seenMap))) {
                    FileRefreshHandler.renameDataSource(newName, dataSource, tmpDir);
                }
                seenMap.put((Object)newName, (Object)Boolean.TRUE);
            }
        }
    }

    private static boolean renameDataSource(String newName, DataSource dataSource, File tmpDir) {
        String oldName = FileRefreshHandler.generateFileName(dataSource.getName());
        dataSource.setName(newName);
        ((Table)dataSource.getTable().get(0)).setName(newName);
        File output = null;
        File[] files = tmpDir.listFiles();
        if (files == null) {
            throw new MoserException(MoserError.MSR_UPL_RENAME_SHEETS_NOT_FOUND, dataSource.getName(), newName);
        }
        for (File f : files) {
            if (!oldName.equals(FilenameUtils.getBaseName((String)f.getName()))) continue;
            output = f;
            break;
        }
        if (output == null) {
            throw new MoserException(MoserError.MSR_UPL_RENAME_SHEET_NOT_FOUND, dataSource.getName(), newName);
        }
        String destName = output.getAbsolutePath().replace(tmpDir.getAbsolutePath(), "");
        destName = destName.replaceFirst(oldName, FileRefreshHandler.generateFileName(newName));
        File dest = new File(tmpDir.getAbsolutePath() + destName);
        return output.renameTo(dest);
    }
}

