/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.importer.file;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.Column;
import com.ibm.bi.platform.moser.common.generated.metadata.DataSource;
import com.ibm.bi.platform.moser.common.generated.metadata.HighLevelDataType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.PhysicalObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.Table;
import com.ibm.bi.platform.moser.common.generated.metadata.TableItemType;
import com.ibm.bi.platform.moser.common.utils.FileRefreshException;
import com.ibm.bi.platform.moser.common.utils.MoserCommonUtils;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.utils.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class FileRefreshValidator {
    protected static final String NEWLINE = "\n";
    protected List<DataSource> missingSheets = new ArrayList<DataSource>();
    protected Map<Table, List<Column>> missingColumnsPerSheet = new LinkedHashMap<Table, List<Column>>();
    protected Map<Table, List<Pair<Column, Column>>> mismatchedColumnsPerSheet = new LinkedHashMap<Table, List<Pair<Column, Column>>>();
    protected final RequestEnvironment requestEnv;
    protected final Module physicalModule;
    protected final Module newPhysicalModule;

    public FileRefreshValidator(RequestEnvironment requestEnv, Module physicalModule, Module newPhysicalModule) {
        this.requestEnv = requestEnv;
        this.physicalModule = physicalModule;
        this.newPhysicalModule = newPhysicalModule;
    }

    public Map<DataSource, DataSource> checkFullyCovered() {
        DataSource newDataSource;
        HashMap<DataSource, DataSource> remap = new HashMap<DataSource, DataSource>();
        Map<String, DataSource> newDataSourceMap = this.buildDataSourceMap(this.newPhysicalModule);
        List dataSources = this.physicalModule.getDataSource();
        for (DataSource dataSource : this.physicalModule.getDataSource()) {
            DataSource dataSource2 = newDataSource = dataSources.size() == 1 && newDataSourceMap.size() == 1 ? newDataSourceMap.values().iterator().next() : newDataSourceMap.get(this.getOriginalName((PhysicalObjectType)dataSource));
            if (newDataSource == null) {
                this.missingSheets.add(dataSource);
                continue;
            }
            remap.put(newDataSource, dataSource);
            this.checkDataSourceFullyCovered(dataSource, newDataSource);
            newDataSourceMap.remove(this.getOriginalName((PhysicalObjectType)newDataSource));
        }
        Iterator<DataSource> iter = this.missingSheets.iterator();
        while (iter.hasNext()) {
            DataSource dataSource;
            dataSource = iter.next();
            newDataSource = this.findMatchingDataSource(dataSource, newDataSourceMap);
            if (newDataSource == null) continue;
            iter.remove();
            remap.put(newDataSource, dataSource);
            this.checkDataSourceFullyCovered(dataSource, newDataSource);
            newDataSourceMap.remove(this.getOriginalName((PhysicalObjectType)newDataSource));
        }
        this.throwIfNeeded();
        return remap;
    }

    protected DataSource findMatchingDataSource(DataSource dataSource, Map<String, DataSource> newDataSourceMap) {
        Set<String> columnNames = this.getColumnNames(dataSource);
        for (DataSource newDataSource : newDataSourceMap.values()) {
            Set<String> newColumnsNames = this.getColumnNames(newDataSource);
            if (!newColumnsNames.containsAll(columnNames)) continue;
            return newDataSource;
        }
        return null;
    }

    protected Set<String> getColumnNames(DataSource dataSource) {
        Table table = (Table)dataSource.getTable().get(0);
        LinkedHashSet<String> columnNames = new LinkedHashSet<String>();
        for (TableItemType tableItemType : table.getTableItem()) {
            columnNames.add(this.getOriginalName((PhysicalObjectType)tableItemType.getColumn()));
        }
        return columnNames;
    }

    protected Map<String, DataSource> buildDataSourceMap(Module module) {
        HashMap<String, DataSource> result = new HashMap<String, DataSource>();
        for (DataSource dataSource : module.getDataSource()) {
            result.put(this.getOriginalName((PhysicalObjectType)dataSource), dataSource);
        }
        return result;
    }

    protected void checkDataSourceFullyCovered(DataSource dataSource, DataSource newDataSource) {
        Table table = (Table)dataSource.getTable().get(0);
        Table newTable = (Table)newDataSource.getTable().get(0);
        this.checkTableFullyCovered(table, newTable);
    }

    protected void checkTableFullyCovered(Table table, Table newTable) {
        ArrayList<Column> missingColumns = new ArrayList<Column>();
        ArrayList<Pair<Column, Column>> mismatchedColumns = new ArrayList<Pair<Column, Column>>();
        Map<String, Column> newColumnMap = this.buildColumnMap(newTable);
        for (TableItemType tableItem : table.getTableItem()) {
            Column column = tableItem.getColumn();
            Column newColumn = newColumnMap.get(this.getOriginalName((PhysicalObjectType)column));
            if (newColumn == null) {
                missingColumns.add(column);
                continue;
            }
            if (this.matchingDatatypes(column.getDatatype(), newColumn.getDatatype())) continue;
            mismatchedColumns.add(new Pair<Column, Column>(column, newColumn));
        }
        if (!missingColumns.isEmpty()) {
            this.missingColumnsPerSheet.put(newTable, missingColumns);
        }
        if (!mismatchedColumns.isEmpty()) {
            this.mismatchedColumnsPerSheet.put(newTable, mismatchedColumns);
        }
    }

    protected Map<String, Column> buildColumnMap(Table table) {
        HashMap<String, Column> result = new HashMap<String, Column>();
        for (TableItemType tableItem : table.getTableItem()) {
            Column column = tableItem.getColumn();
            result.put(this.getOriginalName((PhysicalObjectType)column), column);
        }
        return result;
    }

    protected boolean matchingDatatypes(String datatype1, String datatype2) {
        HighLevelDataType type = MoserCommonUtils.generateHighlevelDatatype((String)datatype1);
        if (HighLevelDataType.STRING == type) {
            return true;
        }
        int bracket1 = datatype1.indexOf(40);
        int bracket2 = datatype2.indexOf(40);
        if (bracket1 > 0 && bracket1 == bracket2) {
            String s1 = datatype1.substring(0, bracket1);
            String s2 = datatype2.substring(0, bracket2);
            return s1.equals(s2);
        }
        if (this.resolveAmbiguity(datatype1, datatype2)) {
            return true;
        }
        return datatype1.equals(datatype2);
    }

    protected boolean resolveAmbiguity(String datatype1, String datatype2) {
        return !(!"BIGINT".equalsIgnoreCase(datatype1) && !"DOUBLE".equalsIgnoreCase(datatype1) || !"BIGINT".equalsIgnoreCase(datatype2) && !"DOUBLE".equalsIgnoreCase(datatype2));
    }

    protected boolean checkIfNeedToThrow() {
        return this.missingSheets.isEmpty() && this.missingColumnsPerSheet.isEmpty() && this.mismatchedColumnsPerSheet.isEmpty();
    }

    protected StringBuilder buildThrowReason() {
        StringBuilder reason = new StringBuilder();
        String tmp = this.buildMissingSheets();
        if (!tmp.isEmpty()) {
            reason.append(NEWLINE);
            reason.append(tmp);
        }
        if (!(tmp = this.buildMissingMismatchedSheets()).isEmpty()) {
            reason.append(NEWLINE);
            reason.append(tmp);
        }
        return reason;
    }

    protected void throwIfNeeded() {
        if (this.checkIfNeedToThrow()) {
            return;
        }
        StringBuilder reason = this.buildThrowReason();
        throw new FileRefreshException(this.requestEnv.getProductLocale(), this.physicalModule.getLabel(), reason.toString());
    }

    private String buildMissingSheets() {
        StringBuilder result = new StringBuilder();
        for (DataSource missingSheet : this.missingSheets) {
            if (result.length() > 0) {
                result.append(NEWLINE);
            }
            String sheetName = this.getOriginalName((PhysicalObjectType)missingSheet);
            result.append(MoserMessages.getMessage((IMessageKey.Param1)MoserError.MSR_UPL_MISSING_SHEET, (Locale)this.requestEnv.getProductLocale(), (String)sheetName));
        }
        return result.toString();
    }

    protected String getOriginalName(PhysicalObjectType object) {
        String name = object.getOriginalName();
        if (name != null && !name.isEmpty()) {
            return name;
        }
        name = object.getDescription();
        return name != null && !name.isEmpty() ? name : object.getName();
    }

    private String buildMissingMismatchedSheets() {
        LinkedHashSet<Table> sheets = new LinkedHashSet<Table>();
        sheets.addAll(this.missingColumnsPerSheet.keySet());
        sheets.addAll(this.mismatchedColumnsPerSheet.keySet());
        boolean isMultiSheet = this.physicalModule.getDataSource().size() > 1;
        StringBuilder result = new StringBuilder();
        for (Table sheet : sheets) {
            if (this.missingColumnsPerSheet.containsKey(sheet)) {
                if (result.length() > 0) {
                    result.append(NEWLINE);
                }
                result.append(this.buildMissingColumns(isMultiSheet, sheet, this.missingColumnsPerSheet.get(sheet)));
            }
            if (!this.mismatchedColumnsPerSheet.containsKey(sheet)) continue;
            if (result.length() > 0) {
                result.append(NEWLINE);
            }
            result.append(this.buildMismatchedColumns(isMultiSheet, sheet, this.mismatchedColumnsPerSheet.get(sheet)));
        }
        return result.toString();
    }

    private String buildMissingColumns(boolean isMultiSheet, Table sheet, List<Column> missingColumns) {
        StringBuilder columns = new StringBuilder();
        for (Column column : missingColumns) {
            if (columns.length() != 0) {
                columns.append("\", \"");
            }
            columns.append(this.getOriginalName((PhysicalObjectType)column));
        }
        if (isMultiSheet) {
            String sheetName = this.getOriginalName((PhysicalObjectType)sheet);
            IMessageKey.Param2 key = missingColumns.size() == 1 ? MoserError.MSR_UPL_SHEET_MISSING_COLUMN : MoserError.MSR_UPL_SHEET_MISSING_COLUMNS;
            return MoserMessages.getMessage((IMessageKey.Param2)key, (Locale)this.requestEnv.getProductLocale(), (String)sheetName, (String)columns.toString());
        }
        IMessageKey.Param1 key = missingColumns.size() == 1 ? MoserError.MSR_UPL_MISSING_COLUMN : MoserError.MSR_UPL_MISSING_COLUMNS;
        return MoserMessages.getMessage((IMessageKey.Param1)key, (Locale)this.requestEnv.getProductLocale(), (String)columns.toString());
    }

    private String buildMismatchedColumns(boolean isMultiSheet, Table sheet, List<Pair<Column, Column>> mismatchedColumns) {
        StringBuilder result = new StringBuilder();
        for (Pair<Column, Column> mismatchedColumn : mismatchedColumns) {
            if (result.length() > 0) {
                result.append(NEWLINE);
            }
            result.append(this.buildMismatchedColumn(isMultiSheet, sheet, mismatchedColumn));
        }
        return result.toString();
    }

    protected String buildMismatchedColumn(boolean isMultiSheet, Table sheet, Pair<Column, Column> mismatchedColumn) {
        Column column = mismatchedColumn.getFirst();
        Column newColumn = mismatchedColumn.getSecond();
        String columnName = this.getOriginalName((PhysicalObjectType)newColumn);
        String dataType = column.getDatatype();
        String newDataType = newColumn.getDatatype();
        if (isMultiSheet) {
            String sheetName = this.getOriginalName((PhysicalObjectType)sheet);
            return MoserMessages.getMessage((IMessageKey.Param4)MoserError.MSR_UPL_SHEET_INCOMPATIBLE_DATATYPE, (Locale)this.requestEnv.getProductLocale(), (String)sheetName, (String)columnName, (String)dataType, (String)newDataType);
        }
        return MoserMessages.getMessage((IMessageKey.Param3)MoserError.MSR_UPL_INCOMPATIBLE_DATATYPE, (Locale)this.requestEnv.getProductLocale(), (String)columnName, (String)dataType, (String)newDataType);
    }
}

