/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.importer.file;

import com.ibm.bi.platform.datasetutils.metadata.Column;
import com.ibm.bi.platform.datasetutils.metadata.ColumnMetadata;
import com.ibm.bi.platform.datasetutils.metadata.TabularRowSchema;
import com.ibm.bi.platform.datasetutils.metadata.types.Type;
import com.ibm.bi.platform.datasetutils.metadata.types.TypeFactory;
import com.ibm.neo.dataimport.nodel.DataItem;
import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.nodel.EDataType;
import java.util.EnumMap;

public class FileRowSchema
extends TabularRowSchema {
    private static final EnumMap<EDataType, Type> EDataType2Type = new EnumMap(EDataType.class);

    public FileRowSchema(Dataset dataset) {
        for (DataItem dataItem : dataset.getDataItems()) {
            this.appendColumn((ColumnMetadata)new Column(dataItem.getName().trim(), true, EDataType2Type.get(dataItem.getDataType())));
        }
    }

    public static String getXQETypeString(DataItem dataItem) {
        return EDataType2Type.get(dataItem.getDataType()).toXQETypeString();
    }

    static {
        EDataType2Type.put(EDataType.BOOLEAN, (Type)TypeFactory.BOOLEAN_TYPE);
        EDataType2Type.put(EDataType.CHAR, (Type)TypeFactory.STRING_TYPE);
        EDataType2Type.put(EDataType.DATE, (Type)TypeFactory.DATE_TYPE);
        EDataType2Type.put(EDataType.DECIMAL64, (Type)TypeFactory.DOUBLE_TYPE);
        EDataType2Type.put(EDataType.FLOAT32, (Type)TypeFactory.FLOAT_TYPE);
        EDataType2Type.put(EDataType.FLOAT64, (Type)TypeFactory.DOUBLE_TYPE);
        EDataType2Type.put(EDataType.INT16, (Type)TypeFactory.SHORT_TYPE);
        EDataType2Type.put(EDataType.INT32, (Type)TypeFactory.INTEGER_TYPE);
        EDataType2Type.put(EDataType.INT64, (Type)TypeFactory.LONG_TYPE);
        EDataType2Type.put(EDataType.INT8, (Type)TypeFactory.SHORT_TYPE);
        EDataType2Type.put(EDataType.STRING, (Type)TypeFactory.STRING_TYPE);
        EDataType2Type.put(EDataType.TIME, (Type)TypeFactory.TIME_TYPE);
        EDataType2Type.put(EDataType.TIMESTAMP, (Type)TypeFactory.TIMESTAMP_TYPE);
    }
}

