/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.importer.file;

import com.ibm.icu.util.Currency;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.Map;

public class VendorFormatToV5FormatConverter {
    static final String CURRENCY_CODE_IN = "currency-code";
    static final String CURRENCY_SYMBOL_IN = "currency-symbol";
    static final String GROUPING_SIZE = "grouping-size";
    static final String HAS_CURRENCY = "has-currency";
    static final String HAS_PERCENT = "has-percent";
    static final String HAS_PERMIL = "has-permil";
    static final String FORMAT_PATTERN = "format-pattern";
    static final String FORMAT_GROUP = "formatGroup";
    static final String CURRENCY_FORMAT = "currencyFormat";
    static final String DATE_FORMAT = "dateFormat";
    static final String DATETIME_FORMAT = "dateTimeFormat";
    static final String NUMBER_FORMAT = "numberFormat";
    static final String PERCENT_FORMAT = "percentFormat";
    static final String TIME_FORMAT = "timeFormat";
    static final String CLOCK = "clock";
    static final String CURRENCY_CODE = "currencyCode";
    static final String CURRENCY_SYMBOL = "currencySymbol";
    static final String DECIMAL_SIZE = "decimalSize";
    static final String DISPLAY_ORDER = "displayOrder";
    static final String DATE_STYLE = "dateStyle";
    static final String SHOW_AMPM = "showAmPm";
    static final String USE_GROUPING = "useGrouping";
    static final String USE_INTLSYMBOL = "useIntlSymbol";

    private VendorFormatToV5FormatConverter() {
    }

    public static String getVendorFormat(String dataItem) throws IOException {
        if (dataItem == null || dataItem.isEmpty()) {
            return null;
        }
        JSONObject parser = JSONObject.parse((String)dataItem);
        JSONObject o = (JSONObject)parser.get((Object)"format-hints");
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public static String getV5Format(String vendorFormat) throws IOException {
        if (vendorFormat == null || vendorFormat.isEmpty()) {
            return null;
        }
        JSONObject parser = JSONObject.parse((String)vendorFormat);
        if (parser == null || parser.isEmpty()) {
            return null;
        }
        String numberType = NUMBER_FORMAT;
        String formatVal = (String)parser.get((Object)FORMAT_PATTERN);
        JSONObject retVal = new JSONObject();
        JSONObject numType = new JSONObject();
        boolean theresInfo = false;
        boolean isADate = VendorFormatToV5FormatConverter.isDate(formatVal);
        boolean isATime = VendorFormatToV5FormatConverter.isTime(formatVal);
        JSONObject builder = VendorFormatToV5FormatConverter.translateFormatString(formatVal);
        if (builder == null) {
            builder = new JSONObject();
        } else {
            theresInfo = true;
        }
        if (isADate && isATime) {
            numberType = DATETIME_FORMAT;
            theresInfo = true;
        } else if (isADate) {
            numberType = DATE_FORMAT;
            theresInfo = true;
        } else if (isATime) {
            numberType = TIME_FORMAT;
            theresInfo = true;
        } else {
            JSONObject tmp = VendorFormatToV5FormatConverter.getGenericInfo(parser);
            if (tmp != null) {
                builder.putAll((Map)tmp);
                theresInfo = true;
            }
            if ("true".equals(parser.get((Object)HAS_CURRENCY).toString())) {
                numberType = CURRENCY_FORMAT;
                theresInfo = true;
                builder.putAll((Map)VendorFormatToV5FormatConverter.getCurrencyInfo(parser));
            } else if ("true".equals(parser.get((Object)HAS_PERCENT).toString())) {
                numberType = PERCENT_FORMAT;
                theresInfo = true;
            }
        }
        if (theresInfo) {
            numType.put((Object)numberType, (Object)builder);
            retVal.put((Object)FORMAT_GROUP, (Object)numType);
            return retVal.toString();
        }
        return null;
    }

    private static JSONObject getGenericInfo(JSONObject formatInfoIn) {
        if (formatInfoIn == null || formatInfoIn.isEmpty() || !formatInfoIn.containsKey((Object)FORMAT_PATTERN)) {
            return null;
        }
        JSONObject retVal = new JSONObject();
        JSONObject parser = formatInfoIn;
        if (!"0".equals(parser.get((Object)GROUPING_SIZE).toString())) {
            retVal.put((Object)USE_GROUPING, (Object)"true");
        } else {
            retVal.put((Object)USE_GROUPING, (Object)"false");
        }
        return retVal;
    }

    private static JSONObject translateFormatString(String inFormatString) {
        if (inFormatString == null || inFormatString.isEmpty()) {
            return null;
        }
        String formatString = inFormatString;
        JSONObject retVal = new JSONObject();
        boolean isADate = VendorFormatToV5FormatConverter.isDate(formatString);
        boolean isATime = VendorFormatToV5FormatConverter.isTime(formatString);
        if (isATime) {
            if (formatString.contains("H:")) {
                retVal.put((Object)CLOCK, (Object)"24-hour");
            } else if (formatString.contains("h:")) {
                retVal.put((Object)CLOCK, (Object)"12-hour");
                retVal.put((Object)SHOW_AMPM, (Object)"true");
            }
        }
        if (isADate) {
            String type = formatString.contains("EEEE") || formatString.contains("EEE") ? "full" : (formatString.contains("MMMM") || formatString.contains("mmmm") ? "long" : (formatString.contains("MMM") || formatString.contains("mmm") ? "medium" : "short"));
            retVal.put((Object)DATE_STYLE, (Object)type);
            String s = VendorFormatToV5FormatConverter.getDateOrder(formatString);
            if (s != null) {
                retVal.put((Object)DISPLAY_ORDER, (Object)s);
            }
        } else if (formatString.indexOf(46) > -1) {
            int decPadding = 0;
            for (int i = formatString.indexOf(".") + 1; i < formatString.length() && formatString.charAt(i) == '0'; ++i) {
                ++decPadding;
            }
            if (decPadding > 0) {
                retVal.put((Object)DECIMAL_SIZE, (Object)Integer.toString(decPadding));
            }
        } else if (!(formatString.contains(".") || isADate || isATime)) {
            retVal.put((Object)DECIMAL_SIZE, (Object)"0");
        }
        return retVal.isEmpty() ? null : retVal;
    }

    private static String getDateOrder(String formatStringIn) {
        if (formatStringIn == null || formatStringIn.isEmpty()) {
            return null;
        }
        String formatString = formatStringIn;
        String retVal = null;
        boolean mIs = formatString.contains("M");
        boolean dIs = formatString.contains("d");
        boolean yIs = formatString.contains("y");
        if (mIs && dIs && yIs) {
            int mPos = formatString.indexOf("M");
            int dPos = formatString.indexOf("d");
            int yPos = formatString.indexOf("y");
            retVal = yPos > mPos ? (dPos > mPos ? "MDY" : "DMY") : "YMD";
        }
        return retVal;
    }

    private static JSONObject getCurrencyInfo(JSONObject formatInfo) {
        String code;
        String pat;
        JSONObject retVal = new JSONObject();
        Currency c = null;
        if (formatInfo == null || formatInfo.isEmpty() || "false".equals(formatInfo.get((Object)HAS_CURRENCY).toString())) {
            return retVal;
        }
        if (formatInfo.containsKey((Object)CURRENCY_CODE_IN) && formatInfo.get((Object)CURRENCY_CODE_IN) != null) {
            c = Currency.getInstance((String)formatInfo.get((Object)CURRENCY_CODE_IN).toString());
        } else if (formatInfo.containsKey((Object)FORMAT_PATTERN) && !formatInfo.get((Object)FORMAT_PATTERN).toString().isEmpty() && (pat = formatInfo.get((Object)FORMAT_PATTERN).toString()).contains("[$") && pat.contains("]") && (code = pat.substring(pat.indexOf("$") + 1, pat.indexOf("]"))).length() == 3) {
            c = Currency.getInstance((String)code);
            if (c == null) {
                retVal.put((Object)CURRENCY_CODE, (Object)code);
                retVal.put((Object)USE_INTLSYMBOL, (Object)"true");
            } else {
                retVal.put((Object)CURRENCY_CODE, (Object)c.getCurrencyCode());
                retVal.put((Object)USE_INTLSYMBOL, (Object)"true");
            }
        }
        if (c != null) {
            retVal.put((Object)CURRENCY_CODE, (Object)c.getCurrencyCode());
            retVal.put((Object)CURRENCY_SYMBOL, (Object)c.getSymbol());
        } else if (formatInfo.containsKey((Object)CURRENCY_SYMBOL_IN) && !formatInfo.get((Object)CURRENCY_SYMBOL_IN).toString().isEmpty()) {
            retVal.put((Object)CURRENCY_SYMBOL, formatInfo.get((Object)CURRENCY_SYMBOL_IN));
        }
        if (formatInfo.get((Object)CURRENCY_SYMBOL_IN) != null && ("***".equals(formatInfo.get((Object)CURRENCY_SYMBOL_IN).toString()) || "\u0000a4".equals(formatInfo.get((Object)CURRENCY_SYMBOL_IN).toString()))) {
            retVal.put((Object)USE_INTLSYMBOL, (Object)"true");
        }
        return retVal;
    }

    private static boolean isDate(String formatString) {
        if (formatString == null) {
            return false;
        }
        return formatString.indexOf(121) > -1 || formatString.indexOf(100) > -1;
    }

    private static boolean isTime(String formatString) {
        if (formatString == null) {
            return false;
        }
        return formatString.contains("h") || formatString.contains("H") || formatString.contains("s");
    }
}

