/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.importer.jupyter;

import com.ibm.bi.platform.moser.common.exceptions.file.UnsupportedFileTypeException;
import com.ibm.bi.platform.moser.common.exceptions.jupyter.JupyterInvalidGZipException;
import com.ibm.bi.platform.moser.core.importer.ImportReceipt;
import com.ibm.bi.platform.moser.core.importer.jupyter.JupyterImportHandler;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.RESTUtils;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FilenameUtils;

public class GZipJupyterImportHandler
extends JupyterImportHandler {
    private final JSONObject parentMimeTypeAndExtensions = GZipJupyterImportHandler.getSupportedMimeTypes(this.getClass().getSuperclass());

    public GZipJupyterImportHandler(RequestEnvironment requestEnv) {
        super(requestEnv);
    }

    @Override
    public boolean isSupported(String mimeType, String fileName) {
        if (!super.isSupported(mimeType, fileName)) {
            return false;
        }
        return GZipJupyterImportHandler.isSupported(this.parentMimeTypeAndExtensions, "application/octet-stream", FilenameUtils.removeExtension((String)fileName));
    }

    @Override
    public void preImportData(String fileName, String destinationId) {
        super.preImportData(FilenameUtils.removeExtension((String)fileName), destinationId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ImportReceipt importData(InputStream data, String fileName, String mimeType, String destinationId) {
        ImportReceipt receipt = new ImportReceipt();
        if (!this.isSupported(mimeType, fileName)) {
            throw new UnsupportedFileTypeException(fileName);
        }
        try (GZIPInputStream gzis = new GZIPInputStream(data);){
            RESTClientResponse resp = this.doImportData(gzis, FilenameUtils.removeExtension((String)fileName), destinationId);
            receipt.getIds().add(RESTUtils.getLocationStoreId(resp));
            receipt.finish();
            ImportReceipt importReceipt = receipt;
            return importReceipt;
        }
        catch (IOException e) {
            LoggerAdapter.errorExceptionStack(this, e);
            throw new JupyterInvalidGZipException(fileName, (Exception)e);
        }
    }

    @Override
    public void preReplaceData(String fileName, String objectId) {
        super.preReplaceData(FilenameUtils.removeExtension((String)fileName), objectId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ImportReceipt replaceData(InputStream data, String fileName, String mimeType, String objectId) {
        ImportReceipt receipt = new ImportReceipt();
        if (!this.isSupported(mimeType, fileName)) {
            throw new UnsupportedFileTypeException(fileName);
        }
        try (GZIPInputStream gzis = new GZIPInputStream(data);){
            this.doReplaceData(gzis, FilenameUtils.removeExtension((String)fileName), objectId);
            receipt.getIds().add(objectId);
            receipt.finish();
            ImportReceipt importReceipt = receipt;
            return importReceipt;
        }
        catch (IOException e) {
            LoggerAdapter.errorExceptionStack(this, e);
            throw new JupyterInvalidGZipException(fileName, (Exception)e);
        }
    }
}

