/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.importer.jupyter;

import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.ibm.bi.platform.moser.common.exceptions.file.DestinationNotFoundException;
import com.ibm.bi.platform.moser.common.exceptions.file.NameConflictException;
import com.ibm.bi.platform.moser.common.exceptions.file.NotFoundException;
import com.ibm.bi.platform.moser.common.exceptions.file.OverwritePrompt;
import com.ibm.bi.platform.moser.common.exceptions.file.UnsupportedFileTypeException;
import com.ibm.bi.platform.moser.common.exceptions.file.WrongTypeException;
import com.ibm.bi.platform.moser.common.exceptions.jupyter.JupyterInvalidJSONException;
import com.ibm.bi.platform.moser.common.exceptions.jupyter.JupyterInvalidSpecificationException;
import com.ibm.bi.platform.moser.common.utils.ContentServiceException;
import com.ibm.bi.platform.moser.core.cm.objects.JupyterNotebook;
import com.ibm.bi.platform.moser.core.importer.AbstractImportHandler;
import com.ibm.bi.platform.moser.core.importer.ImportReceipt;
import com.ibm.bi.platform.moser.core.importer.jupyter.validator.JupyterValidatorV3;
import com.ibm.bi.platform.moser.core.importer.jupyter.validator.JupyterValidatorV4;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.RESTUtils;
import com.ibm.bi.platform.moser.core.rest.service.ContentService;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FilenameUtils;

public class JupyterImportHandler
extends AbstractImportHandler {
    public JupyterImportHandler(RequestEnvironment requestEnv) {
        super(requestEnv);
    }

    @Override
    public void preImportData(String fileName, String destinationId) {
        JupyterNotebook notebook = new JupyterNotebook();
        notebook.setDefaultName(FilenameUtils.removeExtension((String)fileName));
        this.doPreImportData(notebook.getDefaultName(), destinationId);
    }

    @Override
    public ImportReceipt importData(InputStream data, String fileName, String mimeType, String destinationId) {
        ImportReceipt receipt = new ImportReceipt();
        if (!this.isSupported(mimeType, fileName)) {
            throw new UnsupportedFileTypeException(fileName);
        }
        RESTClientResponse resp = this.doImportData(data, fileName, destinationId);
        receipt.getIds().add(RESTUtils.getLocationStoreId(resp));
        receipt.finish();
        return receipt;
    }

    @Override
    public void preReplaceData(String fileName, String objectId) {
        JupyterNotebook notebook = new JupyterNotebook();
        notebook.setDefaultName(FilenameUtils.removeExtension((String)fileName));
        this.doPreReplaceData(notebook.getDefaultName(), objectId);
    }

    @Override
    public ImportReceipt replaceData(InputStream data, String fileName, String mimeType, String objectId) {
        ImportReceipt receipt = new ImportReceipt();
        if (!this.isSupported(mimeType, fileName)) {
            throw new UnsupportedFileTypeException(fileName);
        }
        this.doReplaceData(data, fileName, objectId);
        receipt.getIds().add(objectId);
        receipt.finish();
        return receipt;
    }

    @Override
    public void preAppendData(String fileName, String objectId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImportReceipt appendData(InputStream data, String fileName, String mimeType, String objectId) {
        throw new UnsupportedOperationException();
    }

    protected void doPreImportData(String defaultName, String destinationId) {
        ContentService cs = this.requestEnv.getContentService();
        RESTClientResponse resp = cs.get(ContentService.ContentResource.OBJECTS, destinationId, ContentService.ContentSubResource.ITEMS, null, "type", "defaultName");
        if (resp.getResponseCode() != Response.Status.OK.getStatusCode()) {
            throw new DestinationNotFoundException();
        }
        JSONArray data = (JSONArray)resp.getJSONObjectResponse().get((Object)"data");
        for (Object o : data) {
            JSONObject current = (JSONObject)o;
            if (!defaultName.equals(current.get((Object)"defaultName"))) continue;
            if ("jupyterNotebook".equals(current.get((Object)"type"))) {
                throw new OverwritePrompt(defaultName, (String)current.get((Object)"id"));
            }
            throw new NameConflictException(defaultName);
        }
    }

    protected RESTClientResponse doImportData(InputStream data, String fileName, String destinationId) {
        JSONObject specification;
        JupyterNotebook notebook = new JupyterNotebook();
        notebook.setDefaultName(FilenameUtils.removeExtension((String)fileName));
        try {
            specification = JSONObject.parse((InputStream)data);
        }
        catch (IOException e) {
            LoggerAdapter.errorExceptionStack(this, e);
            throw new JupyterInvalidJSONException(fileName, (Exception)e);
        }
        this.validate(fileName, specification);
        notebook.setSpecification(specification);
        ContentService cs = this.requestEnv.getContentService();
        RESTClientResponse resp = cs.post(ContentService.ContentResource.OBJECTS, destinationId, ContentService.ContentSubResource.ITEMS, notebook);
        if (resp.getResponseCode() != Response.Status.CREATED.getStatusCode()) {
            this.doPreImportData(notebook.getDefaultName(), destinationId);
            throw new ContentServiceException(resp.getJSONObjectResponse(), resp.getResponseCode());
        }
        return resp;
    }

    private void validate(String fileName, JSONObject specification) {
        try {
            if (new JupyterValidatorV4().validate(specification).isSuccess()) {
                return;
            }
        }
        catch (ProcessingException | IOException e) {
            LoggerAdapter.debug((Object)this, e.getLocalizedMessage(), e);
        }
        try {
            if (new JupyterValidatorV3().validate(specification).isSuccess()) {
                return;
            }
        }
        catch (ProcessingException | IOException e) {
            LoggerAdapter.debug((Object)this, e.getLocalizedMessage(), e);
        }
        throw new JupyterInvalidSpecificationException(fileName);
    }

    protected void doPreReplaceData(String defaultName, String objectId) {
        ContentService cs = this.requestEnv.getContentService();
        RESTClientResponse resp = cs.get(ContentService.ContentResource.OBJECTS, objectId, null, null, "type");
        if (resp.getResponseCode() != Response.Status.OK.getStatusCode()) {
            throw new NotFoundException(defaultName);
        }
        JSONArray data = (JSONArray)resp.getJSONObjectResponse().get((Object)"data");
        JSONObject current = (JSONObject)data.get(0);
        if (!"jupyterNotebook".equals(current.get((Object)"type"))) {
            throw new WrongTypeException(defaultName);
        }
    }

    protected void doReplaceData(InputStream data, String fileName, String objectId) {
        JSONObject specification;
        try {
            specification = JSONObject.parse((InputStream)data);
        }
        catch (IOException e) {
            LoggerAdapter.errorExceptionStack(this, e);
            throw new JupyterInvalidJSONException(fileName, (Exception)e);
        }
        this.validate(fileName, specification);
        JupyterNotebook notebook = new JupyterNotebook();
        notebook.setSpecification(specification);
        ContentService cs = this.requestEnv.getContentService();
        RESTClientResponse resp = cs.put(ContentService.ContentResource.OBJECTS, objectId, null, notebook);
        if (resp.getResponseCode() != Response.Status.NO_CONTENT.getStatusCode()) {
            this.doPreReplaceData(notebook.getDefaultName(), objectId);
            throw new ContentServiceException(resp.getJSONObjectResponse(), resp.getResponseCode());
        }
    }
}

