/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.importer.jupyter;

import com.ibm.bi.platform.moser.common.exceptions.file.DestinationNotFoundException;
import com.ibm.bi.platform.moser.common.exceptions.file.EmptyArchiveException;
import com.ibm.bi.platform.moser.common.exceptions.file.InvalidArchiveException;
import com.ibm.bi.platform.moser.common.exceptions.file.NameConflictException;
import com.ibm.bi.platform.moser.common.exceptions.file.OverwritePrompt;
import com.ibm.bi.platform.moser.common.exceptions.file.UnsupportedFileTypeException;
import com.ibm.bi.platform.moser.common.exceptions.file.WrongTypeException;
import com.ibm.bi.platform.moser.common.exceptions.jupyter.JupyterArchiveUnsupportedFileException;
import com.ibm.bi.platform.moser.common.utils.ContentServiceException;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.cm.objects.Folder;
import com.ibm.bi.platform.moser.core.cm.objects.JupyterNotebook;
import com.ibm.bi.platform.moser.core.importer.ImportReceipt;
import com.ibm.bi.platform.moser.core.importer.jupyter.JupyterImportHandler;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.RESTUtils;
import com.ibm.bi.platform.moser.core.rest.service.ContentService;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FilenameUtils;

public class ZipJupyterImportHandler
extends JupyterImportHandler {
    private final JSONObject parentMimeTypeAndExtensions = ZipJupyterImportHandler.getSupportedMimeTypes(this.getClass().getSuperclass());

    public ZipJupyterImportHandler(RequestEnvironment requestEnv) {
        super(requestEnv);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isReallySupported(String mimeType, String fileName, InputStream data) {
        if (!this.isSupported(mimeType, fileName)) {
            return false;
        }
        try (ZipInputStream zis = new ZipInputStream(data);){
            ZipEntry ze;
            int fileCount = 0;
            while ((ze = zis.getNextEntry()) != null) {
                String name = ze.getName();
                if (ze.isDirectory() || Paths.get(name, new String[0]).getParent() != null) continue;
                if (!ZipJupyterImportHandler.isSupported(this.parentMimeTypeAndExtensions, "application/octet-stream", name)) {
                    boolean bl = false;
                    return bl;
                }
                ++fileCount;
                zis.closeEntry();
            }
            boolean bl = fileCount > 0;
            return bl;
        }
        catch (IOException e) {
            LoggerAdapter.errorExceptionStack(this, e);
            return false;
        }
    }

    @Override
    public ImportReceipt importData(InputStream data, String fileName, String mimeType, String destinationId) {
        if (!this.isSupported(mimeType, fileName)) {
            throw new UnsupportedFileTypeException(fileName);
        }
        ImportReceipt receipt = new ImportReceipt();
        Folder folder = new Folder();
        folder.setDefaultName(FilenameUtils.removeExtension((String)fileName));
        ContentService cs = this.requestEnv.getContentService();
        RESTClientResponse resp = cs.post(ContentService.ContentResource.OBJECTS, destinationId, ContentService.ContentSubResource.ITEMS, folder);
        if (resp.getResponseCode() != Response.Status.CREATED.getStatusCode()) {
            throw new ContentServiceException(resp.getJSONObjectResponse(), resp.getResponseCode());
        }
        String folderId = RESTUtils.getLocationStoreId(resp);
        try (ZipInputStream zis = new ZipInputStream(data);){
            this.doImportData(receipt, fileName, folderId, zis);
        }
        catch (IOException e) {
            cs.delete(ContentService.ContentResource.OBJECTS, true, true, folderId);
            LoggerAdapter.errorExceptionStack(this, e);
            throw new InvalidArchiveException(fileName, (Exception)e);
        }
        catch (MoserException e) {
            cs.delete(ContentService.ContentResource.OBJECTS, true, true, folderId);
            LoggerAdapter.debug((Object)this, "Failed to process an entry in zip file: " + fileName, e);
            throw e;
        }
        receipt.finish();
        return receipt;
    }

    @Override
    public ImportReceipt replaceData(InputStream data, String fileName, String mimeType, String objectId) {
        if (!this.isSupported(mimeType, fileName)) {
            throw new UnsupportedFileTypeException(fileName);
        }
        ImportReceipt receipt = new ImportReceipt();
        try (ZipInputStream zis = new ZipInputStream(data);){
            this.doReplaceData(receipt, fileName, objectId, zis, this.buildNameToStoreId(objectId));
        }
        catch (IOException e) {
            LoggerAdapter.errorExceptionStack(this, e);
            throw new InvalidArchiveException(fileName, (Exception)e);
        }
        catch (MoserException e) {
            LoggerAdapter.debug((Object)this, "Failed to process an entry in zip file: " + fileName, e);
            throw e;
        }
        receipt.finish();
        return receipt;
    }

    private Map<String, String> buildNameToStoreId(String objectId) {
        ContentService cs = this.requestEnv.getContentService();
        RESTClientResponse resp = cs.get(ContentService.ContentResource.OBJECTS, objectId, ContentService.ContentSubResource.ITEMS, null, "defaultName", "type");
        if (Response.Status.OK.getStatusCode() != resp.getResponseCode()) {
            throw new DestinationNotFoundException();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        JSONArray data = (JSONArray)resp.getJSONObjectResponse().get((Object)"data");
        for (Object o : data) {
            JSONObject current = (JSONObject)o;
            String defaultName = (String)current.get((Object)"defaultName");
            if ("jupyterNotebook".equals(current.get((Object)"type"))) {
                result.put(defaultName, (String)current.get((Object)"id"));
                continue;
            }
            result.put(defaultName, "");
        }
        return result;
    }

    @Override
    protected void doPreImportData(String defaultName, String destinationId) {
        ContentService cs = this.requestEnv.getContentService();
        RESTClientResponse resp = cs.get(ContentService.ContentResource.OBJECTS, destinationId, ContentService.ContentSubResource.ITEMS, null, "type", "defaultName");
        if (resp.getResponseCode() != Response.Status.OK.getStatusCode()) {
            throw new DestinationNotFoundException();
        }
        JSONArray data = (JSONArray)resp.getJSONObjectResponse().get((Object)"data");
        for (Object o : data) {
            JSONObject current = (JSONObject)o;
            if (!defaultName.equals(current.get((Object)"defaultName"))) continue;
            if ("folder".equals(current.get((Object)"type"))) {
                throw new OverwritePrompt(defaultName, (String)current.get((Object)"id"));
            }
            throw new NameConflictException(defaultName);
        }
    }

    private void doImportData(ImportReceipt receipt, String parentFileName, String folderId, ZipInputStream zis) throws IOException {
        ZipEntry ze;
        int fileCount = 0;
        while ((ze = zis.getNextEntry()) != null) {
            String fileName = ze.getName();
            if (ze.isDirectory() || Paths.get(fileName, new String[0]).getParent() != null) continue;
            ++fileCount;
            if (!ZipJupyterImportHandler.isSupported(this.parentMimeTypeAndExtensions, "application/octet-stream", fileName)) {
                throw new JupyterArchiveUnsupportedFileException(parentFileName, fileName);
            }
            RESTClientResponse resp = super.doImportData(zis, fileName, folderId);
            zis.closeEntry();
            if (resp.getResponseCode() != Response.Status.CREATED.getStatusCode()) {
                throw new ContentServiceException(resp.getJSONObjectResponse(), resp.getResponseCode());
            }
            receipt.getIds().add(RESTUtils.getLocationStoreId(resp));
        }
        if (fileCount < 1) {
            throw new EmptyArchiveException(parentFileName);
        }
    }

    @Override
    protected void doPreReplaceData(String defaultName, String destinationId) {
        ContentService cs = this.requestEnv.getContentService();
        RESTClientResponse resp = cs.get(ContentService.ContentResource.OBJECTS, destinationId, ContentService.ContentSubResource.ITEMS, null, "type", "defaultName");
        if (resp.getResponseCode() != Response.Status.OK.getStatusCode()) {
            throw new DestinationNotFoundException();
        }
        JSONArray data = (JSONArray)resp.getJSONObjectResponse().get((Object)"data");
        JSONObject current = (JSONObject)data.get(0);
        if (!"folder".equals(current.get((Object)"type"))) {
            throw new WrongTypeException(defaultName);
        }
    }

    private void doReplaceData(ImportReceipt receipt, String parentFileName, String objectId, ZipInputStream zis, Map<String, String> nameToStoreId) throws IOException {
        ZipEntry ze;
        int fileCount = 0;
        while ((ze = zis.getNextEntry()) != null) {
            String fileName = ze.getName();
            if (ze.isDirectory() || Paths.get(fileName, new String[0]).getParent() != null) continue;
            ++fileCount;
            if (!ZipJupyterImportHandler.isSupported(this.parentMimeTypeAndExtensions, "application/octet-stream", fileName)) {
                throw new JupyterArchiveUnsupportedFileException(parentFileName, fileName);
            }
            JupyterNotebook notebook = new JupyterNotebook();
            notebook.setDefaultName(FilenameUtils.removeExtension((String)fileName));
            String storeId = nameToStoreId.get(notebook.getDefaultName());
            if (storeId == null) {
                RESTClientResponse resp = super.doImportData(zis, fileName, objectId);
                if (resp.getResponseCode() != Response.Status.CREATED.getStatusCode()) {
                    throw new ContentServiceException(resp.getJSONObjectResponse(), resp.getResponseCode());
                }
                receipt.getIds().add(RESTUtils.getLocationStoreId(resp));
            } else {
                if (storeId.isEmpty()) {
                    throw new WrongTypeException(fileName);
                }
                super.doReplaceData(zis, fileName, storeId);
                receipt.getIds().add(storeId);
            }
            zis.closeEntry();
        }
        if (fileCount < 1) {
            throw new EmptyArchiveException(parentFileName);
        }
    }
}

