/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.io;

import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;

public class MultiFileInputStream
extends InputStream {
    Enumeration<? extends File> e;
    InputStream in;

    public MultiFileInputStream(Enumeration<? extends File> e) {
        this.e = e;
        try {
            this.nextStream();
        }
        catch (IOException ex) {
            LoggerAdapter.error((Object)this, ex.getLocalizedMessage(), ex);
            throw new Error(ex.getLocalizedMessage());
        }
    }

    final void nextStream() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        this.in = this.e.hasMoreElements() ? new FileInputStream(this.e.nextElement()) : null;
    }

    @Override
    public int available() throws IOException {
        if (this.in == null) {
            return 0;
        }
        return this.in.available();
    }

    @Override
    public int read() throws IOException {
        while (this.in != null) {
            int c = this.in.read();
            if (c != -1) {
                return c;
            }
            this.nextStream();
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.in == null) {
            return -1;
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        do {
            int n;
            if ((n = this.in.read(b, off, len)) > 0) {
                return n;
            }
            this.nextStream();
        } while (this.in != null);
        return -1;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }
}

