/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.ma;

import com.ibm.bi.common.exceptions.cqe.catalogs.CQEError;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.ma.AmbiguousConnectionException;
import com.ibm.bi.platform.moser.core.ma.AmbiguousSignonException;
import com.ibm.bi.platform.moser.core.ma.LogonFailureException;
import com.ibm.bi.soap.services.SoapException;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.Response;

public abstract class DataSourceException
extends MoserException {
    public static final String DS_DATASOURCE = "dataSource";
    public static final String DS_DATASOURCENAME = "dataSourceName";
    public static final String DS_DATASOURCECONNECTIONNAME = "dataSourceConnectionName";
    public static final String DS_CONNECTION = "connection";
    public static final String DS_CONNECTIONS = "connections";
    public static final String DS_FAULTDATASOURCE = "faultDataSource";
    public static final String DS_FAULTCONNECTION = "faultConnection";
    public static final String DS_SIGNON = "signon";
    public static final String DS_SIGNONS = "signons";
    public static final String DS_SUBCODE = "subcode";
    public static final String CODE = "code";
    public static final String MESSAGE = "message";
    public static final String ERRORS = "errors";
    public static final String PARAMETERS = "parameters";
    public static final String NAME = "name";
    private static final long serialVersionUID = 2852974247491606336L;
    private String datasource = null;
    private String connection = null;
    private transient List<String> connections = null;
    private transient List<String> signons = null;
    protected JSONObject response = null;
    private JSONObject params = null;
    private String subcode = null;

    public DataSourceException(SoapException cause, IMessageKey.Param0 key) {
        super(key, (Throwable)cause);
        this.httpStatus = Response.Status.FORBIDDEN.getStatusCode();
    }

    public DataSourceException(IMessageKey.Param0 key) {
        super(key);
        this.httpStatus = Response.Status.FORBIDDEN.getStatusCode();
    }

    public abstract Object getRESTResponseEntity(Locale var1);

    public void addParam(String name, String value) {
        if (this.response == null) {
            throw new RuntimeException("DataSourceException.addParam() response not initialized. Call initResponse");
        }
        this.params.put((Object)name, (Object)value);
    }

    public void addArrayParam(String name, List<String> values) {
        if (this.response == null) {
            throw new RuntimeException("DataSourceException.addParam() response not initialized. Call initResponse");
        }
        if (values != null && !values.isEmpty()) {
            JSONArray jValues = new JSONArray();
            for (String value : values) {
                JSONObject jValue = new JSONObject();
                jValue.put((Object)NAME, (Object)value);
                jValues.add((Object)jValue);
            }
            this.params.put((Object)name, (Object)jValues);
        }
    }

    protected void setSubcode(String subcode) {
        this.subcode = subcode;
    }

    protected String getSubcode() {
        return this.subcode;
    }

    protected void initResponse(Locale productLocale) {
        this.response = new JSONObject();
        JSONObject error = new JSONObject();
        error.put((Object)CODE, (Object)this.getErrorCode());
        error.put((Object)MESSAGE, (Object)this.getLocalizedMessage(productLocale));
        if (this.subcode != null) {
            error.put((Object)DS_SUBCODE, (Object)this.subcode);
        }
        JSONArray parameters = new JSONArray();
        error.put((Object)PARAMETERS, (Object)parameters);
        this.params = new JSONObject();
        parameters.add((Object)this.params);
        JSONArray errors = new JSONArray();
        errors.add((Object)error);
        this.response.put((Object)ERRORS, (Object)errors);
    }

    protected void setDatasource(String ds) {
        this.datasource = ds;
    }

    protected void setConnection(String c) {
        this.connection = c;
    }

    protected void setConnections(List<String> c) {
        this.connections = c;
    }

    protected void setSignons(List<String> s) {
        this.signons = s;
    }

    protected String getDatasource() {
        return this.datasource;
    }

    protected String getConnection() {
        return this.connection;
    }

    protected List<String> getConnections() {
        return this.connections;
    }

    protected List<String> getSignons() {
        return this.signons;
    }

    protected void processFaultDetails(SoapException soapFault) {
        block4: {
            JsonArray jConnections;
            block5: {
                Map details = (Map)soapFault.getErrorDetails();
                if (details == null) break block4;
                String faultDatasource = DataSourceException.getFaultField(details, DS_FAULTDATASOURCE);
                String faultConnection = DataSourceException.getFaultField(details, DS_FAULTCONNECTION);
                JsonArray jDatasources = (JsonArray)details.get(DS_DATASOURCE);
                this.datasource = (String)details.get(DS_DATASOURCENAME);
                this.connection = (String)details.get(DS_DATASOURCECONNECTIONNAME);
                String logonFailureSubcode = (String)details.get(DS_SUBCODE);
                if (logonFailureSubcode != null) {
                    this.setSubcode(logonFailureSubcode);
                }
                if (jDatasources == null || jDatasources.isEmpty()) break block4;
                JsonObject jDatasource = DataSourceException.filterJSONArray(jDatasources, faultDatasource);
                this.datasource = jDatasource.getString(NAME);
                jConnections = jDatasource.getArray(DS_CONNECTION);
                if (jConnections == null || jConnections.isEmpty()) break block4;
                JsonObject jConnection = DataSourceException.filterJSONArray(jConnections, faultConnection);
                this.connection = (String)jConnection.get(NAME);
                if (!CQEError.DS_AmbiguousSignon.getErrorCode().equals(soapFault.getErrorCode())) break block5;
                JsonArray jSignons = jConnection.getArray(DS_SIGNON);
                if (jSignons == null || jSignons.isEmpty()) break block4;
                this.signons = new ArrayList<String>();
                for (Object oS : jSignons) {
                    JsonObject jSignon = (JsonObject)oS;
                    this.signons.add(jSignon.getString(NAME));
                }
                break block4;
            }
            if (CQEError.DS_AmbiguousConnection.getErrorCode().equals(soapFault.getErrorCode())) {
                this.connections = new ArrayList<String>();
                for (Object oC : jConnections) {
                    JsonObject jC = (JsonObject)oC;
                    this.connections.add(jC.getString(NAME));
                }
            }
        }
    }

    private static JsonObject filterJSONArray(JsonArray items, String nameValue) {
        if (nameValue == null) {
            return (JsonObject)items.get(0);
        }
        for (Object o : items) {
            JsonObject jItem = (JsonObject)o;
            if (!nameValue.equals(jItem.get(NAME))) continue;
            return jItem;
        }
        return (JsonObject)items.get(0);
    }

    private static String getFaultField(Map<?, ?> details, String field) {
        Object o = details.get(field);
        if (o != null) {
            if (o instanceof String) {
                return (String)o;
            }
            JsonObject jField = (JsonObject)o;
            return jField.getString(NAME);
        }
        return null;
    }

    public static DataSourceException fromJSON(JSONObject jObj) {
        if (jObj == null) {
            return null;
        }
        JSONArray errors = (JSONArray)jObj.get((Object)ERRORS);
        if (errors == null || errors.isEmpty()) {
            return null;
        }
        JSONObject error = (JSONObject)errors.get(0);
        String errorCode = (String)error.get((Object)CODE);
        JSONArray parameters = (JSONArray)error.get((Object)PARAMETERS);
        if (parameters == null || parameters.isEmpty()) {
            return null;
        }
        JSONObject parameter = (JSONObject)parameters.get(0);
        String dsName = (String)parameter.get((Object)DS_DATASOURCENAME);
        if (errorCode.equals(CQEError.DS_DataSourceLogonFailure.getErrorCode())) {
            return new LogonFailureException(dsName, (String)parameter.get((Object)DS_DATASOURCECONNECTIONNAME), (String)error.get((Object)DS_SUBCODE));
        }
        if (errorCode.equals(CQEError.DS_AmbiguousConnection.getErrorCode())) {
            return new AmbiguousConnectionException(dsName, DataSourceException.convertToListArray((JSONArray)parameter.get((Object)DS_CONNECTIONS)));
        }
        if (errorCode.equals(CQEError.DS_AmbiguousSignon.getErrorCode())) {
            return new AmbiguousSignonException(dsName, (String)parameter.get((Object)DS_DATASOURCECONNECTIONNAME), DataSourceException.convertToListArray((JSONArray)parameter.get((Object)DS_SIGNONS)));
        }
        return null;
    }

    private static List<String> convertToListArray(JSONArray jConnections) {
        ArrayList<String> connections = new ArrayList<String>();
        for (Object jConnection : jConnections) {
            JSONObject jConn = (JSONObject)jConnection;
            connections.add((String)jConn.get((Object)NAME));
        }
        return connections;
    }
}

