/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.ma;

import com.ibm.bi.platform.moser.common.generated.metadata.Calculation;
import com.ibm.bi.platform.moser.common.generated.metadata.Filter;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectFactory;
import com.ibm.bi.platform.moser.common.generated.metadata.ParameterMap;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.Relationship;
import com.ibm.bi.platform.moser.core.ma.MAModuleReader;
import com.ibm.bi.platform.moser.core.metadata.ModuleContentViewer;
import com.ibm.bi.platform.moser.core.module.IModuleObjectManager;
import java.util.List;

public class MAResponseGenerator {
    private MAModuleReader moduleReader = null;
    private final boolean generateShortIdForExpr;

    public MAResponseGenerator(IModuleObjectManager mm, boolean shortId) {
        this.moduleReader = new MAModuleReader(mm);
        this.generateShortIdForExpr = shortId;
    }

    public Module getMAResponse(String moduleId, Module module, List<String> fields) {
        this.moduleReader.add(moduleId, module);
        ModuleContentViewer.Options ops = new ModuleContentViewer.Options();
        ops.addOption("resolveRef", "true");
        ModuleContentViewer viewer = new ModuleContentViewer(this.moduleReader, ops, this.generateShortIdForExpr);
        return MAResponseGenerator.getMetadataResponse(viewer, moduleId, module, fields);
    }

    public static Module cleanUse(String moduleId, Module module) {
        List use = module.getUse();
        use.clear();
        use.add(moduleId);
        return module;
    }

    public static Module getMetadataResponse(ModuleContentViewer viewer, String moduleId, Module module, List<String> fields) {
        List mdtvs;
        viewer.generateMetadataResponse(moduleId, true);
        if (!fields.isEmpty()) {
            if (!fields.contains(QuerySubject.class.getSimpleName())) {
                module.getQuerySubject().clear();
            }
            if (!fields.contains(Relationship.class.getSimpleName())) {
                module.getRelationship().clear();
            }
            if (!fields.contains(ParameterMap.class.getSimpleName())) {
                module.getParameterMap().clear();
            }
            if (!fields.contains(Calculation.class.getSimpleName())) {
                module.getCalculation().clear();
            }
            if (!fields.contains(Filter.class.getSimpleName())) {
                module.getFilter().clear();
            }
        }
        if ((mdtvs = module.getMetadataTreeView()).isEmpty() || ((FolderType)mdtvs.get(0)).getFolderItem().isEmpty()) {
            MAResponseGenerator.generateDefaultTreeView(mdtvs, module.basicGetQuerySubject(), module.basicGetCalculation(), module.basicGetFilter());
        }
        return module;
    }

    public static void generateDefaultTreeView(List<FolderType> mtv, List<QuerySubject> qs, List<Calculation> calcs, List<Filter> filts) {
        FolderItemType fi;
        ObjectFactory factory = new ObjectFactory();
        mtv.clear();
        FolderType folder = factory.createFolderType();
        mtv.add(folder);
        List folderItemList = folder.getFolderItem();
        if (qs != null) {
            for (QuerySubject q : qs) {
                fi = factory.createFolderItemType();
                fi.setRef(q.getIdentifier());
                folderItemList.add(fi);
            }
        }
        if (calcs != null) {
            for (Calculation c : calcs) {
                fi = factory.createFolderItemType();
                fi.setRef(c.getIdentifier());
                folderItemList.add(fi);
            }
        }
        if (filts != null) {
            for (Filter f : filts) {
                fi = factory.createFolderItemType();
                fi.setRef(f.getIdentifier());
                folderItemList.add(fi);
            }
        }
    }
}

