/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.ma;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MoserXQECommon {
    protected static final String CMD_VALIDATE = "validate";
    protected static final String CMD_VALIDATE_ALL = "validateAll";
    protected static final String MOSER_FUNCTION_TYPE = "moserFunctionType";
    public static final String PAR_CONNSPEC = "connectionSpec";
    protected static final String PAR_MODULE = "module";
    protected static final String PAR_VERSION = "version";
    protected static final String PARAMETR_VALUE = "parameterValue";

    public static Map<String, String> validateExpressionPrepareSpec(String moduleStoreId, String objectId, JSONObject jExpression, String connectionSpec) throws IOException {
        JSONArray values;
        JSONObject jexpression = JSONObject.parse((String)jExpression.serialize());
        String expressionParam = "";
        String expressionText = (String)jexpression.get((Object)"filterExpression");
        if (expressionText != null) {
            expressionParam = "filterExpression";
        } else {
            expressionText = (String)jexpression.get((Object)"calculationExpression");
            if (expressionText != null) {
                expressionParam = "calculationExpression";
            }
        }
        String usage = (String)jexpression.get((Object)"usage");
        String regularAggr = (String)jexpression.get((Object)"regularAggregate");
        HashMap<String, String> functionSpec = new HashMap<String, String>();
        functionSpec.put(MOSER_FUNCTION_TYPE, CMD_VALIDATE);
        functionSpec.put(PAR_MODULE, moduleStoreId);
        functionSpec.put("identifier", objectId);
        functionSpec.put(expressionParam, expressionText);
        functionSpec.put(PAR_VERSION, "4");
        if (connectionSpec != null) {
            functionSpec.put(PAR_CONNSPEC, connectionSpec);
        }
        if (usage != null && !usage.isEmpty()) {
            functionSpec.put("usage", usage);
        }
        if (regularAggr != null && !regularAggr.isEmpty()) {
            functionSpec.put("regularAggregate", regularAggr);
        }
        if ((values = (JSONArray)jexpression.get((Object)PARAMETR_VALUE)) != null && !values.isEmpty()) {
            functionSpec.put(PARAMETR_VALUE, values.toString());
        }
        return functionSpec;
    }

    public static Map<String, String> validateExpressionsPrepareSpec(String moduleStoreId, String connSpec) {
        HashMap<String, String> functionSpec = new HashMap<String, String>();
        functionSpec.put(MOSER_FUNCTION_TYPE, CMD_VALIDATE_ALL);
        functionSpec.put(PAR_MODULE, moduleStoreId);
        functionSpec.put(PAR_VERSION, "4");
        if (connSpec != null) {
            functionSpec.put(PAR_CONNSPEC, connSpec);
        }
        return functionSpec;
    }
}

