/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.ma;

import com.ibm.bi.common.exceptions.cqe.catalogs.CQEError;
import com.ibm.bi.json.DefaultJsonFactory;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.common.utils.ModuleNotFoundException;
import com.ibm.bi.platform.moser.common.utils.MoserCancelException;
import com.ibm.bi.platform.moser.common.utils.MoserConnectionSpec;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.common.utils.MoserMessageKeys;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.ma.AmbiguousConnectionException;
import com.ibm.bi.platform.moser.core.ma.AmbiguousSignonException;
import com.ibm.bi.platform.moser.core.ma.LogonFailureException;
import com.ibm.bi.platform.moser.core.ma.MoserPassThroughXQEException;
import com.ibm.bi.platform.moser.core.ma.MoserSoapFactory;
import com.ibm.bi.platform.moser.core.ma.MoserXQECommon;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.soap.services.BiBus;
import com.ibm.bi.soap.services.SoapContext;
import com.ibm.bi.soap.services.SoapException;
import com.ibm.bi.soap.services.SoapTransportFactory;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;

public class MoserXQESoapBridge
extends MoserXQECommon {
    private static final String CMD_GET_FACET_VALUES = "getFacetValues";
    private static final String CMD_CANCEL = "cancelTask";
    private static final String CMD_GET_PACKAGE_METADATA = "getPackageMetadata";
    private static final String CMD_GET_OLAP_METADATA = "getOlapMetadata";
    public static final String GETLISTFUNC = "getFunctionList";
    private static final String CMD_GETNORMALIZEDIDENTIFIERS = "getNormalizedIdentifiers";
    private static final String CMD_GETDSEXCEPTIONS = "getDataSourceExceptions";
    private static final String CMD_PARAM_OFFSET = "offset";
    private static final String CMD_PARAM_LIMIT = "limit";
    private static final String CMD_PARAM_SEARCH = "search";
    private static final String CMD_RT_FACETVALUES = "facetValues";
    public static final String CMD_RT_X_TOTAL_COUNT = "X-Total-Count";
    public static final String CMD_GET_CATALOGS_SCHEMAS = "getCatalogsSchemas";
    public static final String CMD_GET_LIST_OF_FUNCTIONS = "getListOfFunctions";
    public static final String CMD_GET_TABLES = "getTables";
    public static final String CMD_IMPORT_TABLES = "importTables";
    private static final String CMD_EXPANDMACROS = "expandMacros";
    private static final String PAR_PACKAGE = "package";
    private static final String PAR_MODEL_PATH = "modelPath";
    private static final String PAR_CM_DATA_SOURCE = "cmDataSource";
    private static final String PAR_DATA_SOURCE_TYPE = "dataSourceType";
    private static final String PAR_CATALOG = "catalog";
    private static final String PAR_SCHEMA = "schema";
    private static final String PAR_CUBE = "cube";
    private static final String REQUEST_STRING = "requestString";
    private static final String PAR_PACKAGE_NAME = "packageName";
    private static final String PAR_IDPREFIX = "idPrefix";
    private static final String PAR_IDENTIFIERS = "identifiers";
    private static final String PAR_MODULETYPE = "moduleType";
    private static final String PAR_MACRO_EXPR = "expressions";
    private static final String PAR_PROVIDER_CODE = "providerCode";
    private static final String LIST_OF_FUNCTIONS = "listOfFunctions";
    public static final String DATA = "data";
    public static final String MSG = "msg";
    public static final String SEV = "severity";
    public static final String WARNING = "warning";
    private static final String ERROR_CODE_XQE_MODEL_NOT_FOUND = "CQE-1214";
    private static final String ERROR_CODE_XQE_UNRESOLVED_PARAM = "QF-888";
    private static final int DEFAULT_FACET_VALUES_LIMIT = 100;
    private static final int MIN_FACET_VALUES_LIMIT = 1;
    private static final int MAX_FACET_VALUES_LIMIT = 10000;
    private static final String FUNCTIONS = "configuration" + File.separator + "functions" + File.separator;
    private static final String WLP_INSTALL_LOCATION = "wlp.install.dir";
    private static final String EN_US = "en-us";
    private static final Object FUNCTIONS_QUERY_SPEC_FILE = "MAFunctionQuery.xml";
    private static final String UTF_8 = "UTF-8";
    private static final String PAR_ITEMIDS = "itemIDs";
    private static final String EXCLUDED_TABLES = "excludedTables";
    private static final String LOADOPTIONS = "loadOptions";

    private MoserXQESoapBridge() {
    }

    public static JSONObject getFacetValues(HttpServletRequest request, String path, String module, String attributeId, int offset, int l, String search, String[] totalCount, Locale prodLocale, String parameters, String connectionSpec) {
        HashMap<String, String> functionSpec = new HashMap<String, String>();
        functionSpec.put("moserFunctionType", CMD_GET_FACET_VALUES);
        functionSpec.put("module", module);
        functionSpec.put("attributeId", attributeId);
        if (offset > 0) {
            functionSpec.put(CMD_PARAM_OFFSET, Integer.toString(offset));
        }
        String msg = null;
        int limit = l;
        if (limit == 0) {
            limit = 100;
            msg = MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_FACET_GET_VALUES_DEFAULT_LIMIT, (Locale)prodLocale, (String)String.valueOf(100));
        } else if (limit < 1) {
            limit = 1;
            msg = MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_FACET_GET_VALUES_MIN_LIMIT, (Locale)prodLocale, (String)String.valueOf(1));
        } else if (limit > 10000) {
            limit = 10000;
            msg = MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_FACET_GET_VALUES_MAX_LIMIT, (Locale)prodLocale, (String)String.valueOf(10000));
        }
        functionSpec.put(CMD_PARAM_LIMIT, Integer.toString(limit));
        if (search != null && !search.isEmpty()) {
            functionSpec.put(CMD_PARAM_SEARCH, search);
        }
        if (parameters != null && !parameters.isEmpty()) {
            functionSpec.put("parameters", parameters);
        }
        if (connectionSpec != null) {
            functionSpec.put("connectionSpec", connectionSpec);
        }
        JSONArray r = MoserXQESoapBridge.doMoserCommand(null, request, path, functionSpec);
        return MoserXQESoapBridge.returnFacetValues(r, totalCount, msg);
    }

    private static JSONObject returnFacetValues(JSONArray r, String[] totalCount, String msg) {
        String n;
        JSONObject rt = new JSONObject();
        if (r.size() != 1) {
            return rt;
        }
        JSONObject jsonR = null;
        try {
            jsonR = JSONObject.parse((String)((String)r.get(0)));
        }
        catch (IOException e) {
            throw new MoserException((Throwable)e);
        }
        JSONArray vals = (JSONArray)jsonR.get((Object)CMD_RT_FACETVALUES);
        if (vals == null) {
            return rt;
        }
        rt.put((Object)DATA, (Object)vals);
        if (msg != null) {
            JSONArray rtMsg = new JSONArray();
            JSONObject w = new JSONObject();
            w.put((Object)SEV, (Object)WARNING);
            w.put((Object)MSG, (Object)msg);
            rtMsg.add((Object)w);
            rt.put((Object)MSG, (Object)rtMsg);
        }
        if ((n = (String)jsonR.get((Object)CMD_RT_X_TOTAL_COUNT)) != null && totalCount != null) {
            totalCount[0] = n;
        }
        return rt;
    }

    private static JSONArray doMoserCommand(String taskID, HttpServletRequest request, String path, Map<String, String> functionSpec) {
        return MoserXQESoapBridge.doMoserCommand2(taskID, request, path, functionSpec, null);
    }

    public static JSONArray doMoserCommand2(String taskID, HttpServletRequest request, String path, Map<String, String> functionSpec, String routingServerGroup) {
        if (taskID != null) {
            functionSpec.put("taskID", taskID);
        }
        JSONArray response = new JSONArray();
        try {
            boolean noJSONParsing = CMD_GET_FACET_VALUES.equals(functionSpec.get("moserFunctionType")) || CMD_GETNORMALIZEDIDENTIFIERS.equals(functionSpec.get("moserFunctionType"));
            SoapContext soapContext = new SoapContext(request);
            if (routingServerGroup != null && !routingServerGroup.isEmpty()) {
                soapContext.setRequestHeader("X-CA-Routing", routingServerGroup);
            }
            BiBus biBus = new BiBus(SoapTransportFactory.getInstance().create(), soapContext, path, DefaultJsonFactory.instance, MoserSoapFactory.getInstance());
            List rt = biBus.queryService.moserCommand(functionSpec);
            if (rt != null) {
                for (Object v : rt) {
                    response.add(noJSONParsing ? v : JSONObject.parse((String)((String)v)));
                }
            }
        }
        catch (SoapException e) {
            MoserXQESoapBridge.handleSoapException(e, functionSpec.get("moserFunctionType"));
        }
        catch (Exception e) {
            throw new MoserException((Throwable)e);
        }
        return response;
    }

    private static void handleSoapException(SoapException e, String moserFunction) {
        String errorCode = e.getErrorCode();
        if ("RSA-ERR-0007".equals(errorCode)) {
            throw new MoserCancelException("Unknown");
        }
        MoserXQESoapBridge.throwIfDatasourceException(e, errorCode);
        String msg = e.getLocalizedMessage();
        JsonObject details = (JsonObject)e.getErrorDetails();
        if (details != null && details.containsKey((Object)"messages")) {
            try {
                JsonArray array = details.getArray("messages");
                msg = array.getString(0);
            }
            catch (Exception ex) {
                LoggerAdapter.trace(MoserXQESoapBridge.class, ex.getLocalizedMessage(), ex);
            }
        }
        if (ERROR_CODE_XQE_UNRESOLVED_PARAM.equals(errorCode)) {
            throw new MoserPassThroughXQEException(Response.Status.PRECONDITION_FAILED, msg);
        }
        if (ERROR_CODE_XQE_MODEL_NOT_FOUND.equals(errorCode)) {
            throw new ModuleNotFoundException(MoserError.MSR_MODULE_NOT_FOUND, msg);
        }
        throw new MoserException(MoserError.GENERAL_ERROR, msg);
    }

    private static void throwIfDatasourceException(SoapException e, String errorCode) {
        if (errorCode.equals(CQEError.DS_DataSourceLogonFailure.getErrorCode())) {
            throw new LogonFailureException(e);
        }
        if (errorCode.equals(CQEError.DS_AmbiguousConnection.getErrorCode())) {
            throw new AmbiguousConnectionException(e);
        }
        if (errorCode.equals(CQEError.DS_AmbiguousSignon.getErrorCode())) {
            throw new AmbiguousSignonException(e);
        }
    }

    public static JSONObject validateExpression(HttpServletRequest request, String path, String moduleStoreId, String objectId, JSONObject jExpression, String connectionSpec) throws IOException {
        Map<String, String> functionSpec = MoserXQESoapBridge.validateExpressionPrepareSpec(moduleStoreId, objectId, jExpression, connectionSpec);
        return (JSONObject)MoserXQESoapBridge.doMoserCommand(null, request, path, functionSpec).get(0);
    }

    public static JSONObject validateExpressions(HttpServletRequest request, String path, String moduleStoreId, MoserConnectionSpec connSpec) {
        String connSpecString = null;
        if (connSpec != null) {
            connSpecString = connSpec.toString();
        }
        Map<String, String> functionSpec = MoserXQESoapBridge.validateExpressionsPrepareSpec(moduleStoreId, connSpecString);
        return (JSONObject)MoserXQESoapBridge.doMoserCommand(null, request, path, functionSpec).get(0);
    }

    public static void cancelMoserCommand(String taskID, HttpServletRequest request, String baseURL) {
        HashMap<String, String> functionSpec = new HashMap<String, String>();
        functionSpec.put("moserFunctionType", CMD_CANCEL);
        MoserXQESoapBridge.doMoserCommand(taskID, request, baseURL, functionSpec);
    }

    public static JSONObject getListOfFunctions(HttpServletRequest request, String baseURL, String moduleID, String file, String connectionSpec, String locale) {
        JSONObject result;
        block9: {
            HashMap<String, String> functionSpec = new HashMap<String, String>();
            String requestString = null;
            try {
                String filePath;
                if (FUNCTIONS_QUERY_SPEC_FILE.equals(file)) {
                    String inV5Query = FUNCTIONS + file;
                    String mInstallRoot = MoserConfig.constructDir(System.getProperty(WLP_INSTALL_LOCATION), ".." + File.separator);
                    filePath = MoserConfig.constructDir(mInstallRoot, inV5Query);
                } else {
                    filePath = file;
                }
                requestString = FileUtils.readFileToString((File)new File(filePath), (String)UTF_8);
                if (!EN_US.equalsIgnoreCase(locale)) {
                    requestString = requestString.replaceAll(EN_US, locale);
                }
            }
            catch (IOException e) {
                throw new MoserException(MoserError.MSR_READ_MA_REQ_FILE, (Throwable)e);
            }
            functionSpec.put("moserFunctionType", GETLISTFUNC);
            functionSpec.put("module", moduleID);
            functionSpec.put(REQUEST_STRING, requestString);
            if (connectionSpec != null) {
                functionSpec.put("connectionSpec", connectionSpec);
            }
            result = null;
            try {
                result = (JSONObject)MoserXQESoapBridge.doMoserCommand2(null, request, baseURL, functionSpec, null).get(0);
                String xml = (String)result.get((Object)LIST_OF_FUNCTIONS);
                if (xml != null) {
                    xml = xml.replaceAll("qosLevel=\"unavailable\"", "qosLevel=\"OK\"");
                    result.put((Object)LIST_OF_FUNCTIONS, (Object)xml);
                }
            }
            catch (MoserException e) {
                if (MoserError.MSR_MODULE_NOT_FOUND.getErrorCode().equals(e.getErrorCode())) break block9;
                throw e;
            }
        }
        return result;
    }

    public static JSONObject getPackageMetadata(String taskID, HttpServletRequest request, String baseURL, String modelPath, String packageName, String idPrefix, String version, String routingServerGroup, MoserConnectionSpec connSpec, List<String> ids) {
        JSONObject result;
        block7: {
            HashMap<String, String> functionSpec = new HashMap<String, String>();
            functionSpec.put("moserFunctionType", CMD_GET_PACKAGE_METADATA);
            functionSpec.put(PAR_MODEL_PATH, modelPath);
            if (packageName != null) {
                functionSpec.put(PAR_PACKAGE_NAME, packageName);
            }
            if (idPrefix != null) {
                functionSpec.put(PAR_IDPREFIX, idPrefix);
            }
            if (version != null) {
                functionSpec.put("version", "3.0".equals(version) ? "3" : version);
            }
            if (connSpec != null) {
                functionSpec.put("connectionSpec", connSpec.toString());
            }
            if (ids != null && !ids.isEmpty()) {
                functionSpec.put(PAR_ITEMIDS, MoserXQESoapBridge.convertToJsonArrayString(ids));
            }
            result = null;
            try {
                result = (JSONObject)MoserXQESoapBridge.doMoserCommand2(taskID, request, baseURL, functionSpec, routingServerGroup).get(0);
            }
            catch (MoserException e) {
                if (MoserError.MSR_MODULE_NOT_FOUND.getErrorCode().equals(e.getErrorCode())) break block7;
                throw e;
            }
        }
        return result;
    }

    public static JSONObject getCatalogsAndSchemas(String taskID, HttpServletRequest request, String baseURL, String cmDataSource, String dataSourceType, String providerCode, MoserConnectionSpec connSpec) {
        JSONObject result;
        block4: {
            HashMap<String, String> functionSpec = new HashMap<String, String>();
            functionSpec.put("moserFunctionType", CMD_GET_CATALOGS_SCHEMAS);
            functionSpec.put(PAR_CM_DATA_SOURCE, cmDataSource);
            functionSpec.put(PAR_DATA_SOURCE_TYPE, dataSourceType);
            if (providerCode != null) {
                functionSpec.put(PAR_PROVIDER_CODE, providerCode);
            }
            if (connSpec != null) {
                functionSpec.put("connectionSpec", connSpec.toString());
            }
            result = null;
            try {
                result = (JSONObject)MoserXQESoapBridge.doMoserCommand(taskID, request, baseURL, functionSpec).get(0);
            }
            catch (MoserException e) {
                if (MoserError.MSR_MODULE_NOT_FOUND.getErrorCode().equals(e.getErrorCode())) break block4;
                throw e;
            }
        }
        return result;
    }

    public static JSONObject getTables(String taskID, HttpServletRequest request, String baseURL, String cmDataSource, String dataSourceType, String catalog, String schema) {
        JSONObject result;
        block2: {
            HashMap<String, String> functionSpec = new HashMap<String, String>();
            functionSpec.put("moserFunctionType", CMD_GET_CATALOGS_SCHEMAS);
            functionSpec.put(PAR_CM_DATA_SOURCE, cmDataSource);
            functionSpec.put(PAR_DATA_SOURCE_TYPE, dataSourceType);
            functionSpec.put(PAR_CATALOG, catalog);
            functionSpec.put(PAR_SCHEMA, schema);
            result = null;
            try {
                result = (JSONObject)MoserXQESoapBridge.doMoserCommand(taskID, request, baseURL, functionSpec).get(0);
            }
            catch (MoserException e) {
                if (MoserError.MSR_MODULE_NOT_FOUND.getErrorCode().equals(e.getErrorCode())) break block2;
                throw e;
            }
        }
        return result;
    }

    public static Object getNormalizedIdentifiers(HttpServletRequest request, String baseURL, boolean isPackage, String moduleID, String idArray) {
        HashMap<String, String> functionSpec = new HashMap<String, String>();
        functionSpec.put("moserFunctionType", CMD_GETNORMALIZEDIDENTIFIERS);
        if (!isPackage) {
            functionSpec.put(PAR_MODULETYPE, "module");
        }
        functionSpec.put(PAR_MODEL_PATH, moduleID);
        functionSpec.put(PAR_IDENTIFIERS, idArray);
        return MoserXQESoapBridge.doMoserCommand(null, request, baseURL, functionSpec).get(0);
    }

    public static JSONObject expandMacros(HttpServletRequest request, List<String> expressions) {
        HashMap<String, String> functionSpec = new HashMap<String, String>();
        functionSpec.put("moserFunctionType", CMD_EXPANDMACROS);
        functionSpec.put(PAR_MACRO_EXPR, MoserXQESoapBridge.convertToJsonArrayString(expressions));
        return (JSONObject)MoserXQESoapBridge.doMoserCommand(null, request, MoserXQESoapBridge.buildBaseURL(request), functionSpec).get(0);
    }

    private static String convertToJsonArrayString(List<String> strArray) {
        StringBuilder bf = new StringBuilder();
        for (String str : strArray) {
            if (bf.length() == 0) {
                bf.append('[');
            } else {
                bf.append(',');
            }
            bf.append('\"').append(str).append('\"');
        }
        bf.append(']');
        return bf.toString();
    }

    public static String buildBaseURL(HttpServletRequest httpServletRequest) {
        String original = (String)httpServletRequest.getAttribute("X-Original-URI");
        if (original != null) {
            return original;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(httpServletRequest.getContextPath());
        buf.append(httpServletRequest.getServletPath());
        return buf.toString();
    }

    public static JSONObject getOLAPMetadata(HttpServletRequest request, String cmDatasource, String catalog, String cube, String alias, String inProviderType, String routingServerGroup, MoserConnectionSpec connSpec, List<String> ids) {
        JSONObject result;
        block6: {
            String providerType;
            HashMap<String, String> functionSpec = new HashMap<String, String>();
            functionSpec.put("moserFunctionType", CMD_GET_OLAP_METADATA);
            functionSpec.put(PAR_CM_DATA_SOURCE, cmDatasource);
            functionSpec.put(PAR_CATALOG, catalog);
            functionSpec.put(PAR_CUBE, cube);
            if (alias != null) {
                functionSpec.put(PAR_IDPREFIX, alias);
            }
            if ((providerType = inProviderType) == null) {
                providerType = "TMR";
            }
            if (connSpec != null) {
                functionSpec.put("connectionSpec", connSpec.toString());
            }
            functionSpec.put(PAR_PROVIDER_CODE, providerType);
            if (ids != null && !ids.isEmpty()) {
                functionSpec.put(PAR_ITEMIDS, MoserXQESoapBridge.convertToJsonArrayString(ids));
            }
            result = null;
            try {
                result = (JSONObject)MoserXQESoapBridge.doMoserCommand2(null, request, MoserXQESoapBridge.buildBaseURL(request), functionSpec, routingServerGroup).get(0);
            }
            catch (MoserException e) {
                if (MoserError.MSR_MODULE_NOT_FOUND.getErrorCode().equals(e.getErrorCode())) break block6;
                throw e;
            }
        }
        return result;
    }

    public static JSONObject getDataSourceExceptions(HttpServletRequest request, String modelPath, String connectionSpec, UseSpecType type, JSONObject loadOptions) {
        String sExcl;
        HashMap<String, String> functionSpec = new HashMap<String, String>();
        functionSpec.put("moserFunctionType", CMD_GETDSEXCEPTIONS);
        if (UseSpecType.PACKAGE.equals((Object)type)) {
            functionSpec.put(PAR_MODULETYPE, PAR_PACKAGE);
        } else {
            functionSpec.put(PAR_MODULETYPE, "module");
        }
        functionSpec.put(PAR_MODEL_PATH, modelPath);
        if (connectionSpec != null) {
            functionSpec.put("connectionSpec", connectionSpec);
        }
        if ((sExcl = MoserXQESoapBridge.getExcludedTables(loadOptions)) != null) {
            functionSpec.put(EXCLUDED_TABLES, sExcl);
        }
        return (JSONObject)MoserXQESoapBridge.doMoserCommand(null, request, MoserXQESoapBridge.buildBaseURL(request), functionSpec).get(0);
    }

    public static String getExcludedTables(JSONObject loadOptions) {
        if (loadOptions == null) {
            return null;
        }
        JSONObject ops = (JSONObject)loadOptions.get((Object)LOADOPTIONS);
        if (ops == null) {
            return null;
        }
        JSONArray exculdedTables = (JSONArray)ops.get((Object)EXCLUDED_TABLES);
        if (exculdedTables == null || exculdedTables.isEmpty()) {
            return null;
        }
        try {
            return exculdedTables.serialize(false);
        }
        catch (Exception ex) {
            LoggerAdapter.trace(MoserXQESoapBridge.class, ex.getLocalizedMessage(), ex);
            return null;
        }
    }
}

