/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata;

import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.exceptions.generic.GenericException;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.api.json.JSONApiError;
import com.ibm.bi.platform.moser.core.api.json.JSONApiResponse;
import com.ibm.bi.platform.moser.core.api.json.datasource.ModulesResponse;
import com.ibm.bi.platform.moser.core.api.json.datasource.SchemasResponse;
import com.ibm.bi.platform.moser.core.api.json.datasource.TablesResponse;
import com.ibm.bi.platform.moser.core.metadata.config.MetadataEngineConfig;
import com.ibm.bi.platform.moser.core.metadata.config.MetadataEngineRequest;
import com.ibm.bi.platform.moser.core.metadata.config.MetadataEngineSequence;
import com.ibm.bi.platform.moser.core.metadata.config.MetadataEngineURL;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.GenericService;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.Response;

public class MetadataEngine {
    private RequestEnvironment requestEnv;
    private MetadataEngineConfig config;

    public MetadataEngine(RequestEnvironment requestEnv, MetadataEngineConfig config) {
        this.config = config;
        this.requestEnv = requestEnv;
    }

    public SchemasResponse getSchemas(JSONObject json) {
        MetadataEngineSequence sequence = this.config.schemas();
        RESTClientResponse resp = this.executeSequence(json, sequence);
        return new SchemasResponse(resp);
    }

    public TablesResponse getTables(JSONObject json) {
        MetadataEngineSequence sequence = this.config.tables();
        RESTClientResponse resp = this.executeSequence(json, sequence);
        return new TablesResponse(resp);
    }

    public ModulesResponse getModules(JSONObject json) {
        MetadataEngineSequence sequence = this.config.modules();
        RESTClientResponse resp = this.executeSequence(json, sequence);
        return new ModulesResponse(resp);
    }

    private RESTClientResponse executeSequence(JSONObject json, MetadataEngineSequence sequence) {
        JSONArray warnings = new JSONArray();
        JSONObject payload = json;
        RESTClientResponse resp = new RESTClientResponse(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        for (int i = 0; i < sequence.size(); ++i) {
            MetadataEngineRequest request = sequence.get(i);
            resp = this.executeRequest(payload, request);
            if (i >= sequence.size() - 1) continue;
            payload = resp.getJSONObjectResponse();
            JSONApiResponse response = new JSONApiResponse(payload);
            JSONArray errors = response.getErrors();
            if (errors != null) {
                warnings.addAll((Collection)errors);
            }
            if ((errors = (JSONArray)response.getMeta("errors")) == null) continue;
            warnings.addAll((Collection)errors);
        }
        return warnings.isEmpty() ? resp : MetadataEngine.mergeWarnings(resp, warnings);
    }

    private RESTClientResponse executeRequest(JSONObject result, MetadataEngineRequest request) {
        RESTClientResponse resp = null;
        List<MetadataEngineRequest.OnError> onErrorList = request.onError();
        for (int i = 0; i <= onErrorList.size(); ++i) {
            MetadataEngineRequest.OnError onError = i >= onErrorList.size() ? MetadataEngineRequest.OnError.FAIL : onErrorList.get(i);
            resp = this.execute(request, result);
            if (request.success(resp.getResponseCode())) {
                return resp;
            }
            if (MetadataEngineRequest.OnError.CONTINUE.equals((Object)onError)) {
                return resp;
            }
            if (!MetadataEngineRequest.OnError.FAIL.equals((Object)onError)) continue;
            JSONApiResponse jsonResp = new JSONApiResponse(resp.getJSONObjectResponse());
            JSONArray errors = jsonResp.getErrors();
            if (errors == null || errors.isEmpty()) {
                throw new GenericException(resp.getResponseCode(), (JSONObject)jsonResp);
            }
            JSONApiError error = new JSONApiError((JSONObject)errors.get(0));
            JSONObject entity = (JSONObject)error.getMeta("response");
            if (entity == null) {
                entity = error.getRESTResponseEntity();
            }
            throw new GenericException(resp.getResponseCode(), entity);
        }
        throw resp == null ? new MoserException(MoserError.INTERNAL_ERROR) : new GenericException(resp.getResponseCode(), resp.getJSONObjectResponse());
    }

    private RESTClientResponse execute(MetadataEngineRequest request, JSONObject value) {
        RESTClientResponse resp;
        MetadataEngineRequest.MetadataEngineMethodType method = request.getMethod();
        switch (method) {
            case POST: {
                resp = this.post(request, value);
                break;
            }
            case PUT: {
                resp = this.put(request, value);
                break;
            }
            case DELETE: {
                resp = this.delete(request);
                break;
            }
            default: {
                resp = this.get(request);
            }
        }
        return resp;
    }

    private static RESTClientResponse mergeWarnings(RESTClientResponse resp, JSONArray warnings) {
        JSONApiResponse payload = new JSONApiResponse(resp.getJSONObjectResponse());
        JSONArray latestWarnings = (JSONArray)payload.getMeta("errors");
        if (latestWarnings == null) {
            latestWarnings = new JSONArray();
            payload.setMeta("errors", latestWarnings);
        }
        latestWarnings.addAll((Collection)warnings);
        ByteArrayInputStream is = new ByteArrayInputStream(payload.toString().getBytes(StandardCharsets.UTF_8));
        return new RESTClientResponse(resp.getResponseCode(), is);
    }

    private RESTClientResponse get(MetadataEngineRequest request) {
        GenericService service = this.requestEnv.getGenericService();
        MetadataEngineURL url = request.getURL();
        return service.get(url.toURIBuilder(this.requestEnv).toString());
    }

    private RESTClientResponse post(MetadataEngineRequest request, JSONObject value) {
        GenericService service = this.requestEnv.getGenericService();
        MetadataEngineURL url = request.getURL();
        String body = request.getBody();
        if (body != null) {
            return service.post(url.toURIBuilder(this.requestEnv).toString(), body);
        }
        return service.post(url.toURIBuilder(this.requestEnv).toString(), value);
    }

    private RESTClientResponse put(MetadataEngineRequest request, JSONObject value) {
        GenericService service = this.requestEnv.getGenericService();
        MetadataEngineURL url = request.getURL();
        String body = request.getBody();
        if (body != null) {
            return service.put(url.toURIBuilder(this.requestEnv).toString(), body);
        }
        return service.put(url.toURIBuilder(this.requestEnv).toString(), value);
    }

    private RESTClientResponse delete(MetadataEngineRequest request) {
        GenericService service = this.requestEnv.getGenericService();
        MetadataEngineURL url = request.getURL();
        return service.delete(url.toURIBuilder(this.requestEnv).toString());
    }
}

