/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata;

import com.ibm.bi.platform.moser.common.generated.metadata.BaseObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.core.metadata.util.IModuleReaderWriter;
import com.ibm.bi.platform.moser.core.metadata.util.ModuleWrapper;
import com.ibm.bi.platform.moser.core.metadata.util.ReferenceResolver;
import com.ibm.bi.platform.moser.core.metadata.util.ResolverUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ModuleContentViewer {
    public static final String RUNLOCALE = "runLocale";
    public static final String RESOLVE_REF = "resolveRef";
    public static final String TRUE = "true";
    private final ReentrantReadWriteLock moduleRWLock = new ReentrantReadWriteLock();
    private final Lock writeLock = this.moduleRWLock.writeLock();
    private final Lock readLock = this.moduleRWLock.readLock();
    private final TreeMap<String, ModuleWrapper> allModules = new TreeMap();
    private final boolean generateShortIdForExpr;
    private final IModuleReaderWriter moduleReader;
    private final Options options;
    private HashSet<ADVANCED_ACTION> advanced = new HashSet();

    public ModuleContentViewer(IModuleReaderWriter r, Options o, boolean shortIdForExpr) {
        this.moduleReader = r;
        this.options = o;
        this.generateShortIdForExpr = shortIdForExpr;
    }

    public ModuleWrapper generateMetadataResponse(String moduleFullName, boolean topModule) {
        Module moduleNew = this.moduleReader.read(moduleFullName);
        ModuleWrapper wrapper = new ModuleWrapper(this, moduleNew, topModule);
        wrapper.collectInfoWalkTree((BaseObjectType)moduleNew, null);
        if (TRUE.equals(this.options.getOptionValue(RESOLVE_REF))) {
            ReferenceResolver refResolver = new ReferenceResolver(this.generateShortIdForExpr);
            ResolverUtil.resolveReference(wrapper, refResolver);
        }
        return wrapper;
    }

    public ModuleWrapper getModuleWrapper(String moduleFullName) {
        ModuleWrapper wrapper = this.getExistModuleWrapper(moduleFullName);
        if (wrapper != null) {
            return wrapper;
        }
        this.writeLock.lock();
        try {
            wrapper = this.generateMetadataResponse(moduleFullName, false);
            this.addModuleWrapper(moduleFullName, wrapper);
        }
        finally {
            this.writeLock.unlock();
        }
        return wrapper;
    }

    protected void addModuleWrapper(String moduleFullName, ModuleWrapper wrapper) {
        ModuleWrapper v = this.allModules.get(moduleFullName);
        if (v == null) {
            this.allModules.put(moduleFullName, wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModuleWrapper getExistModuleWrapper(String moduleFullName) {
        this.readLock.lock();
        try {
            ModuleWrapper v = this.allModules.get(moduleFullName);
            if (v != null) {
                ModuleWrapper moduleWrapper = v;
                return moduleWrapper;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return null;
    }

    public Set<ADVANCED_ACTION> getAdvancedAction() {
        return this.advanced;
    }

    public void clearCaches() {
        this.allModules.clear();
    }

    public static class Options
    implements Comparable<Object> {
        private final TreeMap<String, String> loadOptions = new TreeMap();

        public Options() {
        }

        public Options(Options o) {
            this.loadOptions.putAll(o.loadOptions);
        }

        public int size() {
            return this.loadOptions.size();
        }

        public void addOption(String name, String value) {
            this.loadOptions.put(name, value);
        }

        public String getOptionValue(String name) {
            return this.loadOptions.get(name);
        }

        public void removeOption(String name) {
            this.loadOptions.remove(name);
        }

        public int hashCode() {
            return this.loadOptions.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Options)) {
                return false;
            }
            Options other = (Options)obj;
            return this.loadOptions.equals(other.loadOptions);
        }

        public String toString() {
            return this.loadOptions.toString();
        }

        @Override
        public int compareTo(Object obj) {
            int sizeOther;
            if (!(obj instanceof Options)) {
                return -1;
            }
            Options other = (Options)obj;
            int sizeThis = this.loadOptions.size();
            int c = Integer.compare(sizeThis, sizeOther = other.loadOptions.size());
            if (c != 0) {
                return c;
            }
            if (sizeThis == 0) {
                return 0;
            }
            c = Options.compareCollectionSameSize(this.loadOptions.keySet(), other.loadOptions.keySet());
            if (c != 0) {
                return c;
            }
            return Options.compareCollectionSameSize(this.loadOptions.values(), other.loadOptions.values());
        }

        private static int compareCollectionSameSize(Collection<String> arg0, Collection<String> arg1) {
            Iterator<String> otherRecords = arg1.iterator();
            for (String thisRecord : arg0) {
                int c = thisRecord.compareTo(otherRecords.next());
                if (c == 0) continue;
                return c;
            }
            return 0;
        }
    }

    public static enum ADVANCED_ACTION {
        COPY_MISSING_PROPERTY,
        COPY_REF_OBJECT_IN_MDTV;

    }
}

