/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata.config;

import com.ibm.bi.platform.moser.core.metadata.config.MetadataEngineParam;
import com.ibm.bi.platform.moser.core.rest.service.GenericService;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;

public class MetadataEngineURL
extends JSONObject {
    private static final long serialVersionUID = 3716640035913071514L;
    private static final String SCHEME = "scheme";
    private static final String HOST = "host";
    private static final String PATH = "path";
    private static final String PORT = "port";
    private static final String PARAMS = "params";

    protected MetadataEngineURL() {
    }

    protected MetadataEngineURL(JSONObject json) {
        if (json != null) {
            this.putAll((Map)json);
        }
    }

    public String getScheme() {
        return (String)this.get(SCHEME);
    }

    public String getHost() {
        return (String)this.get(HOST);
    }

    public String getPath() {
        return (String)this.get(PATH);
    }

    public int getPort() {
        Object value = this.get(PORT);
        return value instanceof Long ? ((Long)value).intValue() : -1;
    }

    public List<MetadataEngineParam> getParams() {
        JSONArray params = (JSONArray)this.get(PARAMS);
        if (params == null || params.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MetadataEngineParam> result = new ArrayList<MetadataEngineParam>();
        for (Object p : params) {
            result.add(new MetadataEngineParam((JSONObject)p));
        }
        return result;
    }

    public URIBuilder toURIBuilder(RequestEnvironment requestEnv) {
        ArrayList<String> options = new ArrayList<String>();
        String path = this.getPath();
        for (MetadataEngineParam param : this.getParams()) {
            String value = param.getValue();
            String variable = param.getVariable();
            String literal = value != null ? value : requestEnv.getStringParam(variable);
            if (literal == null) continue;
            String pattern = param.getPattern();
            if (StringUtils.isNotEmpty((CharSequence)pattern)) {
                if (!StringUtils.isNotEmpty((CharSequence)path)) continue;
                path = path.replace(pattern, literal);
                continue;
            }
            String key = param.getKey();
            if (!StringUtils.isNotEmpty((CharSequence)key)) continue;
            options.add(key);
            options.add(literal);
        }
        return GenericService.uriBuilder(this.getScheme(), this.getHost(), this.getPort(), path, options.toArray(new String[options.size()]));
    }
}

