/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata.properties;

import com.ibm.bi.platform.moser.common.generated.metadata.BaseQueryItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Calculation;
import com.ibm.bi.platform.moser.common.generated.metadata.Filter;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.NamedSet;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.SourceCategoryType;
import com.ibm.bi.platform.moser.common.utils.MoserObjectUtils;
import com.ibm.bi.platform.moser.core.metadata.properties.MetadataProperties;
import com.ibm.bi.platform.moser.core.module.util.ModuleUtil;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.Pair;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FindObjectUtil {
    private static final String DOT_OPEN_BRACKET = ".[";
    private static final String DOT_OPEN_BRACKET_REGEX = "\\.\\[";

    private FindObjectUtil() {
    }

    public static BaseQueryItemType findObjectById(Module module, String identifier) {
        String[] parts = identifier.split(DOT_OPEN_BRACKET_REGEX);
        if (parts.length < 3) {
            return null;
        }
        String qsId = parts[0] + DOT_OPEN_BRACKET + parts[1] + DOT_OPEN_BRACKET + parts[2];
        Pair<QuerySubject, MetadataProperties.IDTYPE> idPair = FindObjectUtil.findQuerySubject(qsId, module);
        QuerySubject dim = idPair.getFirst();
        if (dim != null) {
            MetadataProperties.IDTYPE type = idPair.getSecond();
            String idForExpression = dim.getIdForExpression();
            String newID = FindObjectUtil.fixID(identifier, idForExpression, type);
            SourceCategoryType sc = dim.getSourceCategory();
            if (sc == SourceCategoryType.TABLE) {
                return FindObjectUtil.findQueryItem(dim, newID);
            }
            if (sc == SourceCategoryType.DIMENSION_REGULAR) {
                boolean finish;
                boolean bl = type == MetadataProperties.IDTYPE.NO_ALIAS ? parts.length == 3 : (finish = parts.length == 4);
                if (finish) {
                    return FindObjectUtil.findHierarchy(dim, newID);
                }
                String hierId = idForExpression + DOT_OPEN_BRACKET;
                QueryItem hier = FindObjectUtil.findHierarchy(dim, hierId = hierId + (type == MetadataProperties.IDTYPE.NO_ALIAS ? parts[2] : parts[3]));
                if (hier == null) {
                    LoggerAdapter.info(FindObjectUtil.class, "Cannot find hierarchy ID = " + hierId);
                    return null;
                }
                boolean bl2 = type == MetadataProperties.IDTYPE.NO_ALIAS ? parts.length == 4 : (finish = parts.length == 5);
                if (finish) {
                    QueryItem item = FindObjectUtil.findObject(hier, newID);
                    if (item != null) {
                        return item;
                    }
                    return FindObjectUtil.findNamedSet(hier, newID);
                }
                if (hier.getSourceCategory() == SourceCategoryType.HIERARCHY_PARENT_CHILD) {
                    LoggerAdapter.info(FindObjectUtil.class, "Cannot find item for parent child hierarchy ID = " + hierId);
                    return null;
                }
                String levelId = hierId + DOT_OPEN_BRACKET;
                QueryItem level = FindObjectUtil.findObject(hier, levelId = levelId + (type == MetadataProperties.IDTYPE.NO_ALIAS ? parts[3] : parts[4]));
                if (level == null) {
                    LoggerAdapter.info(FindObjectUtil.class, "Cannot find level ID = " + levelId);
                    return null;
                }
                QueryItem item = FindObjectUtil.findObject(level, newID);
                if (item != null) {
                    return item;
                }
                return FindObjectUtil.findNamedSet(hier, newID);
            }
            if (sc == SourceCategoryType.DIMENSION_MEASURE) {
                return FindObjectUtil.findMeasure(dim, newID);
            }
            String lastPart = parts[parts.length - 1];
            String qiID = lastPart.substring(0, lastPart.length() - 1);
            return FindObjectUtil.findQueryItem(dim, qiID);
        }
        if (parts.length == 3) {
            String alias;
            if (identifier.startsWith("[") && (alias = StringUtils.substringBetween((String)identifier, (String)"[", (String)"].")) != null) {
                for (Module.UseSpec useSpec : module.getUseSpec()) {
                    if (!alias.equals(useSpec.getIdentifier())) continue;
                    String newID = alias + "." + StringUtils.substringAfter((String)identifier, (String)"].");
                    return FindObjectUtil.findModuleNamedSetOrCalculation(module, newID);
                }
            }
            return FindObjectUtil.findModuleNamedSetOrCalculation(module, identifier);
        }
        return null;
    }

    public static Pair<QuerySubject, MetadataProperties.IDTYPE> findQuerySubject(String id, Module module) {
        MetadataProperties.IDTYPE type = MetadataProperties.IDTYPE.ALIAS;
        QuerySubject qs = null;
        if (!id.startsWith("[")) {
            qs = ModuleUtil.getQuerySubject(id, module);
        } else {
            String alias = StringUtils.substringBetween((String)id, (String)"[", (String)"].");
            if (alias != null) {
                for (Module.UseSpec useSpec : module.getUseSpec()) {
                    if (!alias.equals(useSpec.getIdentifier())) continue;
                    String newID = alias + "." + StringUtils.substringAfter((String)id, (String)"].");
                    qs = ModuleUtil.getQuerySubject(newID, module);
                    type = MetadataProperties.IDTYPE.ALIAS_BRACKETS;
                    break;
                }
            }
            if (qs == null) {
                String[] parts = id.split("\\.");
                String newID = parts[0] + "." + parts[1];
                for (Module.UseSpec useSpec : module.getUseSpec()) {
                    String fullID = useSpec.getIdentifier() + "." + newID;
                    qs = ModuleUtil.getQuerySubject(fullID, module);
                    type = MetadataProperties.IDTYPE.NO_ALIAS;
                    if (qs == null) continue;
                    break;
                }
                if (qs == null && parts.length >= 3) {
                    String fullID = parts[2].substring(1, parts[2].length() - 1);
                    qs = ModuleUtil.getQuerySubject(fullID, module);
                    type = MetadataProperties.IDTYPE.CONTAINER;
                }
            }
            if (qs == null) {
                LoggerAdapter.info(FindObjectUtil.class, "Cannot find query subject for: " + id);
            }
        }
        return new Pair<QuerySubject, MetadataProperties.IDTYPE>(qs, type);
    }

    public static BaseQueryItemType findQueryItem(QuerySubject parent, String id) {
        for (QueryItem qi : MoserObjectUtils.getQueryItems((QuerySubject)parent)) {
            String qiID = qi.getIdForExpression();
            if (qiID == null || qiID.isEmpty()) {
                qiID = qi.getIdentifier();
            }
            if (id.equals(qiID)) {
                return qi;
            }
            String[] parts = id.split("\\.");
            String identifier = parts[parts.length - 1];
            if (!identifier.equals(qiID)) continue;
            return qi;
        }
        LoggerAdapter.info(FindObjectUtil.class, "Cannot find queryItem ID = " + id);
        return null;
    }

    public static Filter findQuerySubjectFilter(QuerySubject parent, String id) {
        for (Filter qi : MoserObjectUtils.getFilters((QuerySubject)parent)) {
            String qiID = qi.getIdForExpression();
            if (qiID == null || qiID.isEmpty()) {
                qiID = qi.getIdentifier();
            }
            if (!id.equals(qiID)) continue;
            return qi;
        }
        LoggerAdapter.info(FindObjectUtil.class, "Cannot find filter ID = " + id);
        return null;
    }

    private static BaseQueryItemType findMeasure(QuerySubject parent, String id) {
        return FindObjectUtil.getMeasure(MoserObjectUtils.getMeasures((QuerySubject)parent), id);
    }

    private static QueryItem getMeasure(List<QueryItem> items, String id) {
        for (QueryItem qitem : items) {
            String idForExpression = qitem.getIdForExpression();
            if (idForExpression != null && id.equals(idForExpression)) {
                return qitem;
            }
            String[] parts = id.split(DOT_OPEN_BRACKET_REGEX);
            String identifier = "[" + parts[parts.length - 1];
            if (!identifier.equals(qitem.getIdentifier())) continue;
            return qitem;
        }
        LoggerAdapter.info(FindObjectUtil.class, "Cannot find measure ID = " + id);
        return null;
    }

    private static BaseQueryItemType findNamedSet(QueryItem parent, String id) {
        for (ItemType item : parent.getItem()) {
            NamedSet qi = item.getNamedSet();
            if (qi == null || !id.equals(qi.getIdForExpression())) continue;
            return qi;
        }
        LoggerAdapter.info(FindObjectUtil.class, "Cannot find namedSet ID = " + id);
        return null;
    }

    private static BaseQueryItemType findModuleNamedSetOrCalculation(Module module, String id) {
        BaseQueryItemType obj = module.getNamedSet().stream().filter(n -> id.equals(n.getIdForExpression())).findFirst().orElse(null);
        if (obj == null) {
            obj = module.getCalculation().stream().filter(n -> id.equals(n.getIdForExpression())).findFirst().orElse(null);
        }
        return obj;
    }

    private static String fixID(String id, String parentId, MetadataProperties.IDTYPE type) {
        String newID = id;
        String alias = StringUtils.substringBetween((String)parentId, (String)"", (String)DOT_OPEN_BRACKET);
        switch (type) {
            case ALIAS_BRACKETS: {
                newID = alias + "." + StringUtils.substringAfter((String)newID, (String)"].");
                break;
            }
            case NO_ALIAS: {
                newID = alias + "." + newID;
                break;
            }
        }
        return newID;
    }

    private static QueryItem findHierarchy(QuerySubject qs, String id) {
        List items = qs.getItem();
        for (ItemType item : items) {
            QueryItem qitem = item.getQueryItem();
            if (qitem != null && id.equals(qitem.getIdForExpression())) {
                return qitem;
            }
            ItemType.Folder folder = item.getFolder();
            if (folder == null) continue;
            List subItems = folder.getItem();
            for (ItemType subItem : subItems) {
                QueryItem qitem2 = subItem.getQueryItem();
                if (qitem2 == null || !id.equals(qitem2.getIdForExpression())) continue;
                return qitem2;
            }
        }
        return null;
    }

    private static QueryItem findObject(QueryItem parent, String id) {
        for (ItemType item : parent.getItem()) {
            QueryItem qi = item.getQueryItem();
            if (qi == null || !id.equals(qi.getIdForExpression())) continue;
            return qi;
        }
        return null;
    }

    public static String fixIDForFilterCalc(Module module, String itemId) {
        String[] parts = itemId.split(DOT_OPEN_BRACKET_REGEX);
        if (parts.length == 3) {
            String alias = StringUtils.substringBetween((String)itemId, (String)"[", (String)"].");
            if (alias != null) {
                for (Module.UseSpec useSpec : module.getUseSpec()) {
                    if (!alias.equals(useSpec.getIdentifier())) continue;
                    return alias + "." + StringUtils.substringAfter((String)itemId, (String)"].");
                }
            }
            return StringUtils.substringBetween((String)parts[2], (String)"", (String)"]");
        }
        if (parts.length == 4) {
            String qsId = StringUtils.substringBetween((String)parts[2], (String)"", (String)"]");
            String objectId = StringUtils.substringBetween((String)parts[3], (String)"", (String)"]");
            return qsId + "." + objectId;
        }
        return null;
    }

    public static Filter findFilter(Module module, String itemId) {
        Filter filter = module.getFilter().stream().filter(n -> itemId.equals(n.getIdForExpression())).findFirst().orElse(null);
        if (filter == null) {
            filter = module.getFilter().stream().filter(n -> itemId.equals(n.getIdentifier())).findFirst().orElse(null);
        }
        return filter;
    }

    public static Calculation findCalculation(Module module, String itemId) {
        Calculation calc = module.getCalculation().stream().filter(n -> itemId.equals(n.getIdForExpression())).findFirst().orElse(null);
        if (calc == null) {
            calc = module.getCalculation().stream().filter(n -> itemId.equals(n.getIdentifier())).findFirst().orElse(null);
        }
        return calc;
    }
}

