/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata.properties;

import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.BaseQueryItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Calculation;
import com.ibm.bi.platform.moser.common.generated.metadata.DataSource;
import com.ibm.bi.platform.moser.common.generated.metadata.Filter;
import com.ibm.bi.platform.moser.common.generated.metadata.HighLevelDataType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.NamedSet;
import com.ibm.bi.platform.moser.common.generated.metadata.PromptInfoType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.SourceCategoryType;
import com.ibm.bi.platform.moser.common.utils.MoserCommonUtils;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.metadata.properties.FindObjectUtil;
import com.ibm.bi.platform.moser.core.module.util.ModuleUtil;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.ModuleIdentifiersConverter;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MetadataProperties {
    public static final String MA_ARROW = "]->:[";
    public static final String MA_DMR_ARROW = "]->[";
    private static final String NAME = "name";
    private static final String DATATYPE = "datatype";
    private static final String ERROR = "error";
    private static final String CODE = "code";
    private static final String MESSAGE = "message";
    private static final String CALCULATION = "calculation";
    private static final String FILTER = "filter";
    private static final String QUERYITEM = "queryItem";

    public static Object getCubeProperties(Module module, String dimensionId) {
        QuerySubject dim = FindObjectUtil.findQuerySubject(dimensionId, module).getFirst();
        if (dim == null) {
            throw new MoserException(MoserError.MSR_INVALID_ID);
        }
        String idForExpression = dim.getIdForExpression();
        String alias = StringUtils.substringBetween((String)idForExpression, (String)"", (String)".[");
        Document doc = MetadataProperties.createXML();
        List dataSources = module.getDataSource();
        for (DataSource ds : dataSources) {
            String dsAlias = StringUtils.substringBetween((String)ds.getName(), (String)"", (String)".");
            if (!alias.equals(dsAlias)) continue;
            Element elmDim = doc.createElement("dimension");
            elmDim.setAttribute(NAME, dim.getLabel());
            elmDim.setAttribute("_path", dim.getIdentifier());
            elmDim.setAttribute("_ref", dim.getIdentifier());
            elmDim.setAttribute("sources", ds.getName());
            doc.getDocumentElement().appendChild(elmDim);
            Element elmDatasource = doc.createElement("dataSource");
            elmDatasource.setAttribute(NAME, ds.getName());
            elmDatasource.setAttribute("cube", ds.getCube());
            elmDatasource.setAttribute("cubeSchemaUpdatedOn", ds.getCubeSchemaUpdatedOn());
            elmDatasource.setAttribute("cubeDefaultMeasure", ds.getCubeDefaultMeasure());
            elmDatasource.setAttribute("cubeDescription", ds.getCubeDescription());
            elmDatasource.setAttribute("cubeIsOptimized", ds.getCubeIsOptimized());
            elmDatasource.setAttribute("cubeDataUpdatedOn", ds.getCubeDataUpdatedOn());
            elmDatasource.setAttribute("cubeCurrentPeriod", ds.getCubeCurrentPeriod());
            elmDatasource.setAttribute("cubeCreatedOn", ds.getCubeCreatedOn());
            doc.getDocumentElement().appendChild(elmDatasource);
            break;
        }
        return doc;
    }

    public static Object getItemProperties(Module module, String itemId) {
        if (MetadataProperties.isMUN(itemId)) {
            throw new MoserException(MoserError.MSR_INVALID_ID);
        }
        Document doc = MetadataProperties.createXML();
        BaseQueryItemType item = FindObjectUtil.findObjectById(module, itemId);
        Element elem = null;
        if (item != null) {
            if (item instanceof NamedSet) {
                elem = doc.createElement(CALCULATION);
                elem.setAttribute(NAME, item.getLabel());
                elem.setAttribute("calcType", "namedSet");
            } else if (item instanceof Calculation) {
                elem = doc.createElement(CALCULATION);
                elem.setAttribute(NAME, item.getLabel());
                elem.setAttribute(DATATYPE, MetadataProperties.getHighlevelDatatype(item));
            } else if (item instanceof QueryItem) {
                SourceCategoryType cat = item.getSourceCategory();
                if (cat == SourceCategoryType.LEVEL) {
                    elem = doc.createElement("level");
                } else if (cat == SourceCategoryType.HIERARCHY_LEVEL || cat == SourceCategoryType.HIERARCHY_PARENT_CHILD) {
                    elem = doc.createElement("hierarchy");
                } else {
                    elem = cat == SourceCategoryType.MEASURE ? doc.createElement("measure") : doc.createElement(QUERYITEM);
                    elem.setAttribute(DATATYPE, MetadataProperties.getHighlevelDatatype(item));
                    PromptInfoType promptInfo = item.getPromptInfo();
                    if (promptInfo != null) {
                        MetadataProperties.addPromptInfo(elem, promptInfo);
                    }
                }
                elem.setAttribute(NAME, item.getLabel());
            }
        } else {
            elem = MetadataProperties.checkMore(module, itemId, doc);
        }
        if (elem == null) {
            throw new MoserException(MoserError.MSR_INVALID_ID);
        }
        doc.getDocumentElement().appendChild(elem);
        return doc;
    }

    public static Object getMemberProperties(JSONObject jobj) {
        LoggerAdapter.info(MetadataProperties.class, "Json response for member ==>  " + jobj);
        Document doc = MetadataProperties.createXML();
        JSONArray jDataItems = (JSONArray)jobj.get((Object)"dataItems");
        if (jDataItems != null) {
            JSONObject jItems = (JSONObject)jDataItems.get(0);
            JSONArray jItemArray = (JSONArray)jItems.get((Object)"items");
            for (Object obj : jItemArray) {
                Element elem = doc.createElement("member");
                JSONObject jt = (JSONObject)obj;
                JSONArray jtArray = (JSONArray)jt.get((Object)"t");
                JSONObject ji = (JSONObject)jtArray.get(0);
                JSONObject jparent = (JSONObject)ji.get((Object)"p");
                if (jparent != null) {
                    elem.setAttribute("parentUniqueName", (String)jparent.get((Object)"u"));
                }
                elem.setAttribute("dimensionUniqueName", (String)ji.get((Object)"du"));
                elem.setAttribute("levelNumber", String.valueOf(ji.get((Object)"ln")));
                elem.setAttribute("levelLabel", (String)ji.get((Object)"ll"));
                elem.setAttribute("levelUniqueName", (String)ji.get((Object)"lu"));
                elem.setAttribute("memberCaption", (String)ji.get((Object)"d"));
                elem.setAttribute("memberUniqueName", (String)ji.get((Object)"u"));
                elem.setAttribute("hierarchyUniqueName", (String)ji.get((Object)"hu"));
                elem.setAttribute("parentLevel", String.valueOf(ji.get((Object)"pn")));
                doc.getDocumentElement().appendChild(elem);
            }
        } else {
            JSONArray jErrors = (JSONArray)jobj.get((Object)"errors");
            if (jErrors != null) {
                JSONObject jError = (JSONObject)jErrors.get(0);
                String message = (String)jError.get((Object)MESSAGE);
                String code = (String)jError.get((Object)CODE);
                Element elem = doc.createElement(ERROR);
                elem.setAttribute(CODE, code);
                elem.setAttribute(MESSAGE, message);
                doc.getDocumentElement().appendChild(elem);
            }
        }
        return doc;
    }

    public static boolean isMUN(String id) {
        return null != id && (id.contains(MA_ARROW) || id.contains(MA_DMR_ARROW));
    }

    private static Document createXML() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setExpandEntityReferences(false);
        DocumentBuilder builder = null;
        try {
            builder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new MoserException((Throwable)e);
        }
        Document doc = builder.newDocument();
        Element element = doc.createElement("ResponseRoot");
        doc.appendChild(element);
        return doc;
    }

    private static Element checkMore(Module module, String objId, Document doc) {
        QuerySubject qs;
        String itemId = objId;
        if (ModuleIdentifiersConverter.matchBracket(objId) && (itemId = FindObjectUtil.fixIDForFilterCalc(module, itemId)) == null) {
            throw new MoserException(MoserError.MSR_INVALID_ID);
        }
        Filter filter = FindObjectUtil.findFilter(module, itemId);
        if (filter != null) {
            return MetadataProperties.addFilterElement(doc, filter);
        }
        Calculation calc = FindObjectUtil.findCalculation(module, itemId);
        if (calc != null) {
            return MetadataProperties.addElement(doc, (BaseQueryItemType)calc, CALCULATION);
        }
        String[] parts = itemId.split("\\.");
        String qsId = null;
        if (parts.length == 4) {
            qsId = parts[2];
        } else if (parts.length == 2) {
            qsId = parts[0];
        }
        if (qsId != null && (qs = ModuleUtil.getQuerySubject(qsId, module)) != null) {
            Filter qsfilter = FindObjectUtil.findQuerySubjectFilter(qs, itemId);
            if (qsfilter != null) {
                return MetadataProperties.addFilterElement(doc, qsfilter);
            }
            BaseQueryItemType qItem = FindObjectUtil.findQueryItem(qs, itemId);
            if (qItem != null) {
                return MetadataProperties.addElement(doc, qItem, QUERYITEM);
            }
        }
        return null;
    }

    private static void addPromptInfo(Element elem, PromptInfoType promptInfo) {
        String promptUseItemRef;
        String promptDisplayItemRef;
        String promptFilterItemRef;
        String promptCascadeOnRef;
        String promptType = promptInfo.getPromptType().value();
        if (promptType != null && !promptType.isEmpty()) {
            elem.setAttribute("promptType", promptType);
        }
        if ((promptCascadeOnRef = promptInfo.getPromptCascadeOnRef()) != null && !promptCascadeOnRef.isEmpty()) {
            elem.setAttribute("promptCascadeOnRef", promptCascadeOnRef);
        }
        if ((promptFilterItemRef = promptInfo.getPromptFilterItemRef()) != null && !promptFilterItemRef.isEmpty()) {
            elem.setAttribute("promptFilterItemRef", promptFilterItemRef);
        }
        if ((promptDisplayItemRef = promptInfo.getPromptDisplayItemRef()) != null && !promptDisplayItemRef.isEmpty()) {
            elem.setAttribute("promptDisplayItemRef", promptDisplayItemRef);
        }
        if ((promptUseItemRef = promptInfo.getPromptUseItemRef()) != null && !promptUseItemRef.isEmpty()) {
            elem.setAttribute("promptUseItemRef", promptUseItemRef);
        }
    }

    private static String getHighlevelDatatype(BaseQueryItemType item) {
        HighLevelDataType hldt = item.getHighlevelDatatype();
        if (hldt == null) {
            hldt = MoserCommonUtils.generateHighlevelDatatype((String)item.getDatatype());
        }
        return hldt.value();
    }

    private static Element addFilterElement(Document doc, Filter filter) {
        Element elem = doc.createElement(FILTER);
        elem.setAttribute(NAME, filter.getLabel());
        return elem;
    }

    private static Element addElement(Document doc, BaseQueryItemType item, String type) {
        Element elem = doc.createElement(type);
        elem.setAttribute(NAME, item.getLabel());
        elem.setAttribute(DATATYPE, MetadataProperties.getHighlevelDatatype(item));
        return elem;
    }

    static enum IDTYPE {
        ALIAS,
        ALIAS_BRACKETS,
        NO_ALIAS,
        CONTAINER;

    }
}

