/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata.provider.jdbc;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.ibm.bi.platform.moser.common.generated.metadata.BaseObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.Column;
import com.ibm.bi.platform.moser.common.generated.metadata.DataSource;
import com.ibm.bi.platform.moser.common.generated.metadata.DbFunction;
import com.ibm.bi.platform.moser.common.generated.metadata.ForeignKey;
import com.ibm.bi.platform.moser.common.generated.metadata.Index;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.PrimaryKey;
import com.ibm.bi.platform.moser.common.generated.metadata.StoredProcedure;
import com.ibm.bi.platform.moser.common.generated.metadata.Table;
import com.ibm.bi.platform.moser.common.generated.metadata.TableItemType;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.DeserializerUtil;
import com.ibm.bi.platform.moser.core.module.util.ModuleUtil;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.cognos.jmd.model.ObjectType;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class BaseObjectTypeDeserializer
extends JsonDeserializer<BaseObjectType> {
    private static final int DECIMAL_MIN_PRECISION = 1;
    private static final int DECIMAL_MAX_PRECISION = 256;
    private static final int DECIMAL_MIN_SCALE = -256;
    private static final String NAME = "NAME";
    private static final String SYNONYM = "SYNONYM";
    private static final String TABLE_TYPE = "TABLE_TYPE";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private Table mTable;
    private DataSource mDataSource;

    private String buildContext() {
        String context = "";
        if (this.mTable != null) {
            context = " table '" + this.mTable.getName() + "'";
        }
        if (this.mDataSource != null) {
            if (this.mDataSource.getSchema() != null && !this.mDataSource.getSchema().isEmpty()) {
                context = context + " schema '" + this.mDataSource.getSchema() + "'";
            }
            if (this.mDataSource.getCatalog() != null && !this.mDataSource.getCatalog().isEmpty()) {
                context = context + " catalog '" + this.mDataSource.getCatalog() + "'";
            }
        }
        return context;
    }

    public BaseObjectType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = DeserializerUtil.skipStartToken(jp);
        String objectType = DeserializerUtil.extractObjectType(jp);
        ArrayNode attributeArray = DeserializerUtil.extractAttributeArray(jp, mapper);
        Table result = null;
        if (objectType.equals(ObjectType.SCHEMA.name())) {
            String schema = BaseObjectTypeDeserializer.getMetadataObjectAttribute(attributeArray, NAME);
            DataSource ds = new DataSource();
            this.setDataSourceProperties(ds, schema, jp, mapper);
            result = new Module();
            ((Module)result).setVersion("11.1");
            ((Module)result).getDataSource().add(ds);
        } else if (objectType.equals(ObjectType.TABLE.name())) {
            result = new Table();
            this.setTableProperties(result, attributeArray, jp, mapper);
        } else if (objectType.equals(ObjectType.SYNONYM.name()) && SYNONYM.equals(BaseObjectTypeDeserializer.getMetadataObjectAttribute(attributeArray, TABLE_TYPE))) {
            result = new Table();
            this.setTableProperties(result, attributeArray, jp, mapper);
        } else if (objectType.equals(ObjectType.COLUMN.name()) || objectType.equals(ObjectType.SYNONYM_COLUMN.name())) {
            result = new Column();
            this.setColumnProperties((Column)result, attributeArray);
            jp.nextToken();
        } else if (objectType.equals(ObjectType.INDEX.name())) {
            result = new Index();
            BaseObjectTypeDeserializer.setIndexProperties((Index)result, attributeArray, jp, mapper);
        } else if (objectType.equals(ObjectType.PRIMARY_KEY.name())) {
            result = new PrimaryKey();
            BaseObjectTypeDeserializer.setPrimaryKeyProperties((PrimaryKey)result, attributeArray, jp, mapper);
        } else if (objectType.equals(ObjectType.IMPORTED_KEY.name())) {
            result = new ForeignKey();
            BaseObjectTypeDeserializer.setForeignKeyProperties((ForeignKey)result, attributeArray, jp, mapper);
        } else if (objectType.equals(ObjectType.PROCEDURE.name())) {
            result = new StoredProcedure();
        } else if (objectType.equals(ObjectType.FUNCTION.name())) {
            result = new DbFunction();
        }
        if (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            throw new Error();
        }
        return result;
    }

    private static String getMetadataObjectAttribute(ArrayNode attributeArray, String attributeName) {
        for (JsonNode a : attributeArray) {
            if (!attributeName.equals(a.get(TYPE).asText())) continue;
            JsonNode value = a.get(VALUE);
            if (NullNode.getInstance().equals((Object)value)) {
                return null;
            }
            return value.asText();
        }
        return "";
    }

    private static <T> List<T> getTypedChildren(JsonParser jp, ObjectMapper mapper, TypeReference<List<T>> typeRef) throws IOException {
        List childrenObj = Collections.emptyList();
        if (jp.nextToken() == JsonToken.FIELD_NAME) {
            String fieldName = jp.getCurrentName();
            if ("child".equals(fieldName)) {
                jp.nextToken();
                childrenObj = (List)mapper.readValue(jp, typeRef);
            }
            jp.nextToken();
        }
        return childrenObj;
    }

    private void setDataSourceProperties(DataSource dataSource, String schema, JsonParser jp, ObjectMapper mapper) throws IOException {
        this.mDataSource = dataSource;
        dataSource.setSchema(schema);
        List<BaseObjectType> children = BaseObjectTypeDeserializer.getTypedChildren(jp, mapper, new TypeReference<List<BaseObjectType>>(){});
        for (BaseObjectType obj : children) {
            if (obj instanceof Table) {
                dataSource.getTable().add((Table)obj);
                continue;
            }
            if (obj instanceof StoredProcedure) {
                dataSource.getStoredProcedure().add((StoredProcedure)obj);
                continue;
            }
            if (!(obj instanceof DbFunction)) continue;
            dataSource.getDbFunction().add((DbFunction)obj);
        }
        this.mDataSource = null;
    }

    private void setTableProperties(Table table, ArrayNode attributeArray, JsonParser jp, ObjectMapper mapper) throws IOException {
        this.mTable = table;
        for (JsonNode a : attributeArray) {
            String type = a.get(TYPE).asText();
            String value = a.get(VALUE).asText();
            if (NAME.equals(type)) {
                table.setName(value);
                continue;
            }
            if ("CARDINALITY".equals(type)) {
                table.setNumberOfRows(Long.valueOf(value));
                continue;
            }
            if (!"DESCRIPTION".equals(type)) continue;
            table.setDescription(value);
        }
        List<BaseObjectType> children = BaseObjectTypeDeserializer.getTypedChildren(jp, mapper, new TypeReference<List<BaseObjectType>>(){});
        for (BaseObjectType obj : children) {
            if (obj instanceof Column) {
                TableItemType tableItemType = new TableItemType();
                tableItemType.setColumn((Column)obj);
                table.getTableItem().add(tableItemType);
                continue;
            }
            if (obj instanceof Index) {
                table.getIndex().add((Index)obj);
                continue;
            }
            if (obj instanceof PrimaryKey) {
                table.getPrimaryKey().add((PrimaryKey)obj);
                continue;
            }
            if (!(obj instanceof ForeignKey)) continue;
            table.getForeignKey().add((ForeignKey)obj);
        }
        this.mTable = null;
    }

    private void setColumnProperties(Column column, ArrayNode attributeArray) throws IOException {
        String dt = null;
        Integer precision = null;
        Integer scale = null;
        for (JsonNode a : attributeArray) {
            String type = a.get(TYPE).asText();
            String value = a.get(VALUE).asText();
            if (NAME.equals(type)) {
                column.setName(value);
                continue;
            }
            if ("DATA_TYPE".equals(type)) {
                dt = value;
                continue;
            }
            if ("VENDOR_TYPE".equals(type)) {
                column.setVendorType(value);
                continue;
            }
            if ("NULLABLE".equals(type)) {
                column.setNullable(Boolean.valueOf("yes".equalsIgnoreCase(value)));
                continue;
            }
            if ("PRECISION".equals(type)) {
                precision = Integer.parseInt(value);
                continue;
            }
            if (!"SCALE".equals(type)) continue;
            scale = Integer.parseInt(value);
        }
        if (dt != null) {
            switch (dt) {
                case "CHAR": 
                case "LONGNVARCHAR": 
                case "LONGVARBINARY": 
                case "LONGVARCHAR": 
                case "NCHAR": 
                case "NVARCHAR": 
                case "VARBINARY": 
                case "VARCHAR": {
                    if (precision == null) break;
                    dt = dt + "(" + precision + ")";
                    break;
                }
                case "DECIMAL": 
                case "NUMERIC": {
                    int iScale;
                    if (precision == null) break;
                    int iPrecision = precision;
                    int n = iScale = scale == null ? 0 : scale;
                    if (iPrecision < 1 || iPrecision > 256 || iScale < -256 || iScale > iPrecision) {
                        String newDt = "DOUBLE";
                        this.logDatatypeChange(column, dt, newDt);
                        dt = newDt;
                        break;
                    }
                    if (scale == null) {
                        dt = dt + "(" + iPrecision + ")";
                        break;
                    }
                    dt = dt + "(" + iPrecision + "," + iScale + ")";
                    break;
                }
                case "TINYINT": {
                    String newDt = "SMALLINT";
                    this.logDatatypeChange(column, dt, newDt);
                    dt = newDt;
                    break;
                }
            }
            if (scale != null && scale != 0 && ("BIGINT".equals(dt) || "INTEGER".equals(dt) || "SMALLINT".equals(dt))) {
                int iPrecision = "BIGINT".equals(dt) ? 20 : ("INTEGER".equals(dt) ? 10 : 5);
                String newDt = "DECIMAL(" + iPrecision + "," + scale + ")";
                this.logDatatypeChange(column, dt, newDt);
                dt = newDt;
            }
            column.setDatatype(dt);
        }
    }

    private void logDatatypeChange(Column column, String oldDatatype, String newDatatype) {
        String logmsg = "Convert JDBC type '" + oldDatatype + "' to '" + newDatatype + "' (for column '" + column.getName() + "'" + this.buildContext() + ")";
        LoggerAdapter.info(BaseObjectTypeDeserializer.class, logmsg);
    }

    private static void setIndexProperties(Index index, ArrayNode attributeArray, JsonParser jp, ObjectMapper mapper) throws IOException {
        for (JsonNode a : attributeArray) {
            String type = a.get(TYPE).asText();
            String value = a.get(VALUE).asText();
            if (NAME.equals(type)) {
                ModuleUtil.setIdentifier((BaseObjectType)index, value);
                continue;
            }
            if (!"UNIQUE".equals(type)) continue;
            index.setIsUnique(Boolean.valueOf("true".equalsIgnoreCase(value)));
        }
        List<Index.IndexedColumn> indexedColumns = BaseObjectTypeDeserializer.getTypedChildren(jp, mapper, new TypeReference<List<Index.IndexedColumn>>(){});
        for (Index.IndexedColumn column : indexedColumns) {
            index.getIndexedColumn().add(column);
        }
    }

    private static void setPrimaryKeyProperties(PrimaryKey pk, ArrayNode attributeArray, JsonParser jp, ObjectMapper mapper) throws IOException {
        BaseObjectTypeDeserializer.setIdentifier((BaseObjectType)pk, attributeArray);
        List<String> primaryKeyColumns = BaseObjectTypeDeserializer.getTypedChildren(jp, mapper, new TypeReference<List<String>>(){});
        for (String column : primaryKeyColumns) {
            pk.getKeyedColumn().add(column);
        }
    }

    private static void setIdentifier(BaseObjectType pk, ArrayNode attributeArray) {
        for (JsonNode a : attributeArray) {
            String type = a.get(TYPE).asText();
            String value = a.get(VALUE).asText();
            if (!NAME.equals(type)) continue;
            ModuleUtil.setIdentifier(pk, value);
        }
    }

    private static void setForeignKeyProperties(ForeignKey fk, ArrayNode attributeArray, JsonParser jp, ObjectMapper mapper) throws IOException {
        BaseObjectTypeDeserializer.setIdentifier((BaseObjectType)fk, attributeArray);
        List<ForeignKey.FkColumn> fkColumns = BaseObjectTypeDeserializer.getTypedChildren(jp, mapper, new TypeReference<List<ForeignKey.FkColumn>>(){});
        for (ForeignKey.FkColumn column : fkColumns) {
            fk.getFkColumn().add(column);
        }
    }
}

