/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata.provider.jdbc;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.ibm.bi.platform.moser.common.generated.metadata.ForeignKey;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.DeserializerUtil;
import com.ibm.cognos.jmd.model.ObjectType;
import java.io.IOException;

public class FkColumnDeserializer
extends JsonDeserializer<ForeignKey.FkColumn> {
    private static final String NAME = "NAME";
    private static final String TYPE = "type";
    private static final String VALUE = "value";

    public ForeignKey.FkColumn deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = DeserializerUtil.skipStartToken(jp);
        String objectType = DeserializerUtil.extractObjectType(jp);
        ArrayNode attributeArray = DeserializerUtil.extractAttributeArray(jp, mapper);
        if (jp.nextToken() != JsonToken.END_OBJECT || !objectType.equals(ObjectType.IMPORTED_KEY_COLUMN.name())) {
            throw new Error();
        }
        ForeignKey.FkColumn result = new ForeignKey.FkColumn();
        for (JsonNode a : attributeArray) {
            String type = a.get(TYPE).asText();
            String value = a.get(VALUE).asText();
            if (NAME.equals(type)) {
                result.setColumnName(value);
                continue;
            }
            if (type.equals(ObjectType.CATALOG.name())) {
                result.setPkCatalog(value);
                continue;
            }
            if (type.equals(ObjectType.SCHEMA.name())) {
                result.setPkSchema(value);
                continue;
            }
            if (type.equals(ObjectType.TABLE.name())) {
                result.setPkTable(value);
                continue;
            }
            if (!type.equals(ObjectType.COLUMN.name())) continue;
            result.setPkColumn(value);
        }
        return result;
    }
}

