/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata.provider.jdbc;

import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class JDBCTraceHandler
extends Handler {
    private Formatter f;
    private Class<?> c;

    public JDBCTraceHandler(Object o) {
        this.c = o instanceof Class ? (Class<?>)o : o.getClass();
        this.f = new SimpleFormatter();
    }

    @Override
    public void publish(LogRecord record) {
        String msg = null;
        try {
            msg = this.f.format(record);
        }
        catch (Exception e) {
            LoggerAdapter.trace(this.c, e.getLocalizedMessage(), e);
        }
        if (msg != null && !msg.isEmpty()) {
            LoggerAdapter.debug(this.c, msg);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public static JDBCTraceHandler createTracehandler(Object obj) {
        if (LoggerAdapter.isTraceEnabled(obj)) {
            return new JDBCTraceHandler(obj);
        }
        return null;
    }
}

