/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata.provider.jdbc;

import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.JDBCTraceHandler;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.MoserApiTokenJMDConnection;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.MoserCommandBlockExecutor;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.MoserJMDConnection;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.MoserOIDCJMDConnection;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.MoserSSOIntegratedSecurityConnection;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.kerberos.MoserKerberosJMDConnection;
import com.ibm.cognos.jmd.connection.IJMDConnection;
import com.ibm.cognos.jmd.connection.JDBCConnectionSpecification;
import com.ibm.cognos.jmd.exception.JMDConnectionException;
import java.util.Properties;

public class JMDConnectionFactory {
    private JMDConnectionFactory() {
    }

    public static JDBCConnectionSpecification create(String url, String driverClass, Properties properties, boolean uncertifiedAllowed, JDBCTraceHandler createTracehandler, MoserCommandBlockExecutor cmdBlockExecutor) throws JMDConnectionException {
        if (MoserKerberosJMDConnection.isKerberos(properties)) {
            return new MoserKerberosJMDConnection(url, driverClass, properties, uncertifiedAllowed, createTracehandler, cmdBlockExecutor);
        }
        if (MoserOIDCJMDConnection.isOIDC(properties)) {
            return new MoserOIDCJMDConnection(url, driverClass, properties, uncertifiedAllowed, createTracehandler, cmdBlockExecutor);
        }
        if (MoserSSOIntegratedSecurityConnection.isIntegratedSecurity(properties)) {
            return new MoserSSOIntegratedSecurityConnection(url, driverClass, properties, uncertifiedAllowed, createTracehandler, cmdBlockExecutor);
        }
        if (MoserApiTokenJMDConnection.isApiTokenAuthentication(properties)) {
            return new MoserApiTokenJMDConnection(url, driverClass, properties, uncertifiedAllowed, createTracehandler, cmdBlockExecutor);
        }
        return new MoserJMDConnection(url, driverClass, properties, uncertifiedAllowed, createTracehandler, cmdBlockExecutor);
    }

    public static IJMDConnection create(String url, String driverClass, Properties properties) throws JMDConnectionException {
        return JMDConnectionFactory.create(url, driverClass, properties, false, null, null);
    }
}

