/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata.provider.jdbc;

import com.ibm.bi.platform.moser.core.cm.ApiTokenSignon;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.JDBCTraceHandler;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.MoserCommandBlockExecutor;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.MoserJMDConnection;
import com.ibm.cognos.jmd.exception.JMDConnectionException;
import java.sql.Connection;
import java.util.Properties;

public class MoserApiTokenJMDConnection
extends MoserJMDConnection {
    public static final String APITOKEN_SIGNON = "apitoken.signon";
    private static final String APITOKEN_AUTHKEY = "authKey";
    private static final String APITOKEN_SECRETKEY = "secretKey";
    private final ApiTokenSignon mApiTokenSignon;

    public MoserApiTokenJMDConnection(String url, String driverClass, Properties properties, boolean uncertifiedAllowed, JDBCTraceHandler createTracehandler, MoserCommandBlockExecutor cmdBlockExecutor) throws JMDConnectionException {
        super(url, driverClass, properties, uncertifiedAllowed, createTracehandler, cmdBlockExecutor);
        this.mApiTokenSignon = (ApiTokenSignon)properties.get(APITOKEN_SIGNON);
    }

    public static boolean isApiTokenAuthentication(Properties properties) {
        return properties.containsKey(APITOKEN_SIGNON) && ((ApiTokenSignon)properties.get(APITOKEN_SIGNON)).isDefined();
    }

    @Override
    public Connection getConnection() throws JMDConnectionException {
        if (!this.mApiTokenSignon.isDefined()) {
            return null;
        }
        if (this.connection != null) {
            return this.connection;
        }
        Properties properties = this.getProperties();
        if (this.mApiTokenSignon.getAuthKey() != null) {
            properties.put(APITOKEN_AUTHKEY, this.mApiTokenSignon.getAuthKey().decrypt());
        }
        if (this.mApiTokenSignon.getSecretKey() != null) {
            properties.put(APITOKEN_SECRETKEY, this.mApiTokenSignon.getSecretKey().decrypt());
        }
        return super.getConnection();
    }
}

