/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata.provider.jdbc;

import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.IMacroExpander;
import com.ibm.bi.platform.moser.core.provider.MetadataProviderFactory;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.cognos.jdbc.adaptor.IAdaptorConnection;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class MoserCommandBlockExecutor {
    private IMacroExpander macroExpander;
    private List<CommandBlock> openConnectionCommands = new ArrayList<CommandBlock>();
    private List<CommandBlock> openSessionCommands = new ArrayList<CommandBlock>();
    private List<CommandBlock> closeConnectionCommands = new ArrayList<CommandBlock>();
    private List<CommandBlock> closeSessionCommands = new ArrayList<CommandBlock>();
    private String connectionString;
    private static final String OPEN_SESSION_CMD = "openSessionCommands";
    private static final String OPEN_CONNECTION_CMD = "openConnectionCommands";
    private static final String CLOSE_SESSION_CMD = "closeSessionCommands";
    private static final String CLOSE_CONNECTION_CMD = "closeConnectionCommands";
    private static final String REGISTRY_NAME = "@REGISTRY_NAME=";

    public MoserCommandBlockExecutor(String connString, Properties properties, IMacroExpander macroExpander) {
        this.connectionString = connString;
        this.macroExpander = macroExpander;
        this.extractCommandBlocksFromProperties(properties);
    }

    private String getRegistryName(String inConnectionString) {
        String registryName = null;
        if (MetadataProviderFactory.isDB2(this.connectionString) && inConnectionString.contains(REGISTRY_NAME)) {
            if (!MetadataProviderFactory.isDB2TrustedContext(this.connectionString)) {
                LoggerAdapter.error(this, "TRUSTED_CONTEXT is not enabled, REGISTRY NAME can not be specified.");
                throw new MoserException(MoserError.MSR_CMD_TRUSTED, inConnectionString);
            }
            String[] tokens = inConnectionString.split(REGISTRY_NAME);
            int offset = tokens[1].indexOf("@");
            registryName = offset > 0 ? tokens[1].substring(0, offset).trim() : tokens[1];
        }
        return registryName;
    }

    private void extractCommandBlocksFromProperties(Properties properties) {
        this.openConnectionCommands = this.extractCommandBlock(OPEN_CONNECTION_CMD, properties);
        this.openSessionCommands = this.extractCommandBlock(OPEN_SESSION_CMD, properties);
        this.closeConnectionCommands = this.extractCommandBlock(CLOSE_CONNECTION_CMD, properties);
        this.closeSessionCommands = this.extractCommandBlock(CLOSE_SESSION_CMD, properties);
    }

    private List<CommandBlock> extractCommandBlock(String cmdBlockType, Properties props) {
        JSONArray jArray;
        ArrayList<CommandBlock> toReturn = new ArrayList<CommandBlock>();
        JSONObject jCmdBlock = (JSONObject)props.get(cmdBlockType);
        if (jCmdBlock == null) {
            return toReturn;
        }
        if ((jCmdBlock = (JSONObject)jCmdBlock.get((Object)"commandBlock")) == null) {
            return toReturn;
        }
        Object obj = jCmdBlock.get((Object)"commands");
        if (obj instanceof JSONArray) {
            jArray = (JSONArray)obj;
        } else {
            jArray = new JSONArray();
            jArray.add(obj);
        }
        for (Object j : jArray) {
            CommandBlock cmdBlock;
            JSONObject jCommand = (JSONObject)j;
            if (jCommand == null || (cmdBlock = this.createCommandBlock(jCommand)) == null) continue;
            toReturn.add(cmdBlock);
        }
        return toReturn;
    }

    private CommandBlock createCommandBlock(JSONObject jCommand) {
        JSONObject sqlCommand = (JSONObject)jCommand.get((Object)"sqlCommand");
        if (sqlCommand != null) {
            String sql = (String)sqlCommand.get((Object)"sql");
            sql = this.getMacroExpanded(sql);
            return new CommandBlock(CmdType.SQL, sql, null, null);
        }
        JSONObject jStartCommand = (JSONObject)jCommand.get((Object)"sessionStartCommand");
        if (jStartCommand != null) {
            return this.createSessionCommandBlock(jStartCommand, CmdType.START_SESSION);
        }
        JSONObject jEndSession = (JSONObject)jCommand.get((Object)"sessionEndCommand");
        if (jEndSession != null) {
            return this.createSessionCommandBlock(jEndSession, CmdType.END_SESSION);
        }
        return null;
    }

    private CommandBlock createSessionCommandBlock(JSONObject jSessionCmd, CmdType cmdType) {
        String u = null;
        String p = null;
        JSONObject jArgs = null;
        Object obj = jSessionCmd.get((Object)"arguments");
        if (obj instanceof JSONObject && (obj = (jArgs = (JSONObject)obj).get((Object)"argument")) != null) {
            JSONArray arguments;
            if (obj instanceof JSONArray) {
                arguments = (JSONArray)obj;
            } else {
                arguments = new JSONArray();
                arguments.add(obj);
            }
            for (Object o : arguments) {
                JSONObject jArg = (JSONObject)o;
                if (jArg == null) continue;
                String name = (String)jArg.get((Object)"name");
                String value = this.getMacroExpanded((String)jArg.get((Object)"value"));
                if ("OCI_ATTR_USERNAME".equals(name)) {
                    u = value;
                }
                if (!"OCI_ATTR_PASSWORD".equals(name)) continue;
                p = value;
            }
            return new CommandBlock(cmdType, null, u, p);
        }
        return null;
    }

    private String getMacroExpanded(String strToExpand) {
        if (this.macroExpander != null && strToExpand != null && strToExpand.contains("#")) {
            return this.macroExpander.expand(strToExpand);
        }
        return strToExpand;
    }

    public void executeOpenCommands(Connection connection) {
        this.executeCommands(connection, this.openConnectionCommands);
        this.executeCommands(connection, this.openSessionCommands);
    }

    public void executeCloseCommands(Connection connection) {
        this.executeCommands(connection, this.closeSessionCommands);
        this.executeCommands(connection, this.closeConnectionCommands);
    }

    public void execute(Connection connection, CommandBlock cmd) {
        if (CmdType.SQL == cmd.getType()) {
            try (Statement stmt = connection.createStatement();){
                stmt.execute(cmd.getSqlCommand());
                LoggerAdapter.debug(this, "Executed command block SQL: " + cmd);
            }
            catch (SQLException e) {
                throw new MoserException(MoserError.MSR_CMD_ExecuteCmdBlock, cmd.getSqlCommand(), (Throwable)e);
            }
            return;
        }
        if (!(connection instanceof IAdaptorConnection)) {
            return;
        }
        IAdaptorConnection adaptorConn = (IAdaptorConnection)connection;
        try {
            if (CmdType.START_SESSION == cmd.getType()) {
                if (MetadataProviderFactory.isDB2(this.connectionString) && !MetadataProviderFactory.isDB2TrustedContext(this.connectionString) && cmd.getUser() != null) {
                    throw new MoserException(MoserError.MSR_CMD_TRUSTED, this.connectionString);
                }
                LoggerAdapter.debug(this, "Switching user in start session");
                adaptorConn.switchUser(Boolean.TRUE, cmd.getUser(), cmd.getPassword(), this.getRegistryName(this.connectionString));
            } else if (CmdType.END_SESSION == cmd.getType()) {
                if (MetadataProviderFactory.isDB2(this.connectionString) && !MetadataProviderFactory.isDB2TrustedContext(this.connectionString) && cmd.getUser() != null) {
                    throw new MoserException(MoserError.MSR_CMD_TRUSTED, this.connectionString);
                }
                LoggerAdapter.debug(this, "Switching user in end session");
                adaptorConn.switchUser(Boolean.FALSE, cmd.getUser(), cmd.getPassword(), this.getRegistryName(this.connectionString));
            }
        }
        catch (SQLException e) {
            throw new MoserException(MoserError.MSR_CMD_ExecuteCmdBlock, cmd.getType().name(), (Throwable)e);
        }
    }

    private void executeCommands(Connection connection, List<CommandBlock> commands) {
        for (CommandBlock cmd : commands) {
            this.execute(connection, cmd);
        }
    }

    public static class CommandBlock {
        private CmdType mCmdType;
        private String mSqlCommand;
        private String mSwitchToUserName;
        private String mSwitchToUserPassword;

        public CommandBlock(CmdType cmdType, String sqlCommand, String u, String p) {
            this.mCmdType = cmdType;
            this.mSqlCommand = sqlCommand;
            this.mSwitchToUserName = u;
            this.mSwitchToUserPassword = p;
        }

        public String getSqlCommand() {
            return this.mSqlCommand;
        }

        public String getUser() {
            return this.mSwitchToUserName;
        }

        public String getPassword() {
            return this.mSwitchToUserPassword;
        }

        public CmdType getType() {
            return this.mCmdType;
        }
    }

    public static enum CmdType {
        SQL,
        START_SESSION,
        END_SESSION;

    }
}

