/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata.provider.jdbc;

import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.JDBCTraceHandler;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.MoserCommandBlockExecutor;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.cognos.jmd.connection.JDBCConnectionSpecification;
import com.ibm.cognos.jmd.exception.JMDConnectionException;
import java.sql.Connection;
import java.util.Properties;
import java.util.logging.Handler;

public class MoserJMDConnection
extends JDBCConnectionSpecification {
    private MoserCommandBlockExecutor cmdBlockExecutor = null;

    public MoserJMDConnection(String url, String driverClass, Properties properties, boolean uncertifiedAllowed, JDBCTraceHandler createTracehandler) throws JMDConnectionException {
        this(url, driverClass, properties, uncertifiedAllowed, createTracehandler, null);
    }

    public MoserJMDConnection(String url, String driverClass, Properties properties, boolean uncertifiedAllowed, JDBCTraceHandler createTracehandler, MoserCommandBlockExecutor cmdBlockExecutor) throws JMDConnectionException {
        super(url, driverClass, properties, uncertifiedAllowed, (Handler)createTracehandler);
        this.cmdBlockExecutor = cmdBlockExecutor;
    }

    public Connection getConnection() throws JMDConnectionException {
        if (this.connection != null) {
            return this.connection;
        }
        super.getConnection();
        if (this.connection != null && this.cmdBlockExecutor != null) {
            this.cmdBlockExecutor.executeOpenCommands(this.connection);
        }
        return this.connection;
    }

    public void closeConnection() throws JMDConnectionException {
        if (this.connection == null) {
            return;
        }
        if (this.cmdBlockExecutor != null) {
            this.cmdBlockExecutor.executeCloseCommands(this.connection);
        }
        super.closeConnection();
    }

    protected void logMessage(String message) {
        LoggerAdapter.debug((Object)this, message);
    }
}

