/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata.provider.jdbc;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.utils.MoserMessageKeys;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.core.tasks.TaskStatus;
import com.ibm.bi.platform.moser.core.tasks.TaskStep;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.cognos.jmd.importer.IJMDProgressCallback;
import java.util.Locale;

public class MoserMDImportProgressCallback
implements IJMDProgressCallback {
    TaskStatus taskStatus = null;
    TaskStep currentStep = null;
    Locale productLocale;

    public MoserMDImportProgressCallback(TaskStatus tStatus, Locale locale) {
        this.taskStatus = tStatus;
        this.productLocale = locale;
    }

    public void estimate(int numTables) {
        if (this.taskStatus == null) {
            return;
        }
        String msg = MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_STS_IMPORTING_TABLES, (Locale)this.productLocale, (String)Integer.toString(numTables));
        this.currentStep = new TaskStep(msg, numTables);
        TaskStep step = this.taskStatus.getTaskStep();
        if (step != null) {
            step.setCurrentSubtask(this.currentStep);
        }
        LoggerAdapter.info(this, msg);
    }

    public boolean isCancelled() {
        if (this.taskStatus != null) {
            return this.taskStatus.isCancelled();
        }
        return false;
    }

    public void update(String table) {
        String msg = MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_STS_IMPORTING_TABLE, (Locale)this.productLocale, (String)table);
        if (this.taskStatus != null && this.currentStep != null) {
            this.currentStep.incrementStepNumber();
            this.currentStep.setCurrentStepDescription(msg);
        }
        LoggerAdapter.trace(this, msg);
    }
}

