/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata.provider.jdbc;

import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.IMacroExpander;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import javax.ws.rs.core.Response;

public class MoserMacroExpander
implements IMacroExpander {
    private final RequestEnvironment reqEnv;

    public MoserMacroExpander(RequestEnvironment env) {
        this.reqEnv = env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String expand(String expr) {
        if (!expr.contains("#")) {
            return expr;
        }
        long st = System.currentTimeMillis();
        try {
            JSONObject spec = this.generateMoserCommand(expr);
            RESTClientResponse resp = this.reqEnv.getMoserCommandService().doMoserCommand(spec);
            if (resp.getResponseCode() != Response.Status.OK.getStatusCode()) {
                String string = expr;
                return string;
            }
            JSONObject jResp = resp.getJSONObjectResponse();
            JSONArray expandedMacros = (JSONArray)jResp.get((Object)"expandedMacros");
            String string = (String)((JSONObject)expandedMacros.get(0)).get((Object)"target");
            return string;
        }
        finally {
            LoggerAdapter.debug(this, "Macro expansion time: " + (System.currentTimeMillis() - st));
        }
    }

    protected JSONObject generateMoserCommand(String expr) {
        JSONObject top = new JSONObject();
        top.put((Object)"moserFunctionType", (Object)"expandMacros");
        JSONArray exprArray = new JSONArray();
        exprArray.add((Object)expr);
        top.put((Object)"expressions", (Object)exprArray);
        return top;
    }
}

