/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata.provider.jdbc;

import com.ibm.bi.platform.moser.core.cm.OIDCSignon;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.JDBCTraceHandler;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.MoserCommandBlockExecutor;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.MoserJMDConnection;
import com.ibm.bi.platform.moser.core.utils.EncryptedObject;
import com.ibm.cognos.jmd.exception.JMDConnectionException;
import java.sql.Connection;
import java.util.Properties;

public class MoserOIDCJMDConnection
extends MoserJMDConnection {
    public static final String OIDC_SIGNON = "oidc.signon";
    private static final String OIDC_NAMESPACE = "oidc.namespace";
    private static final String OIDC_ATOKEN = "oidc.atoken";
    private static final String OIDC_IDTOKEN = "oidc.idtoken";
    private final OIDCSignon mOIDCSignon;

    public MoserOIDCJMDConnection(String url, String driverClass, Properties properties, boolean uncertifiedAllowed, JDBCTraceHandler createTracehandler, MoserCommandBlockExecutor cmdBlockExecutor) throws JMDConnectionException {
        super(url, driverClass, properties, uncertifiedAllowed, createTracehandler, cmdBlockExecutor);
        this.mOIDCSignon = (OIDCSignon)properties.get(OIDC_SIGNON);
    }

    public static boolean isOIDC(Properties properties) {
        return properties.containsKey(OIDC_SIGNON) && ((OIDCSignon)properties.get(OIDC_SIGNON)).isDefined();
    }

    @Override
    public Connection getConnection() throws JMDConnectionException {
        if (!this.mOIDCSignon.isDefined()) {
            return null;
        }
        if (this.connection != null) {
            return this.connection;
        }
        Properties properties = this.getProperties();
        properties.put(OIDC_NAMESPACE, this.mOIDCSignon.getNamespace());
        properties.put(OIDC_ATOKEN, this.mOIDCSignon.getAccessToken().decrypt());
        EncryptedObject<String> idToken = this.mOIDCSignon.getIdToken();
        if (idToken != null) {
            properties.put(OIDC_IDTOKEN, idToken.decrypt());
        }
        return super.getConnection();
    }
}

