/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata.provider.jdbc;

import com.cognos.xqe.data.providers.secbridge.IImpersonator;
import com.cognos.xqe.data.providers.secbridge.ImpersonatorFactory;
import com.cognos.xqe.data.providers.secbridge.LocaleConverter;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.JDBCTraceHandler;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.MoserCommandBlockExecutor;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.MoserJMDConnection;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.cognos.jmd.exception.JMDConnectionException;
import java.sql.Connection;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.Callable;

public class MoserSSOIntegratedSecurityConnection
extends MoserJMDConnection {
    private static final String INTEGRATED_SECURITY = "integratedSecurity";
    public static final String CRYPTO_HANDLE = "cryptoHandle";
    public static final String LOCALE = "productLocale";

    public MoserSSOIntegratedSecurityConnection(String url, String driverClass, Properties properties, boolean uncertifiedAllowed, JDBCTraceHandler createTracehandler, MoserCommandBlockExecutor cmdBlockExecutor) throws JMDConnectionException {
        super(url, driverClass, properties, uncertifiedAllowed, createTracehandler, cmdBlockExecutor);
    }

    public static boolean isIntegratedSecurity(Properties props) {
        return props.containsKey(INTEGRATED_SECURITY) && "true".equals(props.getProperty(INTEGRATED_SECURITY));
    }

    public Connection superGetConnection() throws JMDConnectionException {
        LoggerAdapter.debug((Object)this, "superGetConnection");
        return super.getConnection();
    }

    @Override
    public Connection getConnection() throws JMDConnectionException {
        if (this.connection != null) {
            return this.connection;
        }
        Properties properties = this.getProperties();
        String userId = properties.getProperty("user");
        String password = properties.getProperty("password");
        Locale locale = (Locale)properties.get(LOCALE);
        String cryptoHandle = (String)properties.get(CRYPTO_HANDLE);
        properties = (Properties)properties.clone();
        properties.remove(CRYPTO_HANDLE);
        properties.remove(LOCALE);
        properties.remove("user");
        properties.remove("password");
        this.setProperties(properties);
        boolean isSingleSignOn = false;
        if (this.url.contains(INTEGRATED_SECURITY)) {
            isSingleSignOn = cryptoHandle != null ? true : userId != null && password != null;
        }
        if (!isSingleSignOn) {
            return this.superGetConnection();
        }
        class ConnectTask
        implements Callable<Object> {
            ConnectTask() {
            }

            @Override
            public Object call() throws JMDConnectionException {
                LoggerAdapter.debug(this, "ConnectTask call()");
                MoserSSOIntegratedSecurityConnection.this.connection = MoserSSOIntegratedSecurityConnection.this.superGetConnection();
                return MoserSSOIntegratedSecurityConnection.this.connection;
            }
        }
        ConnectTask connectTask = new ConnectTask();
        int runLocale = Integer.parseInt(LocaleConverter.toLCID(locale));
        try {
            if (cryptoHandle != null) {
                this.invokeWithCAMImpersonation(connectTask, cryptoHandle, runLocale);
            } else {
                String domainName = "";
                String uId = userId;
                int slashPos = uId.indexOf(92);
                if (slashPos > 0) {
                    domainName = uId.substring(0, slashPos);
                    userId = uId.substring(slashPos + 1);
                }
                this.invokeWithWinImpersonation(connectTask, domainName, userId, password, runLocale);
            }
        }
        catch (MoserException e) {
            this.logMessage("SSO connection failed: " + e.toString());
            if (this.connection != null) {
                this.closeConnection();
                throw new MoserException(MoserError.MSR_WSB_SSO_CONNECTION_FAILED, (Throwable)e);
            }
            throw new MoserException(MoserError.MSR_WSB_SSO_CONNECTION_FAILED, (Throwable)e);
        }
        this.logMessage("SSO connection succeeded");
        return this.connection;
    }

    public <T> T invokeWithCAMImpersonation(Callable<T> task, String camCryptoHandle, int errorLocale) {
        LoggerAdapter.debug((Object)this, "invokeWithCAMImpersonation: " + camCryptoHandle);
        IImpersonator camImpersonater = ImpersonatorFactory.createCAMImpersonater(camCryptoHandle, errorLocale);
        try {
            return camImpersonater.runPrivilegedTask(task);
        }
        catch (Exception e) {
            LoggerAdapter.error((Object)this, "Error doing invokeWithCAMImpersonation" + e.getLocalizedMessage());
            throw new MoserException(MoserError.INTERNAL_ERROR, (Throwable)e);
        }
        catch (Throwable e) {
            throw new MoserException(MoserError.INTERNAL_ERROR, e);
        }
    }

    public <T> T invokeWithWinImpersonation(Callable<T> task, String domainName, String userName, String password, int errorLocale) {
        IImpersonator winImpersonater = ImpersonatorFactory.createWinImpersonater(domainName, userName, password, errorLocale);
        try {
            return winImpersonater.runPrivilegedTask(task);
        }
        catch (Exception e) {
            LoggerAdapter.error((Object)this, "Error doing invokeWithCAMImpersonation" + e.getLocalizedMessage());
            throw new MoserException(MoserError.INTERNAL_ERROR, (Throwable)e);
        }
        catch (Throwable e) {
            throw new MoserException(MoserError.INTERNAL_ERROR, e);
        }
    }
}

