/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata.provider.jdbc.kerberos;

import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.cm.kerberos.JCAMImpersonator;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.JDBCTraceHandler;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.MoserCommandBlockExecutor;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.MoserJMDConnection;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.kerberos.KerberosConnectionHelper;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.cognos.jmd.exception.JMDConnectionException;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;

public class MoserKerberosJMDConnection
extends MoserJMDConnection {
    private static final String JAAS_NOSSO_LOGIN_CONFIGURATION = "com.cognos.biserver.security.xqe.jdbc";
    private static final String JAVA_KRB5 = "java_krb5";
    public static final String IBMCOGNOS_AUTHENTICATION = "ibmcognos.authentication";
    private static final String IBMCOGNOS_AUTHENTICATION_JAVA_KRB5 = "ibmcognos.authentication=java_krb5";
    private static final String DOT = ".";
    protected static final String QUESTIONMARK = "?";
    protected static final String VERSION_FORMAT = "%1$d.%2$d";
    public static final String KERBEROS_CREDENTIAL = "kerberosCredential";

    public MoserKerberosJMDConnection(String url, String driverClass, Properties properties, boolean uncertifiedAllowed, JDBCTraceHandler createTracehandler, MoserCommandBlockExecutor cmdBlockExecutor) throws JMDConnectionException {
        super(url, driverClass, properties, uncertifiedAllowed, createTracehandler, cmdBlockExecutor);
    }

    public Connection superGetConnection() throws JMDConnectionException {
        return super.getConnection();
    }

    @Override
    public Connection getConnection() throws JMDConnectionException {
        if (this.connection != null) {
            return this.connection;
        }
        Properties properties = this.getProperties();
        final String userId = properties.getProperty("user");
        final String password = properties.getProperty("password");
        this.logMessage("[JDBC Kerberos] Java Vendor Is: " + System.getProperty("java.vendor"));
        this.logMessage("[JDBC Kerberos] Discovered propertyibmcognos.authentication=java_krb5.");
        JCAMImpersonator.DelegatedCredential dc = (JCAMImpersonator.DelegatedCredential)properties.get(KERBEROS_CREDENTIAL);
        Subject subject = null;
        GSSCredential gssCredential = null;
        if (dc != null) {
            subject = dc.getSubject();
            gssCredential = dc.getCredential();
        }
        properties = (Properties)properties.clone();
        properties.remove(IBMCOGNOS_AUTHENTICATION);
        properties.remove(KERBEROS_CREDENTIAL);
        properties.remove("user");
        properties.remove("password");
        this.setProperties(properties);
        if (subject != null) {
            this.logMessage("[JDBC kerberos] Extracted JAAS Subject from signon.");
        } else if (userId != null && password != null && !password.isEmpty()) {
            this.logMessage("[JDBC Kerberos] received UID(%s)/PWD signon, will create a JAAS login context");
        } else {
            if (userId != null) {
                properties.put("user", userId);
                this.setProperties(properties);
            }
            this.logMessage("[JDBC Kerberos] received no login information in sign on, switch SSO off.");
            return this.superGetConnection();
        }
        if (subject == null) {
            try {
                class SimpleCallbackHandler
                implements CallbackHandler {
                    SimpleCallbackHandler() {
                    }

                    @Override
                    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                        for (Callback callback : callbacks) {
                            if (callback instanceof NameCallback) {
                                NameCallback nc = (NameCallback)callback;
                                nc.setName(userId);
                                continue;
                            }
                            if (callback instanceof PasswordCallback) {
                                PasswordCallback pc = (PasswordCallback)callback;
                                pc.setPassword(password.toCharArray());
                                continue;
                            }
                            throw new UnsupportedCallbackException(callback, "Internal error - unrecognized Callback");
                        }
                    }
                }
                LoginContext lc = null;
                try {
                    lc = new LoginContext(JAAS_NOSSO_LOGIN_CONFIGURATION, new SimpleCallbackHandler());
                }
                catch (LoginException e) {
                    LoggerAdapter.error((Object)this, "Instantiating LoginContext failed. Try with built-in login configuration", e);
                }
                if (lc == null) {
                    lc = new LoginContext(JAAS_NOSSO_LOGIN_CONFIGURATION, null, new SimpleCallbackHandler(), new KerberosConnectionHelper.LocalConfiguration());
                }
                lc.login();
                subject = lc.getSubject();
            }
            catch (Exception e) {
                this.logMessage("[JDBC Kerberos] Login context failed: " + e.toString());
                throw new MoserException(MoserError.MSR_KRB_SSOConnectionFailed, (Throwable)e);
            }
        }
        class ConnectTask
        implements PrivilegedAction<Exception> {
            Exception ex = null;

            ConnectTask() {
            }

            @Override
            public Exception run() {
                try {
                    MoserKerberosJMDConnection.this.connection = MoserKerberosJMDConnection.this.superGetConnection();
                }
                catch (Exception e) {
                    this.ex = e;
                }
                return this.ex;
            }

            public Exception getException() {
                return this.ex;
            }
        }
        ConnectTask connectTask = new ConnectTask();
        try {
            if (gssCredential != null) {
                this.logMessage("[JDBC Kerberos] Using Constrained delegation with credential");
                properties.put("JGSSCredential", gssCredential);
            } else {
                this.logMessage("[JDBC Kerberos] Using unconstrained delegation with principal");
            }
            Subject.doAs(subject, connectTask);
            if (this.connection == null) {
                throw connectTask.getException();
            }
        }
        catch (Exception e) {
            this.logMessage("[JDBC Kerberos] Connection failed: " + e.toString());
            if (this.connection != null) {
                this.closeConnection();
                throw new MoserException(MoserError.MSR_KRB_SSOConnectionFailed, (Throwable)e);
            }
            throw new MoserException(MoserError.MSR_KRB_SSOConnectionFailed, (Throwable)e);
        }
        this.logMessage("[JDBC Kerberos] Connection succeeded");
        return this.connection;
    }

    public static boolean isKerberos(Properties props) {
        return props.containsKey(IBMCOGNOS_AUTHENTICATION) && props.getProperty(IBMCOGNOS_AUTHENTICATION).equals(JAVA_KRB5);
    }
}

