/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata.provider.report;

import com.ibm.bi.platform.datasetutils.metadata.ColumnMetadata;
import com.ibm.bi.platform.datasetutils.metadata.types.Type;
import com.ibm.bi.platform.datasetutils.utils.MetadataUtils;
import com.ibm.bi.platform.moser.common.generated.metadata.Column;
import com.ibm.bi.platform.moser.common.generated.metadata.DataSource;
import com.ibm.bi.platform.moser.common.generated.metadata.HighLevelDataType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectFactory;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.RegularAggregateType;
import com.ibm.bi.platform.moser.common.generated.metadata.Table;
import com.ibm.bi.platform.moser.common.generated.metadata.TableItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.UsageType;
import com.ibm.bi.platform.moser.common.utils.IdentifierUtil;
import com.ibm.bi.platform.moser.common.utils.MoserCommonUtils;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class GenerateBaseModuleFromReportOutput {
    public static final String CONTAINER = "reportOutput";
    private static final String PARQUET = "PARQUET";
    private static final String ELE_DATASETINFO = "//datasetInfo";
    private static final String ELE_ROWSET_EX = "//rowsetInfoEx";
    private static final String ELE_COLUMNINFO_EX = "columnInfoEx";
    private static final String ELE_COLUMN_DEPENDENCY = "columnDependency";
    private static final String ELE_KEYREF = "keyRef";
    private static final String VALUE_DEFAULT_DSNAME = "report";
    private static final String XPATH_COLUMNINFO = "//columnInfo";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_LABEL = "label";
    private static final String ELE_FORMAT = "format";
    private static final String ATTR_NULLSOK = "nullsOk";
    private static final String ATTR_SUBTYPE = "subType";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_PRECISION = "precision";
    private static final String ATTR_SCALE = "scale";
    private static final String ATTR_AGGREGATE = "aggregate";
    private static final String ATTR_REF = "ref";
    private final ObjectFactory moduleFactory = new ObjectFactory();
    private final CaseInsensitiveMap existings = new CaseInsensitiveMap();
    private final Module physicalModule = this.moduleFactory.createModule();
    private final Module baseModule;
    private Map<String, String> columnNameToAggregate;

    public GenerateBaseModuleFromReportOutput(String reportName) {
        this.physicalModule.setIdentifier("physicalmodule");
        this.physicalModule.setContainer(CONTAINER);
        this.physicalModule.setLabel(reportName);
        this.physicalModule.setVersion("11.1");
        this.baseModule = this.moduleFactory.createModule();
        this.baseModule.setIdentifier("baseModule");
        this.baseModule.setContainer(CONTAINER);
        GenerateBaseModuleFromReportOutput.addUses(this.baseModule, CONTAINER, this.physicalModule.getIdentifier());
        this.baseModule.setLabel(reportName);
        this.baseModule.setVersion("11.1");
    }

    public static void addUses(Module module, String moduleContainer, String moduleId) {
        module.getUse().add((moduleContainer == null ? "" : moduleContainer + ".") + moduleId);
    }

    public Module getBaseModule() {
        return this.baseModule;
    }

    public Module getPhysicalModule() {
        return this.physicalModule;
    }

    public boolean addMasterDataSet(String md) {
        List columnDependencies;
        List columnExs;
        Element root = null;
        try {
            Document document = DocumentHelper.parseText((String)md);
            root = document.getRootElement();
        }
        catch (DocumentException e) {
            LoggerAdapter.errorExceptionStack(GenerateBaseModuleFromReportOutput.class, e);
            return false;
        }
        Element eleDatasetInfo = (Element)root.selectSingleNode(ELE_DATASETINFO);
        if (eleDatasetInfo == null) {
            LoggerAdapter.error(GenerateBaseModuleFromReportOutput.class, "invalid master dataset: missing datasetInfo element.");
            return false;
        }
        this.columnNameToAggregate = null;
        Element eleDatasetInfoEx = (Element)root.selectSingleNode(ELE_ROWSET_EX);
        if (eleDatasetInfoEx != null && (columnExs = eleDatasetInfoEx.selectNodes(ELE_COLUMNINFO_EX)) != null && !columnExs.isEmpty()) {
            this.columnNameToAggregate = new HashMap<String, String>();
            for (Node node : columnExs) {
                Element colEx = (Element)node;
                String name = colEx.attributeValue(ATTR_NAME);
                String aggr = colEx.attributeValue(ATTR_AGGREGATE);
                if (name == null || name.isEmpty() || aggr == null || aggr.isEmpty()) continue;
                this.columnNameToAggregate.put(name, aggr);
            }
        }
        DataSource ds = this.moduleFactory.createDataSource();
        String name = eleDatasetInfo.attributeValue(ATTR_NAME, VALUE_DEFAULT_DSNAME);
        String normalized = IdentifierUtil.makeUniqueAndValidIdentifier((String)name, (CaseInsensitiveMap)this.existings);
        ds.setName(normalized);
        ds.setDescription(name);
        ds.setDatabaseType(PARQUET);
        this.existings.put((Object)normalized, (Object)Boolean.TRUE);
        Table table = this.moduleFactory.createTable();
        table.setName(normalized);
        table.setDescription(name);
        ds.getTable().add(table);
        QuerySubject qs = this.moduleFactory.createQuerySubject();
        qs.setIdentifier(normalized);
        String qsLabel = GenerateBaseModuleFromReportOutput.capitalizeFullyIgnoreDefaultLocale(name);
        qs.setLabel(qsLabel);
        qs.getRef().add(normalized);
        qs.setDescription(name);
        CaseInsensitiveMap existingQIs = new CaseInsensitiveMap();
        List columnList = eleDatasetInfo.selectNodes(XPATH_COLUMNINFO);
        HashMap<String, String> orgNameToIdentifier = new HashMap<String, String>();
        for (Node c : columnList) {
            RegularAggregateType aggr;
            String formatStr;
            Element format;
            Element columnInfo = (Element)c;
            String cName = columnInfo.attributeValue(ATTR_NAME);
            if (cName == null || cName.isEmpty() || MoserUtil.isProperty(columnInfo)) continue;
            String uId = IdentifierUtil.makeUniqueAndValidIdentifier((String)cName, (CaseInsensitiveMap)existingQIs);
            orgNameToIdentifier.put(cName, uId);
            existingQIs.put((Object)uId, (Object)Boolean.TRUE);
            Column column = this.moduleFactory.createColumn();
            column.setName(uId);
            QueryItem qi = this.moduleFactory.createQueryItem();
            qi.setIdentifier(uId);
            qi.setExpression(uId);
            String label = columnInfo.attributeValue(ATTR_LABEL);
            if (label != null && !label.isEmpty()) {
                column.setDescription(label);
                qi.setLabel(label);
                qi.setDescription(label);
            }
            if ((format = (Element)columnInfo.selectSingleNode(ELE_FORMAT)) != null && (formatStr = format.getTextTrim()) != null && !formatStr.isEmpty()) {
                qi.setFormat(formatStr);
            }
            try {
                String subType = columnInfo.attributeValue(ATTR_SUBTYPE);
                qi.setUsage(UsageType.fromValue((String)subType));
            }
            catch (IllegalArgumentException e) {
                qi.setUsage(UsageType.AUTOMATIC);
            }
            byte type = Byte.parseByte(columnInfo.attributeValue(ATTR_TYPE));
            int precision = Integer.parseInt(columnInfo.attributeValue(ATTR_PRECISION));
            int scale = Integer.parseInt(columnInfo.attributeValue(ATTR_SCALE));
            int nullable = Integer.parseInt(columnInfo.attributeValue(ATTR_NULLSOK));
            ColumnMetadata colMd = MetadataUtils.generateColumnFromRSVPMasterDataset((String)uId, (byte)type, (int)precision, (int)scale, (int)nullable);
            Type colType = colMd.getType();
            String dt = colType.toXQETypeString();
            column.setDatatype(dt);
            qi.setDatatype(dt);
            column.setNullable(Boolean.valueOf(colMd.isNullable()));
            qi.setNullable(Boolean.valueOf(colMd.isNullable()));
            if (UsageType.FACT.equals((Object)qi.getUsage())) {
                if (GenerateBaseModuleFromReportOutput.isNumeric(dt)) {
                    aggr = this.getAggregate(cName, RegularAggregateType.TOTAL);
                    qi.setRegularAggregate(aggr);
                } else {
                    qi.setUsage(UsageType.ATTRIBUTE);
                    qi.setRegularAggregate(RegularAggregateType.NONE);
                }
            } else {
                aggr = this.getAggregate(cName, RegularAggregateType.NONE);
                qi.setRegularAggregate(aggr);
            }
            TableItemType tableItemType = new TableItemType();
            tableItemType.setColumn(column);
            table.getTableItem().add(tableItemType);
            ItemType item = this.moduleFactory.createItemType();
            item.setQueryItem(qi);
            qs.getItem().add(item);
        }
        if (eleDatasetInfoEx != null && (columnDependencies = eleDatasetInfoEx.selectNodes(ELE_COLUMN_DEPENDENCY)) != null && !columnDependencies.isEmpty()) {
            for (Node node : columnDependencies) {
                Element colDependency = (Element)node;
                String ref = colDependency.attributeValue(ATTR_REF);
                ref = (String)orgNameToIdentifier.get(ref);
                List keyRefs = colDependency.selectNodes(ELE_KEYREF);
                if (ref == null || ref.isEmpty() || keyRefs == null || keyRefs.isEmpty()) continue;
                QuerySubject.ColumnDependency dependency = this.moduleFactory.createQuerySubjectColumnDependency();
                dependency.setRef(ref);
                for (Node node2 : keyRefs) {
                    Element keyRef = (Element)node2;
                    ref = keyRef.attributeValue(ATTR_REF);
                    if (ref == null) {
                        dependency = null;
                        break;
                    }
                    if ((ref = (String)orgNameToIdentifier.get(ref)) == null) {
                        dependency = null;
                        break;
                    }
                    dependency.getKeyRef().add(ref);
                }
                if (dependency == null) continue;
                qs.getColumnDependency().add(dependency);
            }
        }
        this.baseModule.getQuerySubject().add(qs);
        this.physicalModule.getDataSource().add(ds);
        return true;
    }

    protected RegularAggregateType getAggregate(String cName, RegularAggregateType defaultAggr) {
        if (this.columnNameToAggregate == null) {
            return defaultAggr;
        }
        String aggr = this.columnNameToAggregate.get(cName);
        if (aggr == null) {
            return defaultAggr;
        }
        return RegularAggregateType.fromValue((String)aggr);
    }

    private static boolean isNumeric(String type) {
        HighLevelDataType hld = MoserCommonUtils.generateHighlevelDatatype((String)type);
        return HighLevelDataType.INTEGER.equals((Object)hld) || HighLevelDataType.DECIMAL.equals((Object)hld);
    }

    private static String capitalizeFullyIgnoreDefaultLocale(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        char[] buffer = str.toCharArray();
        for (int i = 0; i < buffer.length; ++i) {
            char ch = buffer[i];
            if (!Character.isUpperCase(ch) && !Character.isTitleCase(ch)) continue;
            buffer[i] = Character.toLowerCase(ch);
        }
        String lowerStr = new String(buffer);
        return WordUtils.capitalize((String)lowerStr);
    }
}

