/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.metadata.util.ICodec;
import com.ibm.bi.platform.moser.core.metadata.util.MoserJaxbAnnotationIntrospector;
import java.io.InputStream;
import java.io.OutputStream;

public class JSONCodec
implements ICodec {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final ObjectMapper STRICT_MAPPER = new ObjectMapper();

    @Override
    public String encode(Object o) {
        try {
            return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(o);
        }
        catch (Exception e) {
            throw new MoserException((Throwable)e);
        }
    }

    @Override
    public Object decode(Class<?> c, String json) {
        return this.decode(c, json, false);
    }

    public Object decode(Class<?> c, String json, boolean failOnUnknownProperty) {
        try {
            if (failOnUnknownProperty) {
                return STRICT_MAPPER.readValue(json, c);
            }
            return MAPPER.readValue(json, c);
        }
        catch (Exception e) {
            throw new MoserException((Throwable)e);
        }
    }

    @Override
    public void encode(Object o, OutputStream os) {
        try {
            MAPPER.writeValue(os, o);
        }
        catch (Exception e) {
            throw new MoserException((Throwable)e);
        }
    }

    @Override
    public Object decode(Class<?> c, InputStream is) {
        return this.decode(c, is, false);
    }

    public Object decode(Class<?> c, InputStream is, boolean failOnUnknownProperty) {
        try {
            return failOnUnknownProperty ? STRICT_MAPPER.readValue(is, c) : MAPPER.readValue(is, c);
        }
        catch (Exception e) {
            throw new MoserException((Throwable)e);
        }
    }

    static {
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.setAnnotationIntrospector((AnnotationIntrospector)new MoserJaxbAnnotationIntrospector(MAPPER.getTypeFactory()));
        STRICT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        STRICT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        STRICT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        STRICT_MAPPER.setAnnotationIntrospector((AnnotationIntrospector)new MoserJaxbAnnotationIntrospector(STRICT_MAPPER.getTypeFactory()));
    }
}

