/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata.util;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;

public class JaxbContextPool {
    public static final String RELATIONSHIP = "relationship";
    public static final String STR_QUERYSUBJECT = "querySubject";
    public static final String STR_IDENTIFIER = "identifier";
    public static final String STR_TABLE = "table";
    public static final String STR_NAME = "name";
    private static Boolean formatted = Boolean.FALSE;
    private static final GenericKeyedObjectPool contextPool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new JaxbContextFactory());
    private static JaxbContextPool instance;

    public static JaxbContextPool getInstance() {
        return instance;
    }

    public void marshal(Object o, OutputStream os) throws Exception {
        JAXBContext jaxbContext = null;
        try {
            jaxbContext = (JAXBContext)contextPool.borrowObject(o.getClass());
            Marshaller marshaller = jaxbContext.createMarshaller();
            contextPool.returnObject(o.getClass(), (Object)jaxbContext);
            marshaller.setProperty("jaxb.formatted.output", (Object)formatted);
            marshaller.marshal(o, os);
        }
        catch (Exception e) {
            if (jaxbContext != null) {
                contextPool.invalidateObject(o.getClass(), (Object)jaxbContext);
            }
            throw e;
        }
    }

    public Object unmarshal(InputStream is, Class<?> clazz) throws Exception {
        Unmarshaller unmarshaller = JaxbContextPool.createUnmarshaller(clazz);
        return unmarshaller.unmarshal(is);
    }

    public Object unmarshal(String xml, Class<?> clazz) throws Exception {
        Unmarshaller unmarshaller = JaxbContextPool.createUnmarshaller(clazz);
        return unmarshaller.unmarshal((Reader)new StringReader(xml));
    }

    private static Unmarshaller createUnmarshaller(Class<?> clazz) throws Exception {
        JAXBContext jaxbContext = null;
        try {
            jaxbContext = (JAXBContext)contextPool.borrowObject(clazz);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            contextPool.returnObject(clazz, (Object)jaxbContext);
            return unmarshaller;
        }
        catch (Exception e) {
            if (jaxbContext != null) {
                contextPool.invalidateObject(clazz, (Object)jaxbContext);
            }
            throw e;
        }
    }

    static {
        contextPool.setMinIdle(10);
        contextPool.setMaxIdle(25);
        contextPool.setMaxActive(25);
        contextPool.setMaxTotal(100);
        contextPool.setNumTestsPerEvictionRun(50);
        contextPool.setMinEvictableIdleTimeMillis(300000L);
        contextPool.setTimeBetweenEvictionRunsMillis(900000L);
        contextPool.setWhenExhaustedAction((byte)2);
        contextPool.preparePool(Module.class, true);
        instance = new JaxbContextPool();
    }

    private static class JaxbContextFactory
    extends BaseKeyedPoolableObjectFactory {
        private JaxbContextFactory() {
        }

        public JAXBContext makeObject(Object object) throws Exception {
            return JAXBContext.newInstance((Class[])new Class[]{(Class)object});
        }
    }
}

