/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata.util;

import com.ibm.bi.platform.moser.common.generated.metadata.DefLinkType;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.MoserObject;
import com.ibm.bi.platform.moser.common.generated.metadata.NamedSet;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.utils.MoserObjectUtils;
import com.ibm.bi.platform.moser.common.utils.ReferenceResolver;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import java.util.ArrayList;
import java.util.List;

public class ModuleFilterer {
    private ModuleFilterer() {
    }

    public static void filterModule(Module module, List<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        MoserUtil.resolveModule(module);
        List<MoserObject> objectsToRetain = ModuleFilterer.getMoserObjects(module, ids);
        ModuleFilterer.removeModuleObjects(module, objectsToRetain);
    }

    private static void removeFromMDTV(Module module, List<MoserObject> objectsToRemove) {
        if (module.basicGetMetadataTreeView() == null) {
            return;
        }
        for (FolderType folder : module.basicGetMetadataTreeView()) {
            if (folder == null) continue;
            for (MoserObject mo : objectsToRemove) {
                ModuleFilterer.removeFromMDTVFolder(((ObjectType)mo).getIdentifier(), folder);
            }
        }
    }

    private static void removeFromMDTVFolder(String qsId, FolderType folder) {
        if (folder == null || folder.basicGetFolderItem() == null) {
            return;
        }
        List itemList = MoserObjectUtils.getList((List)folder.basicGetFolderItem());
        for (int j = itemList.size() - 1; j >= 0; --j) {
            if (qsId.equals(((FolderItemType)itemList.get(j)).getRef())) {
                folder.removeFolderItemAt(j);
                continue;
            }
            DefLinkType defLink = ((FolderItemType)itemList.get(j)).getDefLink();
            if (defLink != null && qsId.equals(defLink.getRef())) {
                folder.removeFolderItemAt(j);
                continue;
            }
            ModuleFilterer.removeFromMDTVFolder(qsId, ((FolderItemType)itemList.get(j)).getFolder());
        }
    }

    private static void removeModuleObjects(Module module, List<MoserObject> objectsToRetain) {
        ModuleFilterer.removeModuleObjects(module, objectsToRetain, MoserUtil.upcast(module.basicGetQuerySubject(), MoserObject.class));
        ModuleFilterer.removeModuleObjects(module, objectsToRetain, MoserUtil.upcast(module.basicGetCalculation(), MoserObject.class));
        ModuleFilterer.removeModuleObjects(module, objectsToRetain, MoserUtil.upcast(module.basicGetNamedSet(), MoserObject.class));
        ModuleFilterer.removeModuleObjects(module, objectsToRetain, MoserUtil.upcast(module.basicGetFilter(), MoserObject.class));
        ModuleFilterer.removeModuleObjects(module, objectsToRetain, MoserUtil.upcast(module.basicGetRelationship(), MoserObject.class));
    }

    private static List<MoserObject> getMoserObjects(Module module, List<String> ids) {
        ArrayList<MoserObject> objectsToRetain = new ArrayList<MoserObject>();
        for (String id : ids) {
            MoserObject mo = ReferenceResolver.bindMoserObject((Module)module, (String)id);
            if (mo == null) continue;
            ModuleFilterer.addRequestedItemOrParent(module, mo, objectsToRetain);
        }
        return objectsToRetain;
    }

    private static void removeModuleObjects(Module module, List<MoserObject> objectsToRetain, List<MoserObject> listToRemoveFrom) {
        if (listToRemoveFrom != null) {
            List<MoserObject> toRemove = ModuleFilterer.getObjectsToRemove(objectsToRetain, listToRemoveFrom);
            listToRemoveFrom.removeAll(toRemove);
            ModuleFilterer.removeFromMDTV(module, toRemove);
        }
    }

    private static List<MoserObject> getObjectsToRemove(List<MoserObject> objectsToRetain, List<MoserObject> qss) {
        ArrayList<MoserObject> toRemove = new ArrayList<MoserObject>();
        if (qss != null) {
            for (MoserObject qs : qss) {
                if (ModuleFilterer.fastFind(objectsToRetain, qs)) continue;
                toRemove.add(qs);
            }
        }
        return toRemove;
    }

    private static void addRequestedItemOrParent(Module module, MoserObject mo, List<MoserObject> objectsToRetain) {
        if (mo instanceof QueryItem) {
            ModuleFilterer.addParentQuerySubject(mo, objectsToRetain);
        } else if (mo instanceof NamedSet) {
            ModuleFilterer.addToObjects(objectsToRetain, mo);
            NamedSet ns = (NamedSet)mo;
            String refToHierarchy = ns.getRefToHierarchy();
            MoserObject hierarchy = ReferenceResolver.bindMoserObject((Module)module, (String)refToHierarchy);
            if (hierarchy != null) {
                ModuleFilterer.addParentQuerySubject(hierarchy, objectsToRetain);
            }
        } else {
            ModuleFilterer.addToObjects(objectsToRetain, mo);
        }
    }

    private static void addParentQuerySubject(MoserObject mo, List<MoserObject> objectsToRetain) {
        MoserObject parent;
        QueryItem qi = (QueryItem)mo;
        for (parent = qi.getParent(); parent != null && !(parent instanceof QuerySubject); parent = parent.getParent()) {
        }
        if (parent != null) {
            ModuleFilterer.addToObjects(objectsToRetain, parent);
        }
    }

    private static void addToObjects(List<MoserObject> objects, MoserObject objToAdd) {
        if (!ModuleFilterer.fastFind(objects, objToAdd)) {
            objects.add(objToAdd);
        }
    }

    private static boolean fastFind(List<MoserObject> objects, MoserObject obj) {
        for (MoserObject mo : objects) {
            if (mo != obj) continue;
            return true;
        }
        return false;
    }
}

