/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata.util;

import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.BaseObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.TextResource;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.metadata.ModuleContentViewer;
import com.ibm.bi.platform.moser.core.metadata.util.ResolverUtil;
import com.ibm.bi.platform.moser.core.module.util.ModuleUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public class ModuleWrapper {
    private final Module module;
    private final boolean isTopModule;
    private final ModuleContentViewer mdtvGenerator;
    private final boolean isBaseModule;
    private final HashMap<BaseObjectType, BaseObjectType> childToParentMap = new HashMap();
    private final HashMap<Class<?>, ArrayList<BaseObjectType>> objectsByClass = new HashMap();
    private final ArrayList<TextResource> textResouces = new ArrayList();
    private TreeMap<String, ModuleWrapper> sourceModules;
    private Set<BaseObjectType> excludeNodes = new HashSet<BaseObjectType>();
    private Set<BaseObjectType> seenNodes = new HashSet<BaseObjectType>();

    public ModuleWrapper(Module m) {
        this.mdtvGenerator = null;
        this.module = m;
        this.isTopModule = false;
        this.isBaseModule = !m.getUse().isEmpty();
    }

    public ModuleWrapper(ModuleContentViewer v, Module m, boolean topModule) {
        this.mdtvGenerator = v;
        this.module = m;
        this.isTopModule = topModule;
        this.isBaseModule = !m.getUse().isEmpty();
        ResolverUtil.getNodesFromFMPackage(m, this.excludeNodes);
    }

    public Set<BaseObjectType> getExcludeNodes() {
        return this.excludeNodes;
    }

    public Module getModule() {
        return this.module;
    }

    public boolean isTopModule() {
        return this.isTopModule;
    }

    public ModuleContentViewer getMetadataResponseGenerator() {
        return this.mdtvGenerator;
    }

    public boolean isBaseModule() {
        return this.isBaseModule;
    }

    public void collectInfoWalkTree(BaseObjectType node, BaseObjectType parent) {
        if (this.excludeNodes.contains(node)) {
            return;
        }
        if (this.seenNodes.contains(node)) {
            return;
        }
        this.seenNodes.add(node);
        this.childToParentMap.put(node, parent);
        Class<?> objClass = node.getClass();
        ArrayList<Object> lst = this.objectsByClass.get(objClass);
        if (lst == null) {
            lst = new ArrayList();
            this.objectsByClass.put(objClass, lst);
        }
        lst.add(node);
        List<Field> fields = ResolverUtil.getAllFieldsListSkipMoserObject(objClass);
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                Object obj = field.get(node);
                if (obj instanceof BaseObjectType) {
                    this.collectInfoWalkTree((BaseObjectType)obj, node);
                    continue;
                }
                if (!(obj instanceof List)) continue;
                List list = (List)obj;
                for (Object child : list) {
                    if (child instanceof BaseObjectType) {
                        this.collectInfoWalkTree((BaseObjectType)child, node);
                        continue;
                    }
                    if (child instanceof TextResource) {
                        this.textResouces.add((TextResource)child);
                        continue;
                    }
                    if (!(child instanceof ItemType)) continue;
                    ItemType item = (ItemType)child;
                    this.collectInfoWalkTree((BaseObjectType)ResolverUtil.getObject(item), node);
                }
            }
            catch (IllegalAccessException ex) {
                throw new MoserException((Throwable)ex);
            }
        }
    }

    public void getObjectByIdAndClasses(String id, Class<?>[] classes, List<BaseObjectType> rtObjects) {
        if (id == null || id.isEmpty()) {
            return;
        }
        for (Class<?> cls : classes) {
            ArrayList<BaseObjectType> objs = this.objectsByClass.get(cls);
            if (objs == null) continue;
            for (BaseObjectType obj : objs) {
                if (!id.equals(ModuleUtil.getIdentifier(obj))) continue;
                rtObjects.add(obj);
            }
        }
    }

    public BaseObjectType getParent(BaseObjectType obj) {
        return this.childToParentMap.get(obj);
    }

    public BaseObjectType getParentContainer(BaseObjectType obj) {
        if (obj == null) {
            return null;
        }
        BaseObjectType parent = this.getParent(obj);
        return parent == null ? null : (ModuleWrapper.isContainer(parent) ? parent : this.getParentContainer(parent));
    }

    private static boolean isContainer(BaseObjectType obj) {
        String objectType = obj.getObjectType();
        return "Module".equals(objectType) || "QuerySubject".equals(objectType) || "QueryItem".equals(objectType) || "DrillGroup".equals(objectType);
    }

    public boolean matchParent(String[] parentParts, BaseObjectType obj) {
        if (obj == null) {
            return parentParts.length == 0;
        }
        BaseObjectType current = obj;
        for (int i = parentParts.length - 1; i >= 0; --i) {
            if (current == null || !parentParts[i].equals(ModuleUtil.getIdentifier(current))) {
                return false;
            }
            current = this.getParent(current);
        }
        return true;
    }

    public List<TextResource> getTextResources() {
        return this.textResouces;
    }

    public String getObjectUName(BaseObjectType obj, boolean bIncContainer) {
        int sz;
        if (obj instanceof Module) {
            if (bIncContainer) {
                return ((Module)obj).getContainer() + "." + ModuleUtil.getIdentifier(obj);
            }
            return ModuleUtil.getIdentifier(obj);
        }
        ArrayList<String> lst = new ArrayList<String>();
        lst.add(ModuleUtil.getIdentifier(obj));
        BaseObjectType parent = this.getParent(obj);
        while (parent != null) {
            lst.add(ModuleUtil.getIdentifier(parent));
            if (parent instanceof Module) {
                if (!bIncContainer) break;
                lst.add(((Module)parent).getContainer());
                break;
            }
            parent = this.getParent(parent);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = sz = lst.size() - 1; i >= 0; --i) {
            if (i != sz) {
                sb.append(".");
            }
            sb.append((String)lst.get(i));
        }
        return sb.toString();
    }

    public BaseObjectType findObject(String[] ref, Class<?>[] cls) {
        ArrayList<BaseObjectType> list = new ArrayList<BaseObjectType>();
        this.getObjectByIdAndClasses(ref[ref.length - 1], cls, list);
        if (list.isEmpty()) {
            return null;
        }
        String[] parentParts = Arrays.copyOfRange(ref, 0, ref.length - 1);
        if (parentParts.length > 0) {
            ArrayList<BaseObjectType> refinedlist = new ArrayList<BaseObjectType>();
            for (BaseObjectType obj : list) {
                if (!this.matchParent(parentParts, this.getParent(obj))) continue;
                refinedlist.add(obj);
            }
            list.clear();
            list.addAll(refinedlist);
        }
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new MoserException(MoserError.MSR_AMBIGUOUS_REFERENCE, Arrays.toString(ref));
        }
        return list.get(0);
    }

    public ModuleWrapper getModuleWrapperByAlias(String[] refPath, String[] rtRef) {
        ModuleWrapper src;
        int i;
        ModuleWrapper rt = null;
        ModuleWrapper current = this;
        for (i = 0; i < refPath.length && (src = current.getChildModuleByAlias(refPath[i])) != null; ++i) {
            rt = src;
            current = src;
        }
        if (rtRef != null && rt != null && i < refPath.length) {
            StringBuilder sb = new StringBuilder();
            for (int j = i; j < refPath.length; ++j) {
                if (j > i) {
                    sb.append(".");
                }
                sb.append(refPath[j]);
            }
            rtRef[0] = sb.toString();
        }
        return rt;
    }

    protected ModuleWrapper getChildModuleByAlias(String alias) {
        this.initializeUseSpec();
        return this.sourceModules.get(alias);
    }

    protected void initializeUseSpec() {
        if (this.sourceModules != null) {
            return;
        }
        this.sourceModules = new TreeMap();
        List useSpecs = this.getModule().getUseSpec();
        for (Module.UseSpec useSpec : useSpecs) {
            String alias = useSpec.getIdentifier();
            String storeId = useSpec.getStoreID();
            UseSpecType type = useSpec.getType();
            if (alias == null || alias.isEmpty() || storeId == null || storeId.isEmpty() || type == null || UseSpecType.values().length == 0) continue;
            if ((UseSpecType.DATABASE.equals((Object)type) || UseSpecType.FILE.equals((Object)type)) && !storeId.endsWith(".base")) {
                storeId = storeId + ".base";
            }
            ModuleWrapper importModule = this.getMetadataResponseGenerator().getModuleWrapper(storeId);
            this.sourceModules.put(alias, importModule);
        }
    }
}

