/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata.util;

import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.BaseObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.Calculation;
import com.ibm.bi.platform.moser.common.generated.metadata.FacetType;
import com.ibm.bi.platform.moser.common.generated.metadata.FacetTypeEnabled;
import com.ibm.bi.platform.moser.common.generated.metadata.Filter;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.HighLevelDataType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemHierarchy;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.NamedSet;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectFactory;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubjectUsage;
import com.ibm.bi.platform.moser.common.generated.metadata.RegularAggregateType;
import com.ibm.bi.platform.moser.common.generated.metadata.UsageType;
import com.ibm.bi.platform.moser.common.utils.FormatConverter;
import com.ibm.bi.platform.moser.common.utils.IdentifierUtil;
import com.ibm.bi.platform.moser.common.utils.MoserCommonUtils;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.common.utils.MoserObjectUtils;
import com.ibm.bi.platform.moser.core.metadata.ModuleContentViewer;
import com.ibm.bi.platform.moser.core.metadata.util.IResolver;
import com.ibm.bi.platform.moser.core.metadata.util.ModuleWrapper;
import com.ibm.bi.platform.moser.core.module.util.ModuleUtil;
import com.ibm.bi.platform.moser.core.translator.report.query.DataItem;
import com.ibm.bi.platform.moser.core.translator.report.query.Query;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ReferenceResolver
implements IResolver {
    @Deprecated
    public static final String DT_CATEGORY_NUMBER = "number";
    private static final HashSet<String> FACET_DT = new HashSet();
    protected boolean bHasResolved = false;
    protected ModuleWrapper theWrapper = null;
    private final boolean generateShortIdForExpr;
    private ArrayList<ObjectType> objectInThisModule = new ArrayList();
    protected HashMap<QuerySubject, QuerySubject> thisQSRefMap = new HashMap();
    protected HashMap<QueryItem, QueryItem> thisQItemRefMap = new HashMap();
    protected TreeMap<String, QuerySubject> querySubjectRef = new TreeMap();
    protected TreeMap<String, Calculation> calculationRef = new TreeMap();
    protected TreeMap<String, Filter> filterRef = new TreeMap();

    public ReferenceResolver(boolean shortIdForExpr) {
        this.generateShortIdForExpr = shortIdForExpr;
    }

    @Override
    public boolean hasResolved() {
        return this.bHasResolved;
    }

    @Override
    public String getResolveOptionName() {
        return "resolveRef";
    }

    @Override
    public boolean initialize(ModuleWrapper wrapper) {
        this.theWrapper = wrapper;
        return true;
    }

    @Override
    public void resolve(BaseObjectType obj) {
        Set<ModuleContentViewer.ADVANCED_ACTION> advanced;
        if (this.theWrapper.isTopModule() && (obj instanceof QueryItem || obj instanceof ItemHierarchy) || obj instanceof Calculation || obj instanceof Filter || obj instanceof ItemType.Folder || obj instanceof NamedSet) {
            this.objectInThisModule.add((ObjectType)obj);
        }
        if (!this.theWrapper.isBaseModule() && (advanced = this.theWrapper.getMetadataResponseGenerator().getAdvancedAction()).contains((Object)ModuleContentViewer.ADVANCED_ACTION.COPY_MISSING_PROPERTY)) {
            if (obj instanceof QuerySubject) {
                this.resolveQuerySubjectProperties((QuerySubject)obj);
            } else if (obj instanceof QueryItem) {
                this.resolveQueryItemProperties((QueryItem)obj);
            }
        }
    }

    @Override
    public void resolveObjectRef(FolderItemType wp) {
        Set<ModuleContentViewer.ADVANCED_ACTION> advanced;
        if (this.theWrapper.isTopModule() && (advanced = this.theWrapper.getMetadataResponseGenerator().getAdvancedAction()).contains((Object)ModuleContentViewer.ADVANCED_ACTION.COPY_REF_OBJECT_IN_MDTV)) {
            this.collectReferencedObjectInSourceModules(wp);
        }
    }

    @Override
    public void postVisit() {
        this.generateMetadataResonseProperties();
        this.cloneReferencedObjects();
    }

    protected void generateMetadataResonseProperties() {
        FormatConverter fc = new FormatConverter();
        HashSet<QuerySubject> allQSs = new HashSet<QuerySubject>();
        for (ObjectType obj : this.objectInThisModule) {
            BaseObjectType parent;
            if (obj instanceof QueryItem) {
                String baseRid;
                QueryItem qi = (QueryItem)obj;
                parent = this.theWrapper.getParent((BaseObjectType)qi);
                while (parent instanceof ItemType.Folder) {
                    parent = this.theWrapper.getParent(parent);
                }
                if (!(parent instanceof QuerySubject) && !(parent instanceof QueryItem)) {
                    throw new MoserException(MoserError.INTERNAL_ERROR);
                }
                if (parent instanceof QuerySubject) {
                    QuerySubject qs = (QuerySubject)parent;
                    allQSs.add(qs);
                    baseRid = this.generateIdForExpression((ObjectType)qs);
                } else {
                    baseRid = ((QueryItem)parent).getIdForExpression();
                }
                qi.setIdForExpression(baseRid + "." + qi.getIdentifier());
                HighLevelDataType highlevelDatatype = MoserCommonUtils.generateHighlevelDatatype((String)qi.getDatatype());
                qi.setHighlevelDatatype(highlevelDatatype);
                qi.setDatatypeCategory(ReferenceResolver.converToDatatypeCategory(highlevelDatatype));
                ReferenceResolver.resolveQueryItemFacetDefinition(qi);
                if (qi.getFormat() == null) continue;
                String format = fc.convert(qi.getFormat());
                qi.setFormat(format);
                continue;
            }
            if (obj instanceof Calculation || obj instanceof Filter || obj instanceof NamedSet || obj instanceof ItemType.Folder) {
                String rid = this.generateIdForExpression(obj);
                if (obj instanceof Calculation) {
                    Calculation calc = (Calculation)obj;
                    calc.setHighlevelDatatype(MoserCommonUtils.generateHighlevelDatatype((String)calc.getDatatype()));
                    if (calc.getFormat() != null) {
                        String format = fc.convert(calc.getFormat());
                        calc.setFormat(format);
                    }
                } else if (obj instanceof Filter) {
                    parent = this.theWrapper.getParent((BaseObjectType)obj);
                    while (parent instanceof ItemType.Folder) {
                        parent = this.theWrapper.getParent(parent);
                    }
                    if (parent instanceof QuerySubject) {
                        allQSs.add((QuerySubject)parent);
                        rid = this.generateIdForExpression((ObjectType)parent) + "." + obj.getIdentifier();
                    } else if (parent instanceof QueryItem) {
                        rid = ((QueryItem)parent).getIdForExpression() + "." + obj.getIdentifier();
                    }
                }
                obj.setIdForExpression(rid);
                continue;
            }
            if (obj instanceof ItemHierarchy) {
                ItemHierarchy ih = (ItemHierarchy)obj;
                parent = this.theWrapper.getParent((BaseObjectType)ih);
                if (parent == null || !(parent instanceof QuerySubject)) {
                    throw new MoserException(MoserError.INTERNAL_ERROR);
                }
                QuerySubject qs = (QuerySubject)parent;
                allQSs.add(qs);
                String baseRid = this.generateIdForExpression((ObjectType)qs);
                ih.setIdForExpression(baseRid + "." + ih.getIdentifier());
                continue;
            }
            throw new MoserException(MoserError.INTERNAL_ERROR);
        }
        for (QuerySubject qs : allQSs) {
            qs.setIdForExpression(this.generateIdForExpression((ObjectType)qs));
        }
    }

    private String generateIdForExpression(ObjectType obj) {
        return ReferenceResolver.generateIdForExpression(this.theWrapper.getModule(), this.generateShortIdForExpr, obj);
    }

    public static String generateIdForExpression(Module module, boolean shortId, ObjectType obj) {
        String ret = "";
        if (!shortId) {
            ret = module.getContainer() + "." + module.getIdentifier() + ".";
        }
        if (obj != null) {
            ret = ret + obj.getIdentifier();
        }
        return ret;
    }

    public static void resolveQueryItemFacetDefinition(QueryItem qi) {
        FacetType facet = qi.getFacetDefinition();
        ObjectFactory factory = new ObjectFactory();
        if (facet != null) {
            FacetTypeEnabled enabled = facet.getEnabled();
            if (enabled == null || enabled.equals((Object)FacetTypeEnabled.AUTOMATIC)) {
                enabled = ReferenceResolver.resolveAutomatic(qi);
                facet.setEnabled(enabled);
            }
        } else {
            facet = factory.createFacetType();
            qi.setFacetDefinition(facet);
            FacetTypeEnabled enabled = ReferenceResolver.resolveAutomatic(qi);
            facet.setEnabled(enabled);
        }
    }

    public static FacetTypeEnabled resolveAutomatic(QueryItem qi) {
        UsageType usage = qi.getUsage();
        if (!UsageType.ATTRIBUTE.equals((Object)usage) && !UsageType.IDENTIFIER.equals((Object)usage)) {
            return FacetTypeEnabled.FALSE;
        }
        String dataType = qi.getDatatype();
        if (dataType == null) {
            return FacetTypeEnabled.FALSE;
        }
        if (FACET_DT.contains(MoserCommonUtils.getJMDDataTypeName((String)dataType))) {
            return FacetTypeEnabled.AUTOMATIC;
        }
        return FacetTypeEnabled.FALSE;
    }

    public static String generateDatatypeCategory(String dataType) {
        HighLevelDataType highlevelDatatype = MoserCommonUtils.generateHighlevelDatatype((String)dataType);
        return ReferenceResolver.converToDatatypeCategory(highlevelDatatype);
    }

    private static String converToDatatypeCategory(HighLevelDataType highlevelDatatype) {
        if (highlevelDatatype == null) {
            return null;
        }
        switch (highlevelDatatype) {
            case INTEGER: 
            case DECIMAL: {
                return DT_CATEGORY_NUMBER;
            }
            case DATE: 
            case TIME: {
                return HighLevelDataType.DATETIME.value();
            }
        }
        return highlevelDatatype.value();
    }

    protected void resolveQuerySubjectProperties(QuerySubject qs) {
        Class[] srcClasses;
        String numOfRows = qs.getNumberOfRows();
        if (numOfRows != null) {
            return;
        }
        List refs = qs.getRef();
        if (refs.size() != 1) {
            return;
        }
        if (!qs.getFilter().isEmpty() || QuerySubjectUsage.SUMMARY_QUERY.equals((Object)qs.getQuerySubjectUsage())) {
            return;
        }
        String ref = (String)refs.get(0);
        Class[] qsClasses = new Class[]{QuerySubject.class};
        String[] refPath = ref.split("\\.");
        QuerySubject srcQs = (QuerySubject)this.theWrapper.findObject(refPath, qsClasses);
        if (srcQs != null) {
            this.thisQSRefMap.put(qs, srcQs);
            return;
        }
        String[] rtPath = new String[]{null};
        ModuleWrapper srcWrapper = this.theWrapper.getModuleWrapperByAlias(refPath, rtPath);
        if (srcWrapper == null) {
            return;
        }
        refPath = rtPath[0].split("\\.");
        BaseObjectType srcObj = srcWrapper.findObject(refPath, srcClasses = new Class[]{QuerySubject.class});
        if (srcObj == null) {
            return;
        }
        QuerySubject srcQS = (QuerySubject)srcObj;
        String numRows = srcQS.getNumberOfRows();
        if (numRows != null) {
            qs.setNumberOfRows(numRows);
            this.bHasResolved = true;
        }
    }

    protected void resolveQueryItemProperties(QueryItem qi) {
        RegularAggregateType aggrType;
        Boolean bIsNullable;
        String dt;
        Class[] srcClasses;
        String[] rtPath;
        ModuleWrapper srcWrapper;
        List refs;
        String expr = qi.getExpression();
        String[] refPath = this.getIdentifier(expr);
        if (refPath == null) {
            return;
        }
        if (!this.missingQueryItemProperty(qi)) {
            return;
        }
        BaseObjectType parent = this.theWrapper.getParent((BaseObjectType)qi);
        while (parent instanceof ItemType.Folder) {
            parent = this.theWrapper.getParent(parent);
        }
        if (!(parent instanceof QuerySubject)) {
            throw new MoserException(MoserError.INTERNAL_ERROR);
        }
        QuerySubject qs = (QuerySubject)parent;
        if (refPath.length == 1) {
            for (QueryItem aQI : MoserObjectUtils.getQueryItems((QuerySubject)qs)) {
                if (aQI == qi || !aQI.getIdentifier().equals(refPath[0])) continue;
                this.thisQItemRefMap.put(qi, aQI);
                return;
            }
        } else {
            Class[] qiClasses = new Class[]{QueryItem.class, DataItem.class};
            QueryItem srcQI = (QueryItem)this.theWrapper.findObject(refPath, qiClasses);
            if (srcQI != null) {
                this.thisQItemRefMap.put(qi, srcQI);
                return;
            }
        }
        if (refPath.length == 1 && (refs = qs.getRef()).size() == 1) {
            String[] qsRef = ((String)refs.get(0)).split("\\.");
            String[] newRefPath = new String[qsRef.length + 1];
            System.arraycopy(qsRef, 0, newRefPath, 0, qsRef.length);
            newRefPath[newRefPath.length - 1] = refPath[0];
            refPath = newRefPath;
        }
        if ((srcWrapper = this.theWrapper.getModuleWrapperByAlias(refPath, rtPath = new String[]{null})) == null) {
            return;
        }
        refPath = rtPath[0].split("\\.");
        BaseObjectType srcObj = srcWrapper.findObject(refPath, srcClasses = new Class[]{QueryItem.class, DataItem.class});
        if (srcObj == null) {
            return;
        }
        QueryItem srcQI = (QueryItem)srcObj;
        UsageType usage = srcQI.getUsage();
        if (usage != null && qi.getUsage() == null) {
            qi.setUsage(usage);
            this.bHasResolved = true;
        }
        if ((dt = srcQI.getDatatype()) != null && qi.getDatatype() == null) {
            qi.setDatatype(dt);
            this.bHasResolved = true;
        }
        if ((bIsNullable = srcQI.isNullable()) != null && qi.isNullable() == null) {
            qi.setNullable(bIsNullable);
            this.bHasResolved = true;
        }
        if ((aggrType = srcQI.getRegularAggregate()) != null && qi.getRegularAggregate() == null) {
            qi.setRegularAggregate(aggrType);
            this.bHasResolved = true;
        }
    }

    protected boolean missingQueryItemProperty(QueryItem qi) {
        if (qi.getUsage() == null) {
            return true;
        }
        if (qi.getDatatype() == null) {
            return true;
        }
        if (qi.isNullable() == null) {
            return true;
        }
        return qi.getRegularAggregate() == null;
    }

    protected void collectReferencedObjectInSourceModules(FolderItemType wp) {
        if (!this.theWrapper.isTopModule()) {
            return;
        }
        String sRef = wp.getRef();
        if (sRef == null || sRef.isEmpty()) {
            return;
        }
        Class[] classes = new Class[]{QuerySubject.class, Calculation.class, Filter.class, Query.class};
        String[] refPath = sRef.split("\\.");
        BaseObjectType src = this.theWrapper.findObject(refPath, classes);
        if (src != null) {
            return;
        }
        String[] rtPath = new String[]{null};
        ModuleWrapper srcWrapper = this.theWrapper.getModuleWrapperByAlias(refPath, rtPath);
        if (srcWrapper == null) {
            return;
        }
        refPath = rtPath[0].split("\\.");
        src = srcWrapper.findObject(refPath, classes);
        if (src == null) {
            throw new MoserException(MoserError.MSR_GE_AMBIGUOS);
        }
        if (src instanceof QuerySubject) {
            this.querySubjectRef.put(sRef, (QuerySubject)src);
        } else if (src instanceof Calculation) {
            this.calculationRef.put(sRef, (Calculation)src);
        } else if (src instanceof Filter) {
            this.filterRef.put(sRef, (Filter)src);
        }
    }

    protected void cloneReferencedObjects() {
        QuerySubject src;
        for (Map.Entry<String, QuerySubject> entry : this.querySubjectRef.entrySet()) {
            String qsRef = entry.getKey();
            src = entry.getValue();
            QuerySubject qs = ModuleUtil.cloneQuerySubject(src);
            qs.setIdentifier(qsRef);
            String baseRid = qsRef;
            for (QueryItem qi : MoserObjectUtils.getQueryItems((QuerySubject)qs)) {
                qi.setIdForExpression(baseRid + "." + qi.getIdentifier());
                HighLevelDataType highlevelDatatype = MoserCommonUtils.generateHighlevelDatatype((String)qi.getDatatype());
                qi.setHighlevelDatatype(highlevelDatatype);
                qi.setDatatypeCategory(ReferenceResolver.converToDatatypeCategory(highlevelDatatype));
                ReferenceResolver.resolveQueryItemFacetDefinition(qi);
            }
            this.theWrapper.getModule().getQuerySubject().add(qs);
            this.bHasResolved = true;
        }
        for (Map.Entry<String, QuerySubject> entry : this.calculationRef.entrySet()) {
            String calcRef = entry.getKey();
            src = (Calculation)entry.getValue();
            Calculation calc = ModuleUtil.cloneCalculation((Calculation)src);
            calc.setIdentifier(calcRef);
            calc.setIdForExpression(calcRef);
            this.theWrapper.getModule().getCalculation().add(calc);
            this.bHasResolved = true;
        }
        for (Map.Entry<String, QuerySubject> entry : this.filterRef.entrySet()) {
            String fRef = entry.getKey();
            src = (Filter)entry.getValue();
            Filter filter = ModuleUtil.cloneFilter((Filter)src);
            filter.setIdentifier(fRef);
            filter.setIdForExpression(fRef);
            this.theWrapper.getModule().getFilter().add(filter);
            this.bHasResolved = true;
        }
    }

    protected String[] getIdentifier(String expr) {
        String[] ref;
        if (expr == null) {
            return null;
        }
        for (String s : ref = expr.split("\\.")) {
            if (s.isEmpty()) {
                return null;
            }
            if (IdentifierUtil.isValidIdentifier((String)s)) continue;
            return null;
        }
        return ref;
    }

    static {
        FACET_DT.add("CHAR");
        FACET_DT.add("LONGNVARCHAR");
        FACET_DT.add("LONGVARCHAR");
        FACET_DT.add("NCHAR");
        FACET_DT.add("NVARCHAR");
        FACET_DT.add("VARCHAR");
        FACET_DT.add("BIGINT");
        FACET_DT.add("INTEGER");
        FACET_DT.add("SMALLINT");
        FACET_DT.add("TINYINT");
        FACET_DT.add("DECIMAL");
        FACET_DT.add("LONG");
        FACET_DT.add("DATE");
        FACET_DT.add("TIME");
        FACET_DT.add("TIMESTAMP");
        FACET_DT.add("TIMESTAMP_TZ");
        FACET_DT.add("TIME_TZ");
        FACET_DT.add("INTERVAL_YEAR");
        FACET_DT.add("INTERVAL_YEAR_TO_MONTH");
        FACET_DT.add("INTERVAL_MONTH");
        FACET_DT.add("INTERVAL_DAY");
        FACET_DT.add("INTERVAL_DAY_TO_HOUR");
        FACET_DT.add("INTERVAL_DAY_TO_MINUTE");
        FACET_DT.add("INTERVAL_DAY_TO_SECOND");
        FACET_DT.add("INTERVAL_HOUR");
        FACET_DT.add("INTERVAL_HOUR_TO_MINUTE");
        FACET_DT.add("INTERVAL_HOUR_TO_SECOND");
        FACET_DT.add("INTERVAL_MINUTE");
        FACET_DT.add("INTERVAL_MINUTE_TO_SECOND");
        FACET_DT.add("INTERVAL_SECOND");
    }
}

