/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata.util;

import com.ibm.bi.platform.moser.common.generated.metadata.BaseObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.Calculation;
import com.ibm.bi.platform.moser.common.generated.metadata.DefLinkType;
import com.ibm.bi.platform.moser.common.generated.metadata.Filter;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.MoserObject;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.metadata.util.CommonResolverUtil;
import com.ibm.bi.platform.moser.core.metadata.util.IResolver;
import com.ibm.bi.platform.moser.core.metadata.util.ModuleWrapper;
import com.ibm.bi.platform.moser.core.module.util.ModuleUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ResolverUtil {
    public static final String DOT = "\\.";
    public static final String DOT_STR = ".";
    public static final String POUND_SIGN = "#";
    public static final String SUMMARY_QS = "summaryQuery";

    private ResolverUtil() {
    }

    public static void resolveReference(ModuleWrapper wrapper, IResolver resolver) {
        if (resolver.initialize(wrapper)) {
            HashSet<BaseObjectType> seenNodes = new HashSet<BaseObjectType>();
            ResolverUtil.walkTree(resolver, (BaseObjectType)wrapper.getModule(), wrapper.getExcludeNodes(), seenNodes);
        }
        resolver.postVisit();
    }

    public static List<Field> getAllFieldsListSkipMoserObject(Class<?> cls) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        for (Class<?> currentClass = cls; currentClass != null && !currentClass.equals(MoserObject.class); currentClass = currentClass.getSuperclass()) {
            Field[] declaredFields = currentClass.getDeclaredFields();
            Collections.addAll(allFields, declaredFields);
        }
        return allFields;
    }

    protected static void walkTree(IResolver resolver, BaseObjectType node, Set<BaseObjectType> excluded, Set<BaseObjectType> seenNodes) {
        if (excluded.contains(node)) {
            return;
        }
        if (seenNodes.contains(node)) {
            return;
        }
        seenNodes.add(node);
        resolver.resolve(node);
        Class<?> objClass = node.getClass();
        List<Field> fields = ResolverUtil.getAllFieldsListSkipMoserObject(objClass);
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                Object obj = field.get(node);
                if (obj instanceof BaseObjectType) {
                    ResolverUtil.walkTree(resolver, (BaseObjectType)obj, excluded, seenNodes);
                    continue;
                }
                if (!(obj instanceof List)) continue;
                List list = (List)obj;
                for (Object child : list) {
                    if (child instanceof BaseObjectType) {
                        ResolverUtil.walkTree(resolver, (BaseObjectType)child, excluded, seenNodes);
                        continue;
                    }
                    if (child instanceof FolderItemType) {
                        FolderItemType wp = (FolderItemType)child;
                        FolderType f = wp.getFolder();
                        if (f != null) {
                            ResolverUtil.walkTree(resolver, (BaseObjectType)f, excluded, seenNodes);
                            continue;
                        }
                        resolver.resolveObjectRef(wp);
                        continue;
                    }
                    if (!(child instanceof ItemType)) continue;
                    ItemType item = (ItemType)child;
                    ResolverUtil.walkTree(resolver, (BaseObjectType)ResolverUtil.getObject(item), excluded, seenNodes);
                }
            }
            catch (IllegalAccessException ex) {
                throw new MoserException((Throwable)ex);
            }
        }
    }

    public static ObjectType getObject(ItemType item) {
        if (item.getQueryItem() != null) {
            return item.getQueryItem();
        }
        if (item.getFilter() != null) {
            return item.getFilter();
        }
        if (item.getFolder() != null) {
            return item.getFolder();
        }
        if (item.getNamedSet() != null) {
            return item.getNamedSet();
        }
        if (item.getItemHierarchy() != null) {
            return item.getItemHierarchy();
        }
        if (item.getCalculation() != null) {
            return item.getCalculation();
        }
        return null;
    }

    public static void getNodesFromFMPackage(Module m, Set<BaseObjectType> excludeNodes) {
        List useSpecs = m.getUseSpec();
        for (Module.UseSpec u : useSpecs) {
            FolderType ph;
            if (!ModuleUtil.isPackageOrLWModule(u.getType()) || (ph = CommonResolverUtil.getFMPlaceHolderInMDTV((Module)m, (String)u.getIdentifier())) == null) continue;
            excludeNodes.add((BaseObjectType)ph);
            HashSet<String> internalIds = new HashSet<String>();
            ResolverUtil.getInternalIdsFromDefLink(ph.getFolderItem(), internalIds);
            for (QuerySubject qs : m.getQuerySubject()) {
                if (!internalIds.contains(qs.getIdentifier())) continue;
                excludeNodes.add((BaseObjectType)qs);
            }
            for (Calculation c : m.getCalculation()) {
                if (!internalIds.contains(c.getIdentifier())) continue;
                excludeNodes.add((BaseObjectType)c);
            }
            for (Filter f : m.getFilter()) {
                if (!internalIds.contains(f.getIdentifier())) continue;
                excludeNodes.add((BaseObjectType)f);
            }
            for (Filter f : m.getNamedSet()) {
                if (!internalIds.contains(f.getIdentifier())) continue;
                excludeNodes.add((BaseObjectType)f);
            }
        }
    }

    protected static void getInternalIdsFromDefLink(List<FolderItemType> items, Set<String> internalIds) {
        for (FolderItemType itm : items) {
            FolderType c = itm.getFolder();
            if (c != null) {
                ResolverUtil.getInternalIdsFromDefLink(c.getFolderItem(), internalIds);
                continue;
            }
            DefLinkType lnk = itm.getDefLink();
            if (lnk == null) continue;
            internalIds.add(lnk.getRef());
        }
    }
}

